// ============================================================================
// File:               $File$
//
// Project:            
//
// Purpose:            
//
// Author:             Rammi
//
// Copyright Notice:   (c) 2008  Rammi (rammi@caff.de)
//                     This code is in the public domain.
//                     Use at own risk.
//                     No guarantees given.
//
// Latest change:      $Date$
//
// History:	       $Log$
//=============================================================================
package de.caff.asteroid;

import java.awt.*;

/**
 *  Some useful constants of the Asteroids game.
 *
 *  This class is part of a solution for a
 *  <a href="http://www.heise.de/ct/creativ/08/02/details/">competition by the German computer magazine c't</a>.
 */
public interface GameData
{
  /** Size of the vector ram. */
  int VECTORRAM_SIZE = 1024;
  /** Extent of x and y coordinates. */
  int EXTENT = 1024;
  /** Border above and below y because of 4/3 screen aspect ratio. */
  int BORDER_Y = EXTENT/8;
  /** The minimal y coordinate used. */
  int MIN_Y = BORDER_Y;
  /** The screen extend in x direction. */
  int EXTENT_X = EXTENT;
  /** The screen extent in y direction. */
  int EXTENT_Y = EXTENT - 2*BORDER_Y;
  /** The maximal y coordinate used. */
  int MAX_Y = BORDER_Y + EXTENT_Y - 1;
  /** Screen has additional border in horizontal direction. */
  int SCREEN_WIDTH = EXTENT_X + 21;
  /** Screen has additional border in vertical direction. */
  int SCREEN_HEIGHT = EXTENT_Y + 21;
  /** No button pressed. */
  int NO_BUTTON         = 0;
  /** Hyperspace button pressed. */
  int BUTTON_HYPERSPACE = 0x01;
  /** Fire button pressed. */
  int BUTTON_FIRE       = 0x01 << 1;
  /** Thrust button pressed. */
  int BUTTON_THRUST     = 0x01 << 2;
  /** Left button pressed. */
  int BUTTON_RIGHT      = 0x01 << 3;
  /** Right button pressed. */
  int BUTTON_LEFT       = 0x01 << 4;
  /** Start button pressed (requires mameaster patch). */
  int BUTTON_START      = 0x01 << 5;
  /** The number of buttons. */
  int NR_BUTTONS = 6;
  /** Port used by mame. */
  int MAME_PORT = 1979;
  /** Location of score text during play. */
  Point SCORE_LOCATION_OTHER = new Point(160, 852);
  /** Location of score text in highscore and teaser display. */
  Point SCORE_LOCATION_GAME  = new Point(100, 876);
  /** Highscore location in game. */
  Point HIGHSCORE_LOCATION   = new Point(480, 876);
  /** Location of 'some other number in right top'. */
  Point SONIRT_LOCATION      = new Point(768, 876);
  /** Location of name input for hall of fame. */
  Point NAME_INPUT_LOCATION  = new Point(400, 228);
  /** The size of the complete datagramm packet from MAME (vector ram + id + ping). */
  int MAME_DATAGRAM_SIZE  = VECTORRAM_SIZE + 2;
  /** Size of a key frame. */
  int KEY_PACKET_SIZE = 8;
  /** Key datagram packet intro. */
  byte[] KEY_PACKET_INTRO = new byte[] { 'c', 't', 'm', 'a', 'm', 'e' };
  /** Size of name send frame (only online). */
  int NAME_PACKET_SIZE = 38;
  /** Key datagram packet intro. */
  byte[] NAME_PACKET_INTRO = new byte[] { 'c', 't', 'n', 'a', 'm', 'e' };
  /** Prefix of answer if server is busy (only online). */
  byte[] MAME_BUSY_PREFIX = new byte[] { 'b', 'u', 's', 'y', ' ' };
  /** Content of anser if server says that game is over. */
  byte[] MAME_GAME_OVER_DATA = new byte[] { 'g', 'a', 'm', 'e', ' ', 'o', 'v', 'e', 'r', '\r', '\n' };
  /** Index of key byte in key datagram packet. */
  int KEY_MASK_INDEX = KEY_PACKET_INTRO.length;
  /** Index of ping byte in key datagram packet. */
  int KEY_PING_INDEX = KEY_MASK_INDEX + 1;
  /** Ping in receive frame when no ping was sent. */
  int NO_PING = 0;
  /** Number of frames per second (not perfectly true, but assumed by c't). */
  int FRAMES_PER_SECOND = 60;
  /** Number when the score wraps to 0. */
  int GAME_SCORE_WRAP = 100000;
  /** Maximal number of asteroids. */
  int MAX_NUMBER_ASTEROIDS = 26;
}
