/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.swing.RJMenuItem;
import de.caff.util.settings.ColorPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditablePreferenceProperty;
import de.caff.util.settings.swing.ColorEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;

public class SwingColorPreferenceProperty
extends AbstractBasicSimpleEditablePreferenceProperty
implements ColorPreferenceProperty {
    private Color value;

    public SwingColorPreferenceProperty(String basicName, String baseTag, Color defaultValue) {
        super(basicName, baseTag);
        this.value = defaultValue;
    }

    public void readFrom(Preferences preferences) {
        this.setValue(new Color(preferences.getInt(this.getBasicName(), this.value != null ? this.value.getRGB() : 0)));
    }

    public void storeTo(Preferences preferences) {
        if (this.value == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.putInt(this.getBasicName(), this.value.getRGB());
        }
    }

    public EditorProvider getEditorProvider(Locale l) {
        return new ColorEditor(this, l);
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color value) {
        if (value != null ? !value.equals(this.value) : this.value != null) {
            Color oldColor = this.value;
            this.value = value;
            this.fireValueChange(this.getBasicName(), oldColor, value);
        }
    }

    public JMenuItem createMenuItem(String tag, Color color, Locale l) {
        return new SpecialMenuItem(tag, color, l);
    }

    private class SpecialMenuItem
    extends RJMenuItem
    implements PropertyChangeListener {
        private Color color;

        public SpecialMenuItem(String tag, Color color, Locale l) {
            super(tag, l);
            this.color = color;
            this.setIcon(ColorEditor.createColoredIcon(color));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingColorPreferenceProperty.this.setValue(SpecialMenuItem.this.color);
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Color newColor = (Color)evt.getNewValue();
            this.handleNewColor(newColor);
        }

        private void handleNewColor(Color newColor) {
            this.setEnabled(!this.color.equals(newColor));
        }

        public void addNotify() {
            super.addNotify();
            SwingColorPreferenceProperty.this.addValueChangeListener(this);
            this.handleNewColor(SwingColorPreferenceProperty.this.getValue());
        }

        public void removeNotify() {
            super.removeNotify();
            SwingColorPreferenceProperty.this.removeValueChangeListener(this);
        }
    }
}

