/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import java.util.prefs.Preferences;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;

public class PrintRequestProperties
extends HashPrintRequestAttributeSet {
    public static final String PREF_KEY_EXT_CLASS = ".class";
    public static final String PREF_KEY_MEDIA = "print.media";
    public static final EnumAttributeFinder[] MEDIA_FINDER = new EnumAttributeFinder[]{new MediaSizeNameHelper(), new MediaNameHelper(), new MediaTrayHelper()};
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_X = "print.area.x";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_Y = "print.area.y";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH = "print.area.w";
    public static final String PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT = "print.area.h";
    public static final String PREF_KEY_JOB_SHEETS = "print.jobsheets";
    public static final EnumAttributeFinder JOB_SHEETS_FINDER = new JobSheetsHelper();
    public static final String PREF_KEY_CHROMATICITY = "print.chromaticity";
    public static final Chromaticity[] CHROMATICITY_VALUES = new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR};
    public static final String PREF_KEY_ORIENTATION = "print.orientation";
    public static final OrientationRequested[] ORIENTATION_VALUES = new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT};

    public PrintRequestProperties() {
    }

    public PrintRequestProperties(Preferences preferences) {
        this.loadFrom(preferences);
    }

    public PrintRequestProperties(PrintRequestAttribute attribute) {
        super(attribute);
    }

    public PrintRequestProperties(PrintRequestAttribute[] attributes) {
        super(attributes);
    }

    public PrintRequestProperties(PrintRequestAttributeSet attributes) {
        super(attributes);
    }

    public void storeTo(Preferences preferences) {
        this.storeEnumValue(preferences, PREF_KEY_MEDIA, Media.class);
        this.storeEnumValue(preferences, PREF_KEY_JOB_SHEETS, JobSheets.class);
        this.storeEnumValue(preferences, PREF_KEY_ORIENTATION, OrientationRequested.class);
        MediaPrintableArea area = (MediaPrintableArea)this.get(MediaPrintableArea.class);
        if (area != null) {
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_X, area.getX(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_Y, area.getY(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH, area.getWidth(1000));
            preferences.putFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT, area.getHeight(1000));
        } else {
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_X);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_Y);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH);
            preferences.remove(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT);
        }
        Chromaticity chroma = (Chromaticity)this.get(Chromaticity.class);
        if (chroma != null) {
            preferences.putInt(PREF_KEY_CHROMATICITY, chroma.getValue());
        } else {
            preferences.remove(PREF_KEY_CHROMATICITY);
        }
    }

    public void loadFrom(Preferences preferences) {
        this.loadEnumValue(preferences, PREF_KEY_MEDIA, MEDIA_FINDER);
        this.loadEnumValue(preferences, PREF_KEY_JOB_SHEETS, JOB_SHEETS_FINDER);
        this.loadFinalValue(preferences, PREF_KEY_ORIENTATION, ORIENTATION_VALUES, ORIENTATION_VALUES);
        this.loadFinalValue(preferences, PREF_KEY_CHROMATICITY, CHROMATICITY_VALUES, CHROMATICITY_VALUES);
        float x = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_X, Float.NEGATIVE_INFINITY);
        float y = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_Y, Float.NEGATIVE_INFINITY);
        float w = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_WIDTH, Float.NEGATIVE_INFINITY);
        float h = preferences.getFloat(PREF_KEY_MEDIA_PRINTABLE_AREA_HEIGHT, Float.NEGATIVE_INFINITY);
        if (x != Float.NEGATIVE_INFINITY && y != Float.NEGATIVE_INFINITY && w != Float.NEGATIVE_INFINITY && h != Float.NEGATIVE_INFINITY) {
            this.add(new MediaPrintableArea(x, y, w, h, 1000));
        }
    }

    private void loadFinalValue(Preferences preferences, String key, EnumSyntax[] values, PrintRequestAttribute[] attributes) {
        int v = preferences.getInt(key, Integer.MIN_VALUE);
        if (v != Integer.MIN_VALUE) {
            for (int c = 0; c < values.length; ++c) {
                if (values[c].getValue() != v) continue;
                this.add(attributes[c]);
                break;
            }
        }
    }

    private void storeEnumValue(Preferences preferences, String prefkey, Class key) {
        EnumSyntax enumSyntax = (EnumSyntax)((Object)this.get(key));
        if (enumSyntax != null) {
            preferences.put(prefkey + PREF_KEY_EXT_CLASS, enumSyntax.getClass().toString());
            preferences.putInt(prefkey, enumSyntax.getValue());
        } else {
            preferences.remove(prefkey + PREF_KEY_EXT_CLASS);
            preferences.remove(prefkey);
        }
    }

    private boolean loadEnumValue(Preferences preferences, String key, EnumAttributeFinder finder) {
        return this.loadEnumValue(preferences, key, new EnumAttributeFinder[]{finder});
    }

    private boolean loadEnumValue(Preferences preferences, String key, EnumAttributeFinder[] finder) {
        String classname = preferences.get(key + PREF_KEY_EXT_CLASS, null);
        if (classname != null) {
            for (int f = 0; f < finder.length; ++f) {
                Attribute enumValue;
                int value;
                if (!classname.equals(finder[f].getBasicClassname()) || (value = preferences.getInt(key, Integer.MIN_VALUE)) == Integer.MIN_VALUE || (enumValue = finder[f].getEnumValue(value)) == null) continue;
                this.add(enumValue);
                return true;
            }
        }
        return false;
    }

    private static class JobSheetsHelper
    extends JobSheets
    implements EnumAttributeFinder {
        public JobSheetsHelper() {
            super(Integer.MIN_VALUE);
        }

        public String getBasicClassname() {
            return JobSheets.class.toString();
        }

        public Attribute getEnumValue(int value) {
            EnumSyntax[] table = this.getEnumValueTable();
            for (int t = 0; t < table.length; ++t) {
                if (table[t].getValue() != value) continue;
                return (Attribute)((Object)table[t]);
            }
            return null;
        }

        public Object clone() {
            return this;
        }
    }

    private static class MediaTrayHelper
    extends MediaTray
    implements EnumAttributeFinder {
        public MediaTrayHelper() {
            super(Integer.MIN_VALUE);
        }

        public String getBasicClassname() {
            return MediaTray.class.toString();
        }

        public Attribute getEnumValue(int value) {
            return this.getMedia(value);
        }

        public Media getMedia(int value) {
            EnumSyntax[] table = this.getEnumValueTable();
            for (int t = 0; t < table.length; ++t) {
                if (table[t].getValue() != value) continue;
                return (Media)table[t];
            }
            return null;
        }

        public Object clone() {
            return this;
        }
    }

    private static class MediaNameHelper
    extends MediaName
    implements EnumAttributeFinder {
        public MediaNameHelper() {
            super(Integer.MIN_VALUE);
        }

        public String getBasicClassname() {
            return MediaName.class.toString();
        }

        public Attribute getEnumValue(int value) {
            return this.getMedia(value);
        }

        public Media getMedia(int value) {
            EnumSyntax[] table = this.getEnumValueTable();
            for (int t = 0; t < table.length; ++t) {
                if (table[t].getValue() != value) continue;
                return (Media)table[t];
            }
            return null;
        }

        public Object clone() {
            return this;
        }
    }

    private static class MediaSizeNameHelper
    extends MediaSizeName
    implements EnumAttributeFinder {
        public MediaSizeNameHelper() {
            super(Integer.MIN_VALUE);
        }

        public String getBasicClassname() {
            return MediaSizeName.class.toString();
        }

        public Attribute getEnumValue(int value) {
            return this.getMedia(value);
        }

        public Media getMedia(int value) {
            EnumSyntax[] table = this.getEnumValueTable();
            for (int t = 0; t < table.length; ++t) {
                if (table[t].getValue() != value) continue;
                return (Media)table[t];
            }
            return null;
        }

        public Object clone() {
            return this;
        }
    }

    private static interface EnumAttributeFinder
    extends Attribute {
        public String getBasicClassname();

        public Attribute getEnumValue(int var1);
    }
}

