/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.util.settings.AbstractBasicPreferenceProperty;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.prefs.Preferences;

public class BoundsPreferenceProperty
extends AbstractBasicPreferenceProperty {
    private static final String EXT_X = "-X";
    private static final String EXT_Y = "-Y";
    private static final String EXT_WIDTH = "-WIDTH";
    private static final String EXT_HEIGHT = "-HEIGHT";
    private Rectangle bounds;

    public BoundsPreferenceProperty(String basicName) {
        super(basicName);
    }

    public void readFrom(Preferences preferences) {
        String prefix = this.getBasicName();
        int w = preferences.getInt(prefix + EXT_WIDTH, 0);
        int h = preferences.getInt(prefix + EXT_HEIGHT, 0);
        if (w > 0 && h > 0) {
            int x = preferences.getInt(prefix + EXT_X, 0);
            int y = preferences.getInt(prefix + EXT_Y, 0);
            this.setBounds(new Rectangle(x, y, w, h));
        } else {
            this.setBounds((Rectangle)null);
        }
    }

    public void storeTo(Preferences preferences) {
        String prefix = this.getBasicName();
        if (this.bounds == null) {
            preferences.remove(prefix + EXT_X);
            preferences.remove(prefix + EXT_Y);
            preferences.remove(prefix + EXT_WIDTH);
            preferences.remove(prefix + EXT_HEIGHT);
        } else {
            preferences.putInt(prefix + EXT_X, this.bounds.x);
            preferences.putInt(prefix + EXT_Y, this.bounds.y);
            preferences.putInt(prefix + EXT_WIDTH, this.bounds.width);
            preferences.putInt(prefix + EXT_HEIGHT, this.bounds.height);
        }
    }

    public boolean setWindowBounds(Window window) {
        if (this.bounds != null) {
            window.setBounds(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            return true;
        }
        return false;
    }

    public void storeWindowBounds(Preferences preferences, Window window) {
        this.bounds = window.getBounds();
        this.storeTo(preferences);
    }

    public void setBounds(Rectangle bounds) {
        if (bounds == null) {
            if (this.bounds != null) {
                Rectangle oldBounds = this.bounds;
                this.bounds = null;
                this.fireValueChange(this.getBasicName(), oldBounds, bounds);
            }
        } else if (!bounds.equals(this.bounds)) {
            Rectangle oldBounds = this.bounds;
            this.bounds = new Rectangle(bounds);
            this.fireValueChange(this.getBasicName(), oldBounds, bounds);
        }
    }

    public void setBounds(Window window) {
        this.setBounds(window.getBounds());
    }
}

