/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

public class Format {
    private static final String NULL_STRING = "<null>";

    public static String format(Object mask, Object ... args) {
        String format = mask.toString();
        StringBuffer compiled = new StringBuffer();
        int length = format.length();
        boolean nextIsDigit = false;
        for (int index = 0; index < length; ++index) {
            char c = format.charAt(index);
            if (nextIsDigit) {
                nextIsDigit = false;
                if ('1' <= c && c <= '9') {
                    int arg = c - 49;
                    if (arg >= args.length) {
                        compiled.append("<%").append(c).append(" missing>");
                        continue;
                    }
                    compiled.append(Format.toString(args[arg]));
                    continue;
                }
                if (c == '%') {
                    compiled.append(c);
                    continue;
                }
                compiled.append('%').append(c);
                continue;
            }
            if (c == '%') {
                nextIsDigit = true;
                continue;
            }
            compiled.append(c);
        }
        return compiled.toString();
    }

    public static String format(Object format, Object arg1) {
        return Format.format(format, new Object[]{arg1});
    }

    public static String format(Object format, Object arg1, Object arg2) {
        return Format.format(format, new Object[]{arg1, arg2});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3) {
        return Format.format(format, new Object[]{arg1, arg2, arg3});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    public static String format(Object format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return Format.format(format, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9});
    }

    public static String toString(Object obj) {
        return Format.toString(obj, "{", ",", "}", "");
    }

    private static String toString(Object obj, String pre, String inter, String post, String indent) {
        StringBuffer buffer = new StringBuffer();
        if (obj == null) {
            return NULL_STRING;
        }
        Class<?> cl = obj.getClass();
        if (cl.isArray()) {
            buffer.append(pre);
            if (cl.getComponentType().isPrimitive()) {
                Class<?> prim = cl.getComponentType();
                if (prim == Integer.TYPE) {
                    int[] arr = (int[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Short.TYPE) {
                    short[] arr = (short[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Byte.TYPE) {
                    byte[] arr = (byte[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Long.TYPE) {
                    long[] arr = (long[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Character.TYPE) {
                    char[] arr = (char[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Boolean.TYPE) {
                    boolean[] arr = (boolean[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Float.TYPE) {
                    float[] arr = (float[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                } else if (prim == Double.TYPE) {
                    double[] arr = (double[])obj;
                    for (int a = 0; a < arr.length; ++a) {
                        buffer.append(arr[a]);
                        if (a == arr.length - 1) continue;
                        buffer.append(inter);
                    }
                }
            } else {
                Object[] arr = (Object[])obj;
                for (int a = 0; a < arr.length; ++a) {
                    buffer.append(Format.toString(arr[a], indent + pre, indent + inter, indent + post, indent));
                    if (a == arr.length - 1) continue;
                    buffer.append(inter);
                }
            }
            buffer.append(post);
            return buffer.toString();
        }
        return obj.toString();
    }

    public static int getMaxStringLength(String[] strings) {
        int len = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() <= len) continue;
            len = strings[i].length();
        }
        return len;
    }

    public static String rpad(String str, int length, String fill) {
        if (fill.length() > 0) {
            while (str.length() < length) {
                str = str + fill;
            }
        }
        if (str.length() > length) {
            str = str.substring(0, length);
        }
        return str;
    }

    public static String lpad(String str, int length, String fill) {
        if (fill.length() > 0) {
            while (str.length() < length) {
                str = fill + str;
            }
        }
        if (str.length() > length) {
            str = str.substring(str.length() - length, length + 1);
        }
        return str;
    }

    public static String center(String str, int length, String fill) {
        int leftMargin = (length - str.length()) / 2;
        return Format.lpad(str, str.length() + leftMargin, fill);
    }

    public static String replace(String str1, String str2, String str3) {
        String result = "";
        if (str1 != null && str2 != null && str3 != null && str2 != "") {
            String[] pieces = new String[str1.length()];
            int i = 0;
            while (str1.indexOf(str2) >= 0) {
                pieces[i++] = str1.substring(0, str1.indexOf(str2));
                str1 = str1.substring(str1.indexOf(str2) + str2.length());
            }
            for (int j = 0; j < i; ++j) {
                result = result + pieces[j] + str3;
            }
            result = result + str1;
        }
        return result;
    }

    public static String trimLeft(String str) {
        char ch;
        int pos;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (pos = 0; pos < length && (Character.isWhitespace(ch = str.charAt(pos)) || Character.isISOControl(ch)); ++pos) {
        }
        return str.substring(pos, length);
    }

    public static String trimRight(String str) {
        char ch;
        int pos;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (pos = length - 1; pos >= 0 && (Character.isWhitespace(ch = str.charAt(pos)) || Character.isISOControl(ch)); --pos) {
        }
        return str.substring(0, pos + 1);
    }

    public static void main(String[] args) {
        int[] iarr = new int[]{1, 2, 3};
        String[][] strarr = new String[][]{{"eins1", "eins2", "eins3"}, {"zwei1", "zwei2", "zwei3"}, {"drei1", "drei2", "drei3"}, null};
        System.out.println(Format.format((Object)"Integer array: %1", (Object)iarr));
        System.out.println(Format.toString(strarr, "{\n  ", ",\n  ", "\n}", "  "));
        if (!"abcxx".equals(Format.rpad("abc", 5, "x"))) {
            System.out.println("rpad has an error (1)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xx"))) {
            System.out.println("rpad has an error (2)");
        }
        if (!"abcxx".equals(Format.rpad("abc", 5, "xxxx"))) {
            System.out.println("rpad has an error (3)");
        }
        if (!"ab".equals(Format.rpad("abc", 2, "x"))) {
            System.out.println("rpad has an error (4)");
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "x"))) {
            System.out.println("lpad has an error (1) " + Format.lpad("abc", 5, "x"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xx"))) {
            System.out.println("lpad has an error (2) " + Format.lpad("abc", 5, "xx"));
        }
        if (!"xxabc".equals(Format.lpad("abc", 5, "xxx"))) {
            System.out.println("lpad has an error (3) " + Format.lpad("abc", 5, "xxx"));
        }
        if (!"bc".equals(Format.lpad("abc", 2, "x"))) {
            System.out.println("lpad has an error (4) " + Format.lpad("abc", 2, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 5, "x"))) {
            System.out.println("center has an error (1) " + Format.center("abc", 5, "x"));
        }
        if (!"xabc".equals(Format.center("abc", 6, "xx"))) {
            System.out.println("center has an error (2) " + Format.center("abc", 6, "xx"));
        }
        if (!"xxabc".equals(Format.center("abc", 7, "x"))) {
            System.out.println("center has an error (3) " + Format.center("abc", 7, "x"));
        }
        if (!"xxx".equals(Format.replace("xxx", "y", "z"))) {
            System.out.println("replace error (1) :" + Format.replace("xxx", "y", "z"));
        }
        if (!"zzz".equals(Format.replace("xxx", "x", "z"))) {
            System.out.println("replace error (2) :" + Format.replace("xxx", "x", "z"));
        }
        if (!"zx".equals(Format.replace("xyx", "xy", "z"))) {
            System.out.println("replace error (3) :" + Format.replace("xyx", "xy", "z"));
        }
        if (!"zz".equals(Format.replace("xyxy", "xy", "z"))) {
            System.out.println("replace error (4) :" + Format.replace("xyxy", "xy", "z"));
        }
        if (!"z234".equals(Format.replace("1234", "1", "z"))) {
            System.out.println("replace error (5) :" + Format.replace("1234", "1", "z"));
        }
        if (!"123z".equals(Format.replace("1234", "4", "z"))) {
            System.out.println("replace error (6) :" + Format.replace("1234", "4", "z"));
        }
    }
}

