/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Communication;
import de.caff.asteroid.GameData;
import de.caff.asteroid.HallOfFameFiller;
import de.caff.asteroid.PlayerStarter;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.LevelPauseGarbageCollector;
import de.caff.asteroid.rammi.MultiGamesPlayer;
import de.caff.asteroid.rammi.PlayerPreparer;

public class MultiPlayerStarter
implements PlayerStarter,
GameData {
    public void startPlayer(Communication com) {
        MultiGamesPlayer player = new MultiGamesPlayer(com, new RunOncePreparer());
        com.addFrameListener(player);
        com.addFrameListener(new LevelPauseGarbageCollector(com));
        com.addFrameListener(new HallOfFameFiller(com, "mul"));
    }

    private static class RunOncePreparer
    implements PlayerPreparer {
        boolean once = false;

        private RunOncePreparer() {
        }

        public String advance() {
            if (this.once) {
                return null;
            }
            this.once = true;
            return "Running Once";
        }

        public void prepare(AsteroidPlayer player) {
        }
    }

    private static class MaxVolleyCountPreparer
    implements PlayerPreparer {
        private int count = -1;

        private MaxVolleyCountPreparer() {
        }

        public String advance() {
            if (this.count <= 3) {
                ++this.count;
                return "MaxVolleyCount: " + this.count;
            }
            return null;
        }

        public void prepare(AsteroidPlayer player) {
            player.setMaxVolleyCount(this.count);
        }
    }

    private static class BlackoutFramesPreparer
    implements PlayerPreparer {
        int nrFrames = 0;

        private BlackoutFramesPreparer() {
        }

        public String advance() {
            if (this.nrFrames >= 10) {
                return null;
            }
            ++this.nrFrames;
            return "Blackout Frames: " + this.nrFrames;
        }

        public void prepare(AsteroidPlayer player) {
            player.setBlackoutFrames(this.nrFrames);
        }
    }

    private static class DangerFramesPreparer
    implements PlayerPreparer {
        private static final int[] SEQUENCE = new int[]{30, 45, 60, 90, 120, 150, 180};
        int index = -1;

        private DangerFramesPreparer() {
        }

        public String advance() {
            ++this.index;
            return this.index < SEQUENCE.length ? "Danger Frames: " + SEQUENCE[this.index] : null;
        }

        public void prepare(AsteroidPlayer player) {
            player.setDangerFrames(SEQUENCE[this.index]);
        }
    }

    private static class MinBorderPreparer
    implements PlayerPreparer {
        static int borderWidth = 100;
        int minBorder = 40;

        private MinBorderPreparer() {
        }

        public String advance() {
            if (this.minBorder >= 200) {
                return null;
            }
            this.minBorder += 20;
            return "Minimal Border: " + this.minBorder;
        }

        public void prepare(AsteroidPlayer player) {
            player.setMinBorder(this.minBorder);
            player.setMaxBorder(this.minBorder + borderWidth);
        }
    }

    private static class SmallUfoScorePreparer
    implements PlayerPreparer {
        private int score = -720;

        private SmallUfoScorePreparer() {
        }

        public String advance() {
            if (this.score == 0) {
                return null;
            }
            this.score /= 2;
            return "Small Ufo Score: " + this.score;
        }

        public void prepare(AsteroidPlayer player) {
            player.setSmallUfoScore(this.score);
        }
    }

    private static class MaxAsteroidPreparer
    implements PlayerPreparer {
        private int nr = 4;

        private MaxAsteroidPreparer() {
        }

        public String advance() {
            if (this.nr < 26) {
                ++this.nr;
                return String.format("Asteroids for multi shot: %d", this.nr);
            }
            return null;
        }

        public void prepare(AsteroidPlayer player) {
            player.setMaxAsteroidsForMultiShot(this.nr);
        }
    }
}

