/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.MemoryHog;
import de.caff.asteroid.rammi.PlayerPreparer;
import de.caff.asteroid.rammi.SuicidePlayer;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class MultiGamesPlayer
implements FrameListener {
    private static final int GAMES_TO_PLAY = 10;
    static final int FRAMES_COUNT = 10800;
    private Communication com;
    private AsteroidPlayer asteroidPlayer;
    private SuicidePlayer suicidePlayer;
    private int startFrame;
    private Writer writer;
    private int gamesToPlay = -1;
    private int score = 0;
    private PlayerPreparer preparer;
    private String note;
    private int maxScore = 0;
    private String maxNote;

    public MultiGamesPlayer(Communication com, PlayerPreparer preparer) {
        try {
            this.writer = new FileWriter("multi.out");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.com = com;
        this.suicidePlayer = new SuicidePlayer(com);
        com.addFrameListener(this.suicidePlayer);
        this.preparer = preparer;
        MemoryHog.oinkOink();
    }

    private void storeResults() {
        this.storeLine("---------------------------------------------------");
        this.storeLine("Average: " + (double)this.score / 10.0);
        this.storeLine("===================================================");
        if (this.score > this.maxScore) {
            this.maxScore = this.score;
            this.maxNote = this.note;
        }
    }

    private void storeLine(String line) {
        System.out.println(line);
        try {
            this.writer.append(line);
            this.writer.append("\n");
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private AsteroidPlayer getNextPlayer() {
        if (this.gamesToPlay-- > 0) {
            AsteroidPlayer player = new AsteroidPlayer(this.com);
            this.preparer.prepare(player);
            return player;
        }
        if (this.gamesToPlay == -1) {
            this.storeResults();
        }
        this.note = this.preparer.advance();
        if (this.note == null) {
            this.storeLine("Best setting: " + this.maxNote);
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(0);
            return null;
        }
        this.gamesToPlay = 10;
        this.score = 0;
        this.storeLine("===================================================");
        this.storeLine("Starting: " + this.note);
        this.storeLine("---------------------------------------------------");
        return this.getNextPlayer();
    }

    private void storeScore(int gameScore) {
        this.storeLine("Score: " + gameScore);
        this.score += gameScore;
    }

    public void frameReceived(FrameInfo frame) {
        if (frame.isGameEndDisplayed()) {
            if (this.asteroidPlayer != null) {
                this.com.removeFrameListener(this.asteroidPlayer);
                this.asteroidPlayer.destroy();
                this.asteroidPlayer = null;
                this.storeScore(frame.getScore());
            } else if (this.suicidePlayer != null) {
                this.com.removeFrameListener(this.suicidePlayer);
                this.suicidePlayer = null;
            }
        } else if (frame.isGameRunning()) {
            if (this.asteroidPlayer != null && frame.getIndex() - this.startFrame >= 10800) {
                this.com.removeFrameListener(this.asteroidPlayer);
                this.asteroidPlayer.destroy();
                this.asteroidPlayer = null;
                this.suicidePlayer = new SuicidePlayer(this.com);
                this.storeScore(frame.getScore());
                this.com.addFrameListener(this.suicidePlayer);
            }
        } else {
            this.startFrame = frame.getIndex();
            if (this.asteroidPlayer == null && this.suicidePlayer == null) {
                this.asteroidPlayer = this.getNextPlayer();
                this.com.addFrameListener(this.asteroidPlayer);
            }
        }
    }
}

