/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.rammi.AbstractBasicAsteroidPlayer;
import de.caff.asteroid.rammi.Futurologist;
import de.caff.asteroid.rammi.ImprovedVelocityPreparer;
import de.caff.asteroid.rammi.ShootingDirectionFixer;
import de.caff.asteroid.rammi.StandardFuturologist;
import de.caff.util.Tools;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FramesTillFirePlayer
extends AbstractBasicAsteroidPlayer
implements FrameListener {
    private static final int FUTURE_FRAMES = 60;
    private Futurologist futurologist = new StandardFuturologist();
    private ShootingDirectionFixer shootingDirectionFixer;

    public FramesTillFirePlayer(Communication com) {
        super(com);
        if (com != null) {
            this.shootingDirectionFixer = new ShootingDirectionFixer();
            com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new ImprovedVelocityPreparer(), new ScoreFixer(), this.shootingDirectionFixer}));
            com.addDatagramListener(this.shootingDirectionFixer);
        }
    }

    @Override
    public void destroy() {
        if (this.shootingDirectionFixer != null) {
            this.com.removeDatagramListener(this.shootingDirectionFixer);
            this.shootingDirectionFixer = null;
        }
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        this.futurologist.frameReceived(frame);
        SpaceShip ship = frame.getSpaceShip();
        if (ship != null) {
            if (this.hasIncomingDangerousAsteroids(frame, 2) || FramesTillFirePlayer.hasIncomingDangerousShots(frame, 2)) {
                this.pushButton(1);
            } else {
                this.getNextTargets(frame, ship);
            }
        }
    }

    private void getNextTargets(FrameInfo info, SpaceShip ship) {
        byte dirByte = info.getNextShootingDirectionLowLevel();
        TreeMap<Integer, PossibleTarget> targets = new TreeMap<Integer, PossibleTarget>();
        LinkedList<Asteroid> unhitAsteroids = new LinkedList<Asteroid>();
        for (Asteroid ast : info.getAsteroids()) {
            if (this.futurologist.getFramesTillDestroyed(ast, info) >= 0) continue;
            unhitAsteroids.add(ast);
        }
        Asteroid ast = FramesTillFirePlayer.findHitAsteroid(ship, FrameInfo.getShootingDirection(dirByte), unhitAsteroids, 1);
        if (ast != null) {
            targets.put(1, new PossibleTarget(dirByte, ast));
        }
        for (int f = 1; f <= 60 && !unhitAsteroids.isEmpty(); ++f) {
            for (int dir = -1; dir <= 1; dir += 2) {
                ast = FramesTillFirePlayer.findHitAsteroid(ship, FrameInfo.getShootingDirection(dirByte + dir), unhitAsteroids, f);
                if (ast == null) continue;
                targets.put(f, new PossibleTarget(dirByte + dir, ast));
            }
        }
        if (!targets.isEmpty()) {
            PossibleTarget target = (PossibleTarget)targets.remove(targets.firstKey());
            if (target.getRotation() == 0 && !this.haveFiredInLastFrame()) {
                this.pushButton(2);
            } else if (!targets.isEmpty()) {
                target = (PossibleTarget)targets.get(targets.firstKey());
                if (target.getRotation() < 0) {
                    this.pushButton(8);
                } else {
                    this.pushButton(16);
                }
            }
        }
    }

    private static Asteroid findHitAsteroid(SpaceShip ship, FrameInfo.Direction shootDir, List<Asteroid> unhitAsteroids, int frames) {
        Point shipPos = ship.getPredictedLocation(frames);
        Point bulletPos = new Point(shipPos.x + shootDir.getDisplacement().x, shipPos.y + shootDir.getDisplacement().y);
        Point2D.Double bulletVelocity = new Point2D.Double(ship.getVelocityX() + shootDir.getBulletVelocity().getX(), ship.getVelocityY() + shootDir.getBulletVelocity().getY());
        for (int f = 0; f < 69; ++f) {
            ListIterator<Asteroid> it = unhitAsteroids.listIterator();
            while (it.hasNext()) {
                Asteroid ast = it.next();
                Point p = ast.getPredictedLocation(f + frames);
                Point delta = GameObject.getTorusDelta(p.x, p.y, (int)((Point2D)bulletPos).getX(), (int)((Point2D)bulletPos).getY());
                if (!(Tools.getSquaredLength(delta) < (double)ast.getSquaredSize())) continue;
                it.remove();
                return ast;
            }
            ((Point2D)bulletPos).setLocation(((Point2D)bulletPos).getX() + ((Point2D)bulletVelocity).getX(), ((Point2D)bulletPos).getY() + ((Point2D)bulletVelocity).getY());
        }
        return null;
    }

    private static boolean hasIncomingDangerousShots(FrameInfo info, int predictionLag) {
        SpaceShip ship = info.getSpaceShip();
        Point sPos = ship.getPredictedLocation(predictionLag);
        int size = ship.getSize();
        for (Bullet bullet : info.getBullets()) {
            if (bullet.getVelocityX() == 0.0 && bullet.getVelocityY() == 0.0) continue;
            Point distance = GameObject.getTorusDelta(bullet.getPredictedLocation(predictionLag), sPos);
            if (Math.abs(distance.x) > size || Math.abs(distance.y) > size) continue;
            return true;
        }
        return false;
    }

    private boolean hasIncomingDangerousAsteroids(FrameInfo info, int predictionLag) {
        SpaceShip ship = info.getSpaceShip();
        for (Asteroid ast : info.getAsteroids()) {
            double hitFrames;
            int framesTillDestroyed = this.futurologist.getFramesTillDestroyed(ast, info);
            if (framesTillDestroyed >= 0 && framesTillDestroyed <= predictionLag || !((hitFrames = (double)FramesTillFirePlayer.getFramesUntilCollision(ship, ast, predictionLag)) > 0.0) || !(hitFrames <= (double)predictionLag)) continue;
            return true;
        }
        return false;
    }

    static class PossibleTarget {
        private final int rotation;
        private final MovingGameObject target;

        PossibleTarget(int rotation, MovingGameObject target) {
            this.rotation = rotation;
            this.target = target;
        }

        public int getRotation() {
            return this.rotation;
        }

        public MovingGameObject getTarget() {
            return this.target;
        }
    }
}

