/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Communication;
import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.FramePreparer;
import de.caff.asteroid.FramePreparerSequence;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.ScoreFixer;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.rammi.AbstractBasicAsteroidPlayer;
import de.caff.asteroid.rammi.BulletCounter;
import de.caff.asteroid.rammi.DefaultScorer;
import de.caff.asteroid.rammi.ImprovedVelocityPreparer;
import de.caff.asteroid.rammi.Scorer;
import de.caff.asteroid.rammi.ShootingDirectionFixer;
import de.caff.asteroid.rammi.StandardFuturologist;
import de.caff.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsteroidPlayer
extends AbstractBasicAsteroidPlayer
implements Runnable,
FrameListener,
DrawableProvider {
    public static final String VERSION = "0.93";
    private static final boolean USE_THREAD = false;
    private static final boolean DRIVE_TO_BORDER = true;
    private static final int MAX_ASTEROIDS_FOR_MULTI_SHOT = 24;
    private static final int MIN_BORDER = 140;
    private static final int MAX_BORDER = 230;
    private LinkedBlockingQueue<FrameInfo> incomingFrames = new LinkedBlockingQueue();
    private Map<Integer, Integer> targetAsteroids = new HashMap<Integer, Integer>();
    private BulletCounter bulletCounter = new BulletCounter();
    private Scorer scorer;
    private StandardFuturologist futurologist;
    private int pendingShots;
    private AbstractBasicAsteroidPlayer.Target target;
    private int backTurn;
    private int maxAsteroidsForMultiShot = 24;
    private double smallUfoScore = -1.0;
    private double bigUfoScore = -1.0;
    private int minBorder = 140;
    private int maxBorder = 230;
    private int dangerFrames = 120;
    private int blackoutFrames = 6;
    private int maxVolleyCount = 3;
    private static final double MAX_VELOCITY = 0.125;
    private static final double TARGET_BONUS = 0.0;
    private ShootingDirectionFixer shootingDirectionFixer;
    private boolean destroyed = false;
    private static final int MINIMAL_TARGET_ASTEROID_LIFETIME = 4;
    private static final int MINIMAL_TARGET_UFO_LIFETIME = 1;
    private static final int MAX_PERMUTATE_TARGETS = 5;
    private static final int[][][] PERMUTATIONS = new int[][][]{new int[][]{new int[0]}, new int[][]{{0}}, new int[][]{{0, 1}, {1, 0}}, new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}, {2, 1, 0}}, new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 2, 1, 3}, {0, 2, 3, 1}, {0, 3, 1, 2}, {0, 3, 2, 1}, {1, 0, 2, 3}, {1, 0, 3, 2}, {1, 2, 0, 3}, {1, 2, 3, 0}, {1, 3, 0, 2}, {1, 3, 2, 0}, {2, 0, 1, 3}, {2, 0, 3, 1}, {2, 1, 0, 3}, {2, 1, 3, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {3, 1, 0, 2}, {3, 1, 2, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}}, new int[][]{{0, 1, 2, 3, 4}, {0, 1, 2, 4, 3}, {0, 1, 3, 2, 4}, {0, 1, 3, 4, 2}, {0, 1, 4, 2, 3}, {0, 1, 4, 3, 2}, {0, 2, 1, 3, 4}, {0, 2, 1, 4, 3}, {0, 2, 3, 1, 4}, {0, 2, 3, 4, 1}, {0, 2, 4, 1, 3}, {0, 2, 4, 3, 1}, {0, 3, 1, 2, 4}, {0, 3, 1, 4, 2}, {0, 3, 2, 1, 4}, {0, 3, 2, 4, 1}, {0, 3, 4, 1, 2}, {0, 3, 4, 2, 1}, {0, 4, 1, 2, 3}, {0, 4, 1, 3, 2}, {0, 4, 2, 1, 3}, {0, 4, 2, 3, 1}, {0, 4, 3, 1, 2}, {0, 4, 3, 2, 1}, {1, 0, 2, 3, 4}, {1, 0, 2, 4, 3}, {1, 0, 3, 2, 4}, {1, 0, 3, 4, 2}, {1, 0, 4, 2, 3}, {1, 0, 4, 3, 2}, {1, 2, 0, 3, 4}, {1, 2, 0, 4, 3}, {1, 2, 3, 0, 4}, {1, 2, 3, 4, 0}, {1, 2, 4, 0, 3}, {1, 2, 4, 3, 0}, {1, 3, 0, 2, 4}, {1, 3, 0, 4, 2}, {1, 3, 2, 0, 4}, {1, 3, 2, 4, 0}, {1, 3, 4, 0, 2}, {1, 3, 4, 2, 0}, {1, 4, 0, 2, 3}, {1, 4, 0, 3, 2}, {1, 4, 2, 0, 3}, {1, 4, 2, 3, 0}, {1, 4, 3, 0, 2}, {1, 4, 3, 2, 0}, {2, 0, 1, 3, 4}, {2, 0, 1, 4, 3}, {2, 0, 3, 1, 4}, {2, 0, 3, 4, 1}, {2, 0, 4, 1, 3}, {2, 0, 4, 3, 1}, {2, 1, 0, 3, 4}, {2, 1, 0, 4, 3}, {2, 1, 3, 0, 4}, {2, 1, 3, 4, 0}, {2, 1, 4, 0, 3}, {2, 1, 4, 3, 0}, {2, 3, 0, 1, 4}, {2, 3, 0, 4, 1}, {2, 3, 1, 0, 4}, {2, 3, 1, 4, 0}, {2, 3, 4, 0, 1}, {2, 3, 4, 1, 0}, {2, 4, 0, 1, 3}, {2, 4, 0, 3, 1}, {2, 4, 1, 0, 3}, {2, 4, 1, 3, 0}, {2, 4, 3, 0, 1}, {2, 4, 3, 1, 0}, {3, 0, 1, 2, 4}, {3, 0, 1, 4, 2}, {3, 0, 2, 1, 4}, {3, 0, 2, 4, 1}, {3, 0, 4, 1, 2}, {3, 0, 4, 2, 1}, {3, 1, 0, 2, 4}, {3, 1, 0, 4, 2}, {3, 1, 2, 0, 4}, {3, 1, 2, 4, 0}, {3, 1, 4, 0, 2}, {3, 1, 4, 2, 0}, {3, 2, 0, 1, 4}, {3, 2, 0, 4, 1}, {3, 2, 1, 0, 4}, {3, 2, 1, 4, 0}, {3, 2, 4, 0, 1}, {3, 2, 4, 1, 0}, {3, 4, 0, 1, 2}, {3, 4, 0, 2, 1}, {3, 4, 1, 0, 2}, {3, 4, 1, 2, 0}, {3, 4, 2, 0, 1}, {3, 4, 2, 1, 0}, {4, 0, 1, 2, 3}, {4, 0, 1, 3, 2}, {4, 0, 2, 1, 3}, {4, 0, 2, 3, 1}, {4, 0, 3, 1, 2}, {4, 0, 3, 2, 1}, {4, 1, 0, 2, 3}, {4, 1, 0, 3, 2}, {4, 1, 2, 0, 3}, {4, 1, 2, 3, 0}, {4, 1, 3, 0, 2}, {4, 1, 3, 2, 0}, {4, 2, 0, 1, 3}, {4, 2, 0, 3, 1}, {4, 2, 1, 0, 3}, {4, 2, 1, 3, 0}, {4, 2, 3, 0, 1}, {4, 2, 3, 1, 0}, {4, 3, 0, 1, 2}, {4, 3, 0, 2, 1}, {4, 3, 1, 0, 2}, {4, 3, 1, 2, 0}, {4, 3, 2, 0, 1}, {4, 3, 2, 1, 0}}};
    private int reordered = 0;
    private int originalOrder = 0;

    public AsteroidPlayer() {
        this(null);
    }

    public AsteroidPlayer(Communication com) {
        this(com, new DefaultScorer(138.0, 174.0, 0.0, 32.0));
    }

    public AsteroidPlayer(Communication com, Scorer scorer) {
        super(com);
        this.scorer = scorer;
        this.futurologist = new StandardFuturologist();
        if (com != null) {
            this.shootingDirectionFixer = new ShootingDirectionFixer();
            com.setFramePreparer(new FramePreparerSequence(new FramePreparer[]{new ImprovedVelocityPreparer(), new ScoreFixer(), this.shootingDirectionFixer}));
            com.addDatagramListener(this.shootingDirectionFixer);
        }
    }

    @Override
    public void destroy() {
        if (this.shootingDirectionFixer != null) {
            this.com.removeDatagramListener(this.shootingDirectionFixer);
            this.shootingDirectionFixer = null;
        }
        this.destroyed = true;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public int getMaxAsteroidsForMultiShot() {
        return this.maxAsteroidsForMultiShot;
    }

    public void setMaxAsteroidsForMultiShot(int maxAsteroidsForMultiShot) {
        this.maxAsteroidsForMultiShot = maxAsteroidsForMultiShot;
    }

    public double getSmallUfoScore() {
        return this.smallUfoScore;
    }

    public void setSmallUfoScore(double smallUfoScore) {
        this.smallUfoScore = smallUfoScore;
    }

    public double getBigUfoScore() {
        return this.bigUfoScore;
    }

    public void setBigUfoScore(double bigUfoScore) {
        this.bigUfoScore = bigUfoScore;
    }

    public void setMinBorder(int minBorder) {
        this.minBorder = minBorder;
    }

    public void setMaxBorder(int maxBorder) {
        this.maxBorder = maxBorder;
    }

    public int getDangerFrames() {
        return this.dangerFrames;
    }

    public void setDangerFrames(int dangerFrames) {
        this.dangerFrames = dangerFrames;
    }

    public int getBlackoutFrames() {
        return this.blackoutFrames;
    }

    public void setBlackoutFrames(int blackoutFrames) {
        this.blackoutFrames = blackoutFrames;
    }

    public int getMaxVolleyCount() {
        return this.maxVolleyCount;
    }

    public void setMaxVolleyCount(int maxVolleyCount) {
        this.maxVolleyCount = maxVolleyCount;
    }

    @Override
    public void run() {
        while (!this.destroyed) {
            try {
                FrameInfo info = this.incomingFrames.take();
                this.handleFrame(info);
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void handleFrame(FrameInfo info) {
        this.bulletCounter.frameReceived(info);
        if (info.getSpaceShip() != null) {
            if (AsteroidPlayer.hasIncomingDangerousShots(info, 2)) {
                this.pushButton(1);
            } else {
                this.makeTargetScoring(info, NULL_INFO_DRAWER);
            }
        }
    }

    private static boolean hasIncomingDangerousShots(FrameInfo info, int predictionLag) {
        SpaceShip ship = info.getSpaceShip();
        Point sPos = ship.getPredictedLocation(predictionLag);
        int size = ship.getSize();
        for (Bullet bullet : info.getBullets()) {
            if (bullet.getVelocityX() == 0.0 && bullet.getVelocityY() == 0.0) continue;
            Point distance = GameObject.getTorusDelta(bullet.getPredictedLocation(predictionLag), sPos);
            if (Math.abs(distance.x) > size || Math.abs(distance.y) > size) continue;
            return true;
        }
        return false;
    }

    private boolean hasIncomingDangerousAsteroids(FrameInfo info, int predictionLag) {
        SpaceShip ship = info.getSpaceShip();
        for (Asteroid ast : info.getAsteroids()) {
            double hitFrames;
            int framesTillDestroyed = this.futurologist.getFramesTillDestroyed(ast, info);
            if (framesTillDestroyed >= 0 && framesTillDestroyed <= predictionLag || !((hitFrames = (double)AsteroidPlayer.getFramesUntilCollision(ship, ast, predictionLag)) > 0.0) || !(hitFrames <= (double)predictionLag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void frameReceived(FrameInfo frame) {
        this.handleFrame(frame);
    }

    private void makeTargetScoring(FrameInfo info, AbstractBasicAsteroidPlayer.InfoDrawer infoDrawer) {
        this.updateTargetAsteroids(info);
        this.futurologist.frameReceived(info);
        if (this.hasIncomingDangerousAsteroids(info, 2)) {
            this.pushButton(1);
            return;
        }
        if (this.pendingShots > 0) {
            if (!this.haveFiredInLastFrame()) {
                this.pushButton(2);
                --this.pendingShots;
            } else {
                this.pushButton(0);
            }
            return;
        }
        HashMap<Integer, AbstractBasicAsteroidPlayer.RotateAndWait> rawForTarget = new HashMap<Integer, AbstractBasicAsteroidPlayer.RotateAndWait>(87);
        SpaceShip ship = info.getSpaceShip();
        byte nextDir = info.getNextShootingDirectionLowLevel();
        int size = info.getAsteroidCount() < this.maxAsteroidsForMultiShot ? 8 : 32;
        TreeMap<Double, Collection<MovingGameObject>> sortedTargets = new TreeMap<Double, Collection<MovingGameObject>>();
        for (Asteroid ast : info.getAsteroids()) {
            AbstractBasicAsteroidPlayer.RotateAndWait raw;
            if (ast.getLifetime() < 4 || this.targetAsteroids.containsKey(ast.getIdentity()) || this.futurologist.getFramesTillDestroyed(ast, info) >= 0) continue;
            Double key = null;
            int hitFrames = AsteroidPlayer.getFramesUntilCollision(ship, ast, this.dangerFrames);
            if (hitFrames > 0) {
                key = new Double(hitFrames - this.dangerFrames);
                rawForTarget.put(ast.getIdentity(), this.getRotationForHit(ship, nextDir, ast, size, 1, 136));
            }
            if (key == null && (raw = this.getRotationForHit(ship, nextDir, ast, size, 1, 136)) != null) {
                key = (double)raw.getHitFrames() + (double)Math.abs(raw.getRotation()) / 256.0;
                rawForTarget.put(ast.getIdentity(), raw);
            }
            if (key == null) continue;
            AsteroidPlayer.insertTarget(sortedTargets, key, ast);
        }
        Ufo ufo = info.getUfo();
        if (ufo != null && (ufo.getLifetime() < 1 || this.futurologist.getFramesTillDestroyed(ufo, info) < 0 && !this.targetAsteroids.containsKey(ufo.getIdentity()))) {
            AsteroidPlayer.insertTarget(sortedTargets, ufo.getScore() == 1000 ? this.smallUfoScore : this.bigUfoScore, ufo);
            rawForTarget.put(ufo.getIdentity(), this.getRotationForHit(ship, nextDir, ufo, size, 1, 136));
        }
        List<Object> targets = Collections.emptyList();
        MovingGameObject target = null;
        AbstractBasicAsteroidPlayer.RotateAndWait targetRaw = null;
        if (!sortedTargets.isEmpty()) {
            if ((Double)sortedTargets.firstKey() < 0.0) {
                int minRotWait = Integer.MAX_VALUE;
                MovingGameObject bestIntermediate = null;
                block5: for (Collection coll : sortedTargets.values()) {
                    for (MovingGameObject obj : coll) {
                        if (target == null) {
                            targetRaw = (AbstractBasicAsteroidPlayer.RotateAndWait)rawForTarget.get(obj.getIdentity());
                            if (targetRaw == null) continue;
                            target = obj;
                            if (this.getAvailableBullets(info, targetRaw.getShootFrames()) < 2) break block5;
                            minRotWait = targetRaw.getWait() + 1;
                            continue;
                        }
                        AbstractBasicAsteroidPlayer.RotateAndWait raw = (AbstractBasicAsteroidPlayer.RotateAndWait)rawForTarget.get(obj.getIdentity());
                        if (raw == null || 2 * Math.abs(raw.getRotation()) + raw.getWait() >= minRotWait || this.getAvailableBullets(info, raw.getShootFrames()) <= 0) continue;
                        bestIntermediate = obj;
                        minRotWait = 2 * Math.abs(raw.getRotation()) + raw.getWait();
                        break block5;
                    }
                }
                if (bestIntermediate != null) {
                    target = bestIntermediate;
                    targetRaw = (AbstractBasicAsteroidPlayer.RotateAndWait)rawForTarget.get(target.getIdentity());
                }
            } else {
                LinkedList<MovingGameObject> possibleTargets = new LinkedList<MovingGameObject>();
                for (Collection coll : sortedTargets.values()) {
                    possibleTargets.addAll(coll);
                }
                targets = this.getNextTargets(ship, nextDir, size, possibleTargets);
                if (!targets.isEmpty()) {
                    target = (MovingGameObject)targets.remove(0);
                    targetRaw = (AbstractBasicAsteroidPlayer.RotateAndWait)rawForTarget.get(target.getIdentity());
                }
            }
        }
        if (targetRaw != null) {
            if (targetRaw.getRotation() == 0) {
                if (!this.haveFiredInLastFrame() && targetRaw.getWait() == 0) {
                    int bulletsLeft = 4 - this.bulletCounter.getNextShipBulletCount();
                    if (bulletsLeft > 0) {
                        this.pushButton(2);
                        if (--bulletsLeft > 0 && size == 8) {
                            switch (target.getScore()) {
                                case 20: {
                                    this.pendingShots = Math.min(bulletsLeft, this.maxVolleyCount);
                                    break;
                                }
                                case 50: {
                                    this.pendingShots = Math.min(bulletsLeft, Math.min(this.maxVolleyCount, 3));
                                    break;
                                }
                            }
                        }
                        this.targetAsteroids.put(target.getIdentity(), info.getIndex() + this.blackoutFrames);
                        if (this.pendingShots > 0) {
                            return;
                        }
                        target = null;
                        targetRaw = null;
                    } else {
                        this.pushButton(0);
                        target = null;
                        targetRaw = null;
                    }
                } else {
                    this.pushButton(0);
                    target = null;
                    targetRaw = null;
                }
            }
            if (target != null && targetRaw.getRotation() != 0) {
                this.pushButton(targetRaw.getRotation() > 0 ? 16 : 8);
            }
            this.driveToBorder(ship, info, false);
        } else {
            int nrTargets = info.getAsteroidCount();
            if (info.getUfo() != null) {
                ++nrTargets;
            }
            this.driveToBorder(ship, info, nrTargets == 0);
        }
    }

    private int getAvailableBullets(FrameInfo frame, int frameCount) {
        return 2;
    }

    private static void insertTarget(SortedMap<Double, Collection<MovingGameObject>> sortedTargets, Double key, MovingGameObject ast) {
        LinkedList<MovingGameObject> objects = (LinkedList<MovingGameObject>)sortedTargets.get(key);
        if (objects == null) {
            objects = new LinkedList<MovingGameObject>();
            sortedTargets.put(key, objects);
        }
        objects.add(ast);
    }

    private void driveToBorder(SpaceShip ship, FrameInfo info, boolean rotationAllowed) {
        double cross;
        Point2D outwards;
        boolean yOkay;
        Point delta = new Point(ship.getX() - 512, ship.getY() - 512);
        int xBorder = 512 - Math.abs(delta.x);
        int yBorder = 384 - Math.abs(delta.y);
        boolean xOkay = 140 <= xBorder && xBorder <= 230;
        boolean bl = yOkay = 140 <= yBorder && yBorder <= 230;
        if (!xOkay || !yOkay) {
            double scalar;
            if (xOkay) {
                delta.x = 0;
            }
            if (yOkay) {
                delta.y = 0;
            }
            Point2D shipPos = ship.getCorrectedNextLocation();
            int borderDist = 185;
            Point nearestCorner = new Point(shipPos.getX() >= 512.0 ? 1024 - borderDist : borderDist, shipPos.getY() >= 384.0 ? 896 - borderDist : 128 + borderDist);
            Point2D cornerDeltaNorm = Tools.normalize(new Point2D.Double((double)nearestCorner.x - shipPos.getX(), (double)nearestCorner.y - shipPos.getY()));
            Point2D shipDirNorm = Tools.normalize(info.getNextShootingDirection().getBulletVelocity());
            double cross2 = Tools.crossProduct(cornerDeltaNorm, shipDirNorm);
            if (rotationAllowed && Math.abs(cross2) > ROT_BORDER) {
                this.pushButton(cross2 > 0.0 ? 8 : 16);
            }
            if (Math.abs(ship.getVelocityX()) <= 0.125 && Math.abs(ship.getVelocityY()) <= 0.125 && (scalar = Tools.scalarProduct(cornerDeltaNorm, shipDirNorm)) > 0.9) {
                this.pushButton(4);
            }
        } else if (rotationAllowed && (outwards = Tools.normalize(delta)) != null && Math.abs(cross = Tools.crossProduct(outwards, Tools.normalize(info.getNextShootingDirection().getBulletVelocity()))) > ROT_BORDER) {
            this.pushButton(cross > 0.0 ? 8 : 16);
        }
    }

    private void updateTargetAsteroids(FrameInfo info) {
        if (this.com == null) {
            this.targetAsteroids.clear();
        } else {
            int counter = info.getIndex();
            for (Integer ident : new ArrayList<Integer>(this.targetAsteroids.keySet())) {
                if (this.targetAsteroids.get(ident) > counter) continue;
                this.targetAsteroids.remove(ident);
            }
        }
    }

    @Override
    public void draw(Graphics2D g, FrameInfo frame) {
        SpaceShip ship = frame.getSpaceShip();
        if (ship != null) {
            AbstractBasicAsteroidPlayer.DefaultInfoDrawer drawer = new AbstractBasicAsteroidPlayer.DefaultInfoDrawer();
            this.makeTargetScoring(frame, drawer);
            drawer.draw(g);
            g.setColor(Color.yellow);
            g.drawLine(ship.getX(), ship.getY(), ship.getX() + ship.getDirX(), ship.getY() + ship.getDirY());
            g.setColor(Color.green);
            Point2D shootDir = frame.getNextShootingDirection().getBulletVelocity();
            g.drawLine(ship.getX(), ship.getY(), ship.getX() + (int)(8.0 * shootDir.getX()), ship.getY() + (int)(8.0 * shootDir.getY()));
            g.setColor(Color.red);
            shootDir = frame.getShootingDirection().getBulletVelocity();
            g.drawLine(ship.getX(), ship.getY(), ship.getX() + (int)(8.0 * shootDir.getX()), ship.getY() + (int)(8.0 * shootDir.getY()));
        }
        this.futurologist.draw(g, frame);
    }

    private List<MovingGameObject> getNextTargets(SpaceShip ship, byte dirByte, int maxSize, Collection<MovingGameObject> targets) {
        ArrayList<MovingGameObject> validTargets = new ArrayList<MovingGameObject>(5);
        for (MovingGameObject object : targets) {
            if (this.targetAsteroids.get(object.getIdentity()) != null) continue;
            validTargets.add(object);
            if (validTargets.size() != 5) continue;
            break;
        }
        if (validTargets.size() == 0) {
            return Collections.emptyList();
        }
        if (validTargets.size() == 1) {
            return validTargets;
        }
        int minimalFrames = Integer.MAX_VALUE;
        int minimalPermutation = -1;
        int maxFutureFrames = 600;
        int[][] permutation = PERMUTATIONS[validTargets.size()];
        block1: for (int p = 0; p < permutation.length; ++p) {
            int frames = 1;
            AbstractBasicAsteroidPlayer.RotateAndWait raw = null;
            for (int t = 0; t < permutation[p].length; ++t) {
                raw = this.getRotationForHit(ship, dirByte, (MovingGameObject)validTargets.get(permutation[p][t]), maxSize, frames, maxFutureFrames);
                if (raw == null) continue block1;
                frames += raw.getShootFrames() + 1;
            }
            if (raw != null) {
                frames += raw.getFly();
            }
            if (frames >= minimalFrames) continue;
            minimalFrames = frames;
            minimalPermutation = p;
        }
        if (minimalPermutation > 0) {
            ++this.reordered;
        } else {
            ++this.originalOrder;
        }
        if (minimalPermutation > 0) {
            LinkedList<MovingGameObject> result = new LinkedList<MovingGameObject>();
            for (int i = 0; i < permutation[minimalPermutation].length; ++i) {
                result.add((MovingGameObject)validTargets.get(permutation[minimalPermutation][i]));
            }
            return result;
        }
        return validTargets;
    }

    public int getReordered() {
        return this.reordered;
    }

    public int getOriginalOrder() {
        return this.originalOrder;
    }
}

