/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.human;

import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameDisplay;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.human.NewGameDialog;
import de.caff.asteroid.human.ServerBusyDialog;
import de.caff.i18n.I18n;
import de.caff.i18n.ResourcedException;
import de.caff.util.EventQueueExceptionListener;
import de.caff.util.Utility;
import de.caff.util.settings.BoundsPreferenceProperty;
import de.caff.util.settings.PreferenceProperty;
import de.caff.util.settings.swing.EditablePreferenceGroup;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.SettingsDialog;
import de.caff.util.settings.swing.SwingBooleanPreferenceProperty;
import de.caff.util.settings.swing.SwingStringPreferenceProperty;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class HumanClient
extends JFrame
implements FrameListener,
Communication.ServerStateListener,
EventQueueExceptionListener,
KeyListener,
GameData {
    private static final String NAME_PREFIX = "\u263b ";
    private static final BoundsPreferenceProperty PP_FRAME_BOUNDS;
    private static final BoundsPreferenceProperty PP_DIA_SETTINGS_BOUNDS;
    private static final SwingStringPreferenceProperty PP_PLAYER_NAME;
    private static final SwingBooleanPreferenceProperty PP_MODIFIED_MAME;
    private static final EditablePreferenceGroup PREFERENCES_ALL;
    private static final PreferenceProperty[] PREFERENCE_PROPERTIES;
    private Communication com;
    private int keyMask;
    private FrameDisplay frameDisplay;
    private Preferences preferences;
    private final String hostname;
    private final ServerBusyDialog serverBusyDialog;
    private final NewGameDialog newGameDialog;
    private Long lastGameFinish;

    public HumanClient(String hostname) {
        super(I18n.getString("diaAppFrame"));
        Utility.addEventQueueExceptionListener(this);
        this.hostname = hostname;
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.frameDisplay = new FrameDisplay(0);
        this.getContentPane().add((Component)this.frameDisplay, "Center");
        this.loadPrefs();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HumanClient.this.exit(0);
            }
        });
        this.addKeyListener(this);
        this.setVisible(true);
        this.serverBusyDialog = new ServerBusyDialog(this);
        this.newGameDialog = new NewGameDialog(this);
        this.startCommunication(this.getPlayerName());
    }

    private void loadPrefs() {
        for (int p = 0; p < PREFERENCE_PROPERTIES.length; ++p) {
            PREFERENCE_PROPERTIES[p].readFrom(this.preferences);
        }
        if (!PP_FRAME_BOUNDS.setWindowBounds(this)) {
            Dimension screenSize = this.getToolkit().getScreenSize();
            Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
            this.setBounds(insets.left, insets.top, screenSize.width - insets.left - insets.right, screenSize.height - insets.top - insets.bottom);
        }
    }

    private void savePrefs() {
        PP_FRAME_BOUNDS.storeWindowBounds(this.preferences, this);
        for (int p = 0; p < PREFERENCE_PROPERTIES.length; ++p) {
            PREFERENCE_PROPERTIES[p].storeTo(this.preferences);
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void startCommunication(String playerName) {
        try {
            this.com = playerName == null ? new Communication(this.hostname, false) : new Communication(this.hostname, false, NAME_PREFIX + playerName);
            this.com.addFrameListener(this.frameDisplay);
            this.com.addFrameListener(this);
            this.com.addServerStateListener(this);
            Thread comThread = new Thread((Runnable)this.com, "Communication");
            comThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    System.err.println("Communication thread passed out.");
                    HumanClient.this.showError(e);
                    System.exit(2);
                }
            });
            comThread.run();
        }
        catch (IOException e) {
            this.showError(e);
            this.exit(2);
        }
    }

    private String getPlayerName() {
        SettingsDialog dialog = new SettingsDialog(this.frameDisplay, I18n.getString("diaSettings"), PP_DIA_SETTINGS_BOUNDS, PREFERENCES_ALL.getEditorProvider(I18n.getDefaultLocale()));
        dialog.setModal(true);
        dialog.setVisible(true);
        if (dialog.isUserCancelled()) {
            this.exit(0);
        }
        if (PP_MODIFIED_MAME.getValue()) {
            String playerName = PP_PLAYER_NAME.getValue();
            if (playerName == null) {
                playerName = "";
            }
            return playerName;
        }
        return null;
    }

    void restart() {
        this.com.restart();
    }

    void exit(int code) {
        this.savePrefs();
        if (!Utility.areWeInAnApplet()) {
            System.exit(code);
        }
    }

    public void frameReceived(FrameInfo frame) {
        this.com.setButtons(this.keyMask);
    }

    public void serverStateChanged(Communication.ServerState oldState, final Communication.ServerState newState) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                switch (newState) {
                    case SERVER_BUSY: {
                        HumanClient.this.newGameDialog.setVisible(false);
                        HumanClient.this.serverBusyDialog.setVisible(true);
                        break;
                    }
                    case IN_GAME: {
                        HumanClient.this.newGameDialog.setVisible(false);
                        HumanClient.this.serverBusyDialog.setVisible(false);
                        break;
                    }
                    case GAME_OVER: {
                        HumanClient.this.keyMask = 0;
                        HumanClient.this.lastGameFinish = System.currentTimeMillis();
                        HumanClient.this.serverBusyDialog.setVisible(false);
                        HumanClient.this.newGameDialog.setVisible(true);
                    }
                }
            }
        });
    }

    public void framesToWaitUpdate(int framesToWait) {
        this.serverBusyDialog.refreshTimeToWait((framesToWait + 59) / 60);
    }

    public void exceptionOccured(AWTEvent event, Throwable exception) {
        this.showError(exception);
    }

    public void showError(Throwable x) {
        x.printStackTrace();
        this.repaint();
        String msg = x instanceof ResourcedException ? ((ResourcedException)x).getMessage(this.getLocale()) : x.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = x.toString();
        }
        this.showError(msg);
    }

    public void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, I18n.getString("diaError"), 0);
    }

    public void keyTyped(KeyEvent e) {
    }

    private static int keyCodeToMameButton(int keyCode) {
        switch (keyCode) {
            case 79: {
                return 2;
            }
            case 81: {
                return 16;
            }
            case 87: {
                return 8;
            }
            case 73: {
                return 4;
            }
            case 32: {
                return 1;
            }
            case 49: {
                return 32;
            }
        }
        return 0;
    }

    public void keyPressed(KeyEvent e) {
        this.keyMask = this.lastGameFinish == null || e.getWhen() > this.lastGameFinish ? (this.keyMask |= HumanClient.keyCodeToMameButton(e.getKeyCode())) : 0;
    }

    public void keyReleased(KeyEvent e) {
        this.keyMask = this.lastGameFinish == null || e.getWhen() > this.lastGameFinish ? (this.keyMask &= ~HumanClient.keyCodeToMameButton(e.getKeyCode())) : 0;
    }

    static {
        I18n.addAppResourceBase("de.caff.asteroid.human.resources.HumanClient");
        PP_FRAME_BOUNDS = new BoundsPreferenceProperty("MAIN_FRAME_BOUNDS");
        PP_DIA_SETTINGS_BOUNDS = new BoundsPreferenceProperty("DIA_SETTINGS_BOUNDS");
        PP_PLAYER_NAME = new SwingStringPreferenceProperty("PLAYER_NAME", "ppPlayerName");
        PP_MODIFIED_MAME = new SwingBooleanPreferenceProperty("MODIFIED_MAME", "ppModifiedMame", true);
        PREFERENCES_ALL = new EditablePreferenceGroup("pgAll", false, new EditablePreferenceProperty[]{PP_MODIFIED_MAME, PP_PLAYER_NAME});
        PREFERENCE_PROPERTIES = new PreferenceProperty[]{PP_FRAME_BOUNDS, PP_DIA_SETTINGS_BOUNDS, PREFERENCES_ALL};
    }
}

