/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis.statistics;

import de.caff.asteroid.GameData;
import de.caff.asteroid.Property;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.statistics.AbstractBasicDumpFileStatistics;
import de.caff.i18n.I18n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStatistics
extends AbstractBasicDumpFileStatistics
implements GameData {
    private KeyCounter[] counter = new KeyCounter[]{new KeyCounter("propKeyLeft", 16), new KeyCounter("propKeyRight", 8), new KeyCounter("propKeyFire", 2), new KeyCounter("propKeyHyper", 1), new KeyCounter("propKeyThrust", 4)};
    private int frameCount;

    @Override
    public void analyse(Collection<FrameKeyInfo> infos) {
        this.frameCount = infos.size();
        for (KeyCounter c : this.counter) {
            c.reset();
        }
        for (FrameKeyInfo info : infos) {
            List<FrameKeyInfo.ButtonInfo> buttonList = info.getButtons();
            if (buttonList.isEmpty()) continue;
            byte keys = buttonList.get(0).getButtons().getKeys();
            for (KeyCounter c : this.counter) {
                c.check(keys);
            }
        }
    }

    @Override
    public String getTitle() {
        return I18n.getString("titleKeyStat");
    }

    @Override
    public boolean needPreparation() {
        return false;
    }

    private String getRatio(int count) {
        return String.format("%3.2f%%", (double)count / (double)this.frameCount);
    }

    @Override
    public Collection<Property> getProperties() {
        ArrayList<Property> props = new ArrayList<Property>(this.counter.length);
        for (KeyCounter c : this.counter) {
            props.add(c.getStatistics(this.frameCount));
        }
        return props;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyCounter {
        private final String tag;
        private final int keyMask;
        private int count = 0;

        KeyCounter(String tag, int keyMask) {
            this.tag = tag;
            this.keyMask = keyMask;
        }

        public void reset() {
            this.count = 0;
        }

        public void check(int keys) {
            if ((this.keyMask & keys) != 0) {
                ++this.count;
            }
        }

        public Property<String> getStatistics(int frameCount) {
            return new Property<String>(I18n.getString(this.tag), String.format("%5d (%.2f%%)", this.count, 100.0 * (double)this.count / (double)frameCount));
        }
    }
}

