/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.analysis.statistics;

import de.caff.asteroid.Property;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.statistics.AbstractBasicDumpFileStatistics;
import de.caff.i18n.I18n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswerTimesStatistics
extends AbstractBasicDumpFileStatistics {
    private SortedMap<Long, Counter> stats = new TreeMap<Long, Counter>();

    @Override
    public void analyse(Collection<FrameKeyInfo> infos) {
        for (FrameKeyInfo info : infos) {
            if (info.getButtons().isEmpty()) continue;
            Long duration = info.getButtons().get(0).getTimestamp() - info.getFrameInfo().getReceiveTime();
            Counter counter = (Counter)this.stats.get(duration);
            if (counter == null) {
                counter = new Counter();
                this.stats.put(duration, counter);
                continue;
            }
            counter.advance();
        }
    }

    @Override
    public String getTitle() {
        return I18n.getString("titleAnswerTimeStat");
    }

    @Override
    public boolean needPreparation() {
        return false;
    }

    @Override
    protected String getLeftColumnAlign() {
        return "text-align:right";
    }

    @Override
    public Collection<Property> getProperties() {
        ArrayList<Property> props = new ArrayList<Property>(this.stats.size() + 1);
        long average = 0L;
        int frames = 0;
        for (Long duration : this.stats.keySet()) {
            Counter counter = (Counter)this.stats.get(duration);
            props.add(new Property<Counter>(String.format("%d ms", duration), counter));
            average += duration * (long)counter.getCounter();
            frames += counter.getCounter();
        }
        props.add(new Property<String>(I18n.getString("propAnswerTimeAverage"), String.format("%f ms", (double)average / (double)frames)));
        return props;
    }

    private static class Counter {
        private int counter = 1;

        private Counter() {
        }

        public void advance() {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public String toString() {
            return Integer.toString(this.counter);
        }
    }
}

