/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObject;
import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Explosion
extends GameObject {
    private static final Color EXPLOSION_COLOR = new Color(128, 128, 128);
    public static final Glyph XXL_GLYPH = new Glyph(new byte[]{16, 0, 0, 16, 0, 7, 32, 16, 0, 32, 16, 7, 16, 32, 0, 16, 32, 7, -8, 24, 0, -8, 24, 7, -24, 32, 0, -24, 32, 7, -24, 16, 0, -24, 16, 7, -32, -8, 0, -32, -8, 7, -24, -32, 0, -24, -32, 7, 8, -24, 0, 8, -24, 7, 32, -32, 0, 32, -32, 7});
    public static final Glyph XL_GLYPH = new Glyph(new byte[]{14, 0, 0, 14, 0, 7, 28, 14, 0, 28, 14, 7, 14, 28, 0, 14, 28, 7, -7, 21, 0, -7, 21, 7, -21, 28, 0, -21, 28, 7, -21, 14, 0, -21, 14, 7, -28, -7, 0, -28, -7, 7, -21, -28, 0, -21, -28, 7, 7, -21, 0, 7, -21, 7, 28, -28, 0, 28, -28, 7});
    public static final Glyph L_GLYPH = new Glyph(new byte[]{12, 0, 0, 12, 0, 7, 24, 12, 0, 24, 12, 7, 12, 24, 0, 12, 24, 7, -6, 18, 0, -6, 18, 7, -18, 24, 0, -18, 24, 7, -18, 12, 0, -18, 12, 7, -24, -6, 0, -24, -6, 7, -18, -24, 0, -18, -24, 7, 6, -18, 0, 6, -18, 7, 24, -24, 0, 24, -24, 7});
    public static final Glyph S_GLYPH = new Glyph(new byte[]{10, 0, 0, 10, 0, 7, 20, 10, 0, 20, 10, 7, 10, 20, 0, 10, 20, 7, -5, 15, 0, -5, 15, 7, -15, 20, 0, -15, 20, 7, -15, 10, 0, -15, 10, 7, -20, -5, 0, -20, -5, 7, -15, -20, 0, -15, -20, 7, 5, -15, 0, 5, -15, 7, 20, -20, 0, 20, -20, 7});
    private Type type;
    private int scale;

    public Explosion(int x, int y, int scale, Type type) {
        super(x, y);
        this.type = type;
        switch (scale) {
            case 0: {
                this.scale = 1;
                break;
            }
            case 15: {
                this.scale = 2;
                break;
            }
            case 14: {
                this.scale = 4;
                break;
            }
            case 13: {
                this.scale = 8;
                break;
            }
            case 12: {
                this.scale = 16;
                break;
            }
            case 11: {
                this.scale = 32;
                break;
            }
            default: {
                System.out.println("Unexpected explosion scaling: " + scale);
                this.scale = 1;
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.type.getShape().getBounds().width / (2 * this.scale);
    }

    public String toString() {
        return String.format("Explosion(%s)@(%d,%d)*%d", new Object[]{this.type, this.getX(), this.getY(), this.getSize()});
    }

    @Override
    public void draw(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(EXPLOSION_COLOR);
        g2.draw(this.getExplosionShape());
    }

    public Shape getExplosionShape() {
        AffineTransform trafo = new AffineTransform(1.0 / (double)this.scale, 0.0, 0.0, 1.0 / (double)this.scale, (double)this.x, (double)this.y);
        return trafo.createTransformedShape(this.type.getShape());
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Type>("Explosion Type", this.getType()));
        props.add(new Property<Integer>("Scale", this.scale));
        return props;
    }

    @Override
    public Rectangle getBounds() {
        return this.getExplosionShape().getBounds();
    }

    @Override
    public String getObjectType() {
        return "Explosion";
    }

    @Override
    public void visitedBy(GameObjectVisitor visitor) {
        visitor.handle(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        XXL(XXL_GLYPH),
        XL(XL_GLYPH),
        L(L_GLYPH),
        S(S_GLYPH);

        private final Shape shape;

        private Type(Glyph glyph) {
            this.shape = glyph.getPath();
        }

        public Shape getShape() {
            return this.shape;
        }
    }
}

