/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bullet
extends MovingGameObject {
    public static final int MIN_LIFETIME = 69;
    public static final int MAX_LIFETIME = 72;
    public static final int BULLET_SPEED = 8;
    public static final int BULLET_SIZE = 3;
    private static final int PICK_SIZE = 3;
    private static final Color[] HALO_COLORS = new Color[]{Color.white, Color.white, new Color(240, 240, 240), new Color(192, 192, 192), new Color(128, 128, 128), new Color(64, 64, 64)};
    private final int index;
    private Boolean friendly;

    public Bullet(int index, int x, int y) {
        super(x, y);
        this.index = index;
    }

    @Override
    public int getSize() {
        return 3;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawVelocityVector(g, Color.blue);
        Color lastColor = null;
        for (int i = HALO_COLORS.length - 1; i >= 0; --i) {
            Color color = HALO_COLORS[i];
            if (color.equals(lastColor)) continue;
            g.setColor(color);
            g.fillOval(this.getX() - i, this.getY() - i, 2 * i + 1, 2 * i + 1);
            lastColor = color;
        }
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Integer>("Lifetime", this.getLifetime()));
        return props;
    }

    @Override
    public String getObjectType() {
        return "Bullet";
    }

    public String toString() {
        return String.format("Bullet@(%d,%d)", this.getX(), this.getY());
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.getX() - 1, this.getY() - 1, 2, 2);
    }

    @Override
    public Rectangle getPickBounds() {
        return new Rectangle(this.getX() - 3, this.getY() - 3, 6, 6);
    }

    @Override
    public void visitedBy(GameObjectVisitor visitor) {
        visitor.handle(this);
    }

    public Boolean isFriendly() {
        return this.friendly;
    }

    public void setFriendly(boolean friendly) {
        this.friendly = friendly;
    }

    @Override
    public void inheret(MovingGameObject obj) {
        super.inheret(obj);
        this.friendly = ((Bullet)obj).friendly;
    }
}

