// player.h: Beispielspieler f�r Asteroids
// Harald B�geholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes f�r sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string>
#include <string.h>
#include <math.h>
#include <fstream.h>

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;



typedef struct
{
	double gewichte[100];
	double input[100];
	double delta;
	double out;
	double n;
	double q;
	bool endneuron;
} neuron;

typedef struct
{
	double gewichte[427*2+1];
	int input[427*2+1];
	double delta;
	double out;
	double n;
	double q;
	bool endneuron;
} bigneuron;

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, �u�ere Form
	int sf;   // scale factor: 0 = gro�, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	bool newship_present;
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_oldx;
	int ship_oldy;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	int ship_olddx;
	int ship_olddy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_oldx;
	int saucer_oldy;
	int saucer_size;    // Gr��e: 15 = gro�, 14 = klein
	bool newsaucer;
	int nasteroids; // Anzahl Asteroiden
	int oldnasteroids;
	Asteroid asteroids[MAX_ASTEROIDS];
	Asteroid oldasteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Sch�sse
	int oldnshots;
	Shot shots[MAX_SHOTS];
	Shot oldshots[MAX_SHOTS];
	void clear(void);
};

#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zur�ck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei n�chster Gelegenheit zur�ckgeschickt. F�r Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace dr�cken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf dr�cken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(unsigned int s);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
	void berechne(neuron *layer,double *testwerte,int size);
	void berechne_big(bigneuron *layer,int *testwerte,int size);
	void lerne_end(neuron *layer,double soll,int size);
	void lerne_neuron(neuron *layer,double *ind,double *inw,int size,int sizeout);
	void lerne_neuron_big(bigneuron *layer,double *ind,double *inw,int size,int sizeout);
	/*void training_movement(neuron **netz,int *aposx,int *aposy,int *asize,int *atype,int ufox, int ufoy , int ufosize, int myx,int myy,int my_dx,int my_dy,int *shotx,int *shoty,int nbasteroids, int nbufo, int nb shots,KeysPacket *keys);
	void training_jump_aster(neuron **netz,int aposx,int aposy,int asize,int myx,int myy,int soll);
	void training_jump_ufo(neuron **netz,int ufox,int ufoy,int myx,int myy,int soll);*/

private:
	
	
	SOCKET sd;
	ADDRESS server_ip;
};

