#pragma once
#include "gameobject.h"

const int SHOTRESETFRAMES = 40;

class Target :
	public GameObject
{
public:
	Vector2D   virtualPosition;
	Vector2D   aimLocation;             // point of hit if ship shoots now

    bool    willHit;       // flag if target will be hit by the ship
    float   distTH;        // distance from target to hitpoint
    float   distSH;        // distance from ship to hitpoint
    float   nFramesTH;     // No. of frames until hit for target
    float   nFramesSH;     // No. of frames until hit for target
    float   nFramesDeltaH; // Abs. difference of nFramesTH & nFramesSH
      
    Vector2D   C;             // point of collision with ship
    bool    willCollide;   // flag if asteroid collides the ship
    float   distTC;        // distance from target to collision point
    float   distSC;        // distance from target to collision point
      
    double  angleToShipDEG;// angle between SH & ST
	double  distanceToShip;
    float   rotationDir;   // rotation direction of ship towards me (1=CCW, -1=CW)
     
    int     nShots;        // counter for shots fired on me
	int		maxShots;	   // how many times the ship should shoot me
	int		shotResetCounter;
	bool	shotAt;
      
    float   prioType;      // Type priority
    float   prioTotal;     // target priority
      
    bool    isTarget;      // flag if flyer is target
};
