﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ct.Asteroid
{
    public class Asteroid
    {
	    public int x;    // Koordinaten des Mittelpunkts
	    public int y;
	    public int type; // 1 ... 4, äußere Form
	    public int sf;   // scale factor: 0 = groß, 15 = mittel, 14 = klein
        public int ox;  // alte Koordinaten
        public int oy;
        public int id; //zur wiedererkennung
        public int shotframe; //der frame in dem der letzte schuss treffen soll
        public int numberofshots = 0; //Anzahl der abgegeben Schüsse


        //erweiterte Variablen für die Liste
        public double dx; //geschw in x richtung
        public double dy; //geschw in y richtung
        public double dg; //betrag der gesamtgeschwindigkeit
        public int setspeed =0; //wie oft die geschwindigkeit gesetzt wurde
        public Boolean vorhanden;
        public int Prioritaet = -1;// Priorität für die Liste
        public double distGeradeShip = 1000; //Abstand von der Asteroidengerade zum Schiff
        public int frameshortestdist; // Das Bild in dem er am nächsten ist

        //Array für geschwindigkeit
        public double[] geschwarray = new double[20];
        public int gcount = -1;
        public int[] dxarray = new int[8];
        public int[] dyarray = new int[8];

        


        public Asteroid(int px, int py, int pdx, int pdy)
        {
            dx = pdx;
            dy = pdy;
            x = px;
            y = py;

            dg = Math.Sqrt(((dx * dx) + (dy * dy)));

        }
        public Asteroid()
        {
            for (int i = 0; i < 8; i++)
            {
                dxarray[0] = 0;
                dyarray[0] = 0;
            }
        }

        public void set(int x, int y, int type, int sf)
        {
	        this.x = x;
	        this.y = y;
	        this.type = type;
	        this.sf = sf;
            this.ox = x;
            this.oy = y;
        }
        public void setold(int pox, int poy)
        {
            ox = pox;
            oy = poy;
        }

        //Funktion für die allgmeine Liste

        public void setaktuell(int px, int py)
        {
            //Variablen neu setzen
            ox = x;
            oy = y;
            x = px;
            y = py;

            //Geschwindigkeit neu berechnen
            setspeed++;
            dx = x - ox;
            dy = y - oy;
            dxarray[setspeed % 8] = (int)dx;
            dyarray[setspeed % 8] = (int)dy;
            dx = 0;
            dy = 0;

            for (int a = 0; a < 8; a++)
            {
                dx += dxarray[a];
                dy += dyarray[a];
            }
            dx = dx / 8;
            dy = dy / 8;

            

            dg = Math.Sqrt(((dx * dx) + (dy * dy)));

            //für die geschwindigkeitsmessung
            if (setspeed % 8 == 0)
            {
                gcount = (gcount + 1) % 20;
                geschwarray[gcount] = dg;

            }

        }
        public void setVorhanden(Boolean vorh)
        {
            vorhanden = vorh;
        }

        public void setPrio(int p)
        {
            Prioritaet = p;
        }
        public void setGeradenAbstand(double pAbstand)
        {
            distGeradeShip = pAbstand;
        }
        public void setframeShortestdist(int shortdist)
        {
            frameshortestdist = shortdist;
        }
        public void setTrefferframe(int trefferframe)
        {
            shotframe = trefferframe;
            numberofshots++;

        }
        public void setID(int pid)
        {
            id = pid;
        }
        
    }

    public class ZielTimePunkt
    {
        public int firstShotframe;
        public int lastShotframe;
        public int x;
        public int y;
        public int Trefferwinkel;


        public ZielTimePunkt(int px, int py,int pfirstshot , int plastShot,int pTrefferwinkel)
        {
            x = px;
            y = py;
            firstShotframe = pfirstshot;
            lastShotframe = plastShot;
            Trefferwinkel = pTrefferwinkel;

        }
        
    }

    class Saucer
    {
        public int x;
        public int y;
        public int dx;
        public int dy;
        public int numberofshots = 0;
        
        public void set(int px,int py)
        {
            int dxold = dx;
            int dyold = dy;

            dx = px - x;
            dy = py - y;
            x = px;
            y = py;
            if (dx != dxold || dy != dyold)
            {
                clearShots();
            }

        }
        public void addshot()
        {
            numberofshots++;
        }
        public void clearShots()
        {
            numberofshots = 0;
        }
    }

    class Shot
    {
	    public int x;
	    public int y;
        public int ox;
        public int oy;
        //new
        public double dx; //geschw in x richtung
        public double dy; //geschw in y richtung
        public double dg; //betrag der gesamtgeschwindigkeit
        public int setspeed; //wie oft die geschwindigkeit gesetzt wurde
        //zum synchen
        public Boolean shipshot; // ob der Schuss vom schiff abgefeuert wurde
        public Boolean SaucerShot;//ob der Schuss vom ufo kommt
        public int Winkelbyte; // das Winkelbyte zum abgeschossenen Zeitpunkt
        public double Winkel;

        public int[] dxarray = new int[8];
        public int[] dyarray = new int[8];


        public Boolean vorhanden;

        public void set(int x, int y)
        {
	        this.x = x;
	        this.y = y;
        }
        public void setold(int pox, int poy)
        {
            ox = pox;
            oy = poy;
        }
        public void setVorhanden(Boolean bl)
        {
            vorhanden = bl;
        }

       
        public void setaktuell(int px, int py)
        {
            //Variablen neu setzen
            ox = x;
            oy = y;
            x = px;
            y = py;

            //Geschwindigkeit neu berechnen
            setspeed++;
            dx = x - ox;
            dy = y - oy;
            dxarray[setspeed % 8] = (int)dx;
            dyarray[setspeed % 8] = (int)dy;
            dx = 0;
            dy = 0;

            for (int a = 0; a < 8; a++)
            {
                dx += dxarray[a];
                dy += dyarray[a];
            }
            dx = dx / 8;
            dy = dy / 8;

            dg = Math.Sqrt(((dx * dx) + (dy * dy)));
        }
        public void setfromShip(Boolean fromship)
        {
            shipshot = fromship;
        }
        public void setfromSauer(Boolean fromsaucer)
        {
            SaucerShot = fromsaucer;
        }
        public void setWinkelbyte(int Wbyte)
        {
            Winkelbyte = Wbyte;
        }
        public void setWinkel(double pWinkel)
        {
            Winkel = pWinkel;
        }

    }
    class log
    {
        public int winkel;
        public double dx;
        public double dy;
    
        public log(int pwinkel,double pdx ,double pdy)
        {
            winkel =  pwinkel;
            dx = pdx;
            dy = pdy;
        }

    }

    class GameStatus
    {
	    public bool ship_present;  // Schiff sichtbar
	    public int ship_x;         // Mittelpunkt des Schiffs
	    public int ship_y;
	    public int ship_dx;        // Blickrichtung des Schiffes
	    public int ship_dy;
	    public bool saucer_present;// UFO sichtbar
	    public int saucer_x;       // Mittelpunkt des UFOs
	    public int saucer_y;
	    public int saucer_size;    // Größe: 15 = groß, 14 = klein
	    public int nasteroids; // Anzahl Asteroiden
	    public Asteroid[] asteroids = new Asteroid[100];
	    public int nshots;     // Anzahl Schüsse
	    public Shot[] shots = new Shot[10];
	   
        public void clear()
        {
	        ship_present = false;
	        saucer_present = false;
	        nasteroids = 0;
	        nshots = 0;

            for (int i = 0; i < 100; i++)
                asteroids[i] = new Asteroid();

            for (int i = 0; i < 10; i++)
                shots[i] = new Shot();
        }
    }

    public class FramePacket
        {
        public byte[] vectorram = new byte[1026];
        public UInt16[] vectorram2 = new UInt16[513];
        public char frameno;  // wird bei jedem Frame inkrementiert
        public char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück

        public static FramePacket FromByteArray(byte[] array)
        {
            FramePacket np = new FramePacket();

            for (int i = 0; i < 513; i++)
            {
                // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
                // muss, kopiere ich die Daten in ein ushort Array um.
                np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
                np.vectorram[i] = array[i];
            }

            np.frameno = (char)array[1024];
            np.ping = (char)array[1025];

            return np;
        }
    }

    public class KeysPacket
    {
	    const int KEY_HYPERSPACE = 1;
        const int KEY_FIRE = 2;
        const int KEY_THRUST = 4;
        const int KEY_RIGHT = 8;
        const int KEY_LEFT = 16;
        public int keys;

	    public char ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

        public KeysPacket()
        {
	        keys = '@';
	        ping = (char)0;
        }

        public byte[] ToByteArray()
        {
            byte[] byts  = new byte[8];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'m';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)keys;
            byts[7] = (byte)ping;

            return byts;
        }

        public void clear()
        {
	        keys = '@';
        }

        public void hyperspace(bool b)
        {
	        if (b)
		        keys |= KEY_HYPERSPACE;
	        else
		        keys &= ~KEY_HYPERSPACE;
        }

        public void fire(bool b)
        {
	        if (b)
		        keys |= KEY_FIRE;
	        else
                keys &= ~KEY_FIRE;
        }

        public void thrust(bool b)
        {
	        if (b)
		        keys |= KEY_THRUST;
	        else
                keys &= ~KEY_THRUST;
        }

        public void left(bool b)
        {
	        if (b)
	        {
		        keys |= KEY_LEFT;
		        right(false);
	        }
	        else
                keys &= ~KEY_LEFT;
        }

        public void right(bool b)
        {
	        if (b)
	        {
		        keys |= KEY_RIGHT;
		        left(false);
	        }
	        else
                keys &= ~KEY_RIGHT;
        }
    }
}
