#include "YAPlayer.h"
#include "Ship.h"
#include "Tools.h"
#include "Log.h"
#include "defines.h"
#include <iostream>
#include <math.h>

char YAPlayer::engageTarget(Universe* universe, FlyingObject* iteratorAsteroids)
{
	ShotAction action = Tools::calcShotAction(universe->getShip(),*iteratorAsteroids);
	if(action.turnSteps == 0 && action.waitFrames == 0)
	{
		if(universe->canShoot())
			return Key::SHOOT;
		else
			return Key::NONE;
	}
	else if(action.angle - universe->getShip().getAngle() > 0)
	{
		if(universe->getShip().getNumShots() < 3)
			return Key::LEFT | checkTargets(universe,universe->getShip().getAngle(),0.9);
		else
			return Key::LEFT;
	}
	else if(action.angle - universe->getShip().getAngle() < 0)
	{
		if(universe->getShip().getNumShots() < 3)
			return Key::RIGHT | checkTargets(universe,universe->getShip().getAngle(),0.9);
		else
			return Key::RIGHT;
	}
	else
		return Key::NONE;
}

char YAPlayer::decideMove(Universe* universe)
{
	int asteroidCount;
	char keys = Key::NONE;
	if(!universe->getShip().isUsed())
	{
		keys = Key::NONE;
	}
	else if(checkCollisions(universe))
	{
		keys = Key::HYPERSPACE | Key::SHOOT;
	}
	else if(universe->getUfo().isUsed() && universe->getUfo().getHits() == 0)
	{
		keys = engageTarget(universe, &universe->getUfo());
	}
	else
	{
		list<Asteroid>* asteroids = universe->getAsteroids();
		asteroidCount = asteroids->size();
		if(asteroids->size() == 0)
		{
			if(universe->getUfo().isUsed())
			{
				keys = engageTarget(universe, &universe->getUfo());
			}
			else
			{
				keys = Key::NONE;
			}
		}
		else if(asteroids->size() == 1)
		{
			keys = engageTarget(universe, &asteroids->front());
		}
		else
		{
			char tempKeys = Key::NONE;
			int shootTime, turnTime = 0;
			int cost,gain;
			int score;
			int maxScore(0);
			
			for(list<Asteroid>::iterator iteratorAsteroids = asteroids->begin(); iteratorAsteroids != universe->getAsteroids()->end();iteratorAsteroids++)
			{
				//asteroiden überspringen, die schon eine packung abkriegen
				if(!(iteratorAsteroids->getHits() == 0 || (iteratorAsteroids->getAsteroidSize().getValue() >= AsteroidSize::medium.getValue() && iteratorAsteroids->getHits() < 2) || (iteratorAsteroids->getAsteroidSize() == AsteroidSize::big && iteratorAsteroids->getHits() < 3)))
					continue;
				
				//in 111 frames kann man eine 180°-Wende und einen maximalen Schuss machen
				//kurze Zeiten zuerst untersuchen
				for(int time = 1; time < 111; time++)
				{
					//die Zeit zwischen Drehung und Flugzeit aufteilen
					for(shootTime = (time-42 > 0) ? time - 42 : 0; shootTime <= time && shootTime < 69; shootTime++)
					{
						turnTime = time - shootTime;
						wxPoint impact1;
						wxPoint impact2;
						wxPoint targetPositionTemp;
						
						//Schusspositionen berechnen
						impact1.x = universe->getShip().getAbsolutePosition().x + Tools::getShotStartPoint(universe->getShip().getAngle()+turnTime*3).x + Tools::internToShot(universe->getShip().getAngle()+turnTime*3).x*shootTime;
						impact1.y = universe->getShip().getAbsolutePosition().y + Tools::getShotStartPoint(universe->getShip().getAngle()+turnTime*3).y + Tools::internToShot(universe->getShip().getAngle()+turnTime*3).y*shootTime;
						impact2.x = universe->getShip().getAbsolutePosition().x + Tools::getShotStartPoint(universe->getShip().getAngle()-turnTime*3).x + Tools::internToShot(universe->getShip().getAngle()-turnTime*3).x*shootTime;
						impact2.y = universe->getShip().getAbsolutePosition().y + Tools::getShotStartPoint(universe->getShip().getAngle()-turnTime*3).y + Tools::internToShot(universe->getShip().getAngle()-turnTime*3).y*shootTime;

						//Zielposition berechnen
						targetPositionTemp.x = iteratorAsteroids->getAbsolutePosition().x + iteratorAsteroids->getFlightVector().x*shootTime;
						targetPositionTemp.y = iteratorAsteroids->getAbsolutePosition().y + iteratorAsteroids->getFlightVector().y*shootTime;
				
						//quadratische Längen
						//links
						unsigned int distance = Tools::pythagoras(Tools::minDistance(impact1-targetPositionTemp));
						if(distance < (iteratorAsteroids->getSize())*(iteratorAsteroids->getSize()))
						{
							tempKeys = Key::LEFT;
							time = 111;
							break;
						}
						//rechts
						distance = Tools::pythagoras(Tools::minDistance(impact2-targetPositionTemp));
						if(distance < (iteratorAsteroids->getSize())*(iteratorAsteroids->getSize()))
						{
							tempKeys = Key::RIGHT;
							time = 111;
							break;
						}
					}
				}
				//keine Möglichkeit gefunden
				//FIXME: man könnte trotzdem drauf zusteuern
				if(shootTime > 69)
					continue;
				//Kosten/Nutzen-Analyse
				//Schusszeit geht quadratisch ein, weil man in der Zeit weniger Schüsse zur Verfügung hat
				//außerdem verringerte Treffsicherheit
				cost = turnTime + shootTime*shootTime*universe->getShip().getNumShots() + 1;
				//eine Bedrohung weniger
				gain = 100;
				//Punktgewinn
				/*if(iteratorAsteroids->getAsteroidSize() == AsteroidSize::small)
					gain += 100;
				else if(iteratorAsteroids->getAsteroidSize() == AsteroidSize::medium)
					gain += 50;
				else
					gain += 20;*/
				int collisionTime = iteratorAsteroids->getFramesToCollision();
				//Kollisionsvermeidung
				if(collisionTime > 0)
				{
					//je schwieriger die Kollision abzuwenden ist, desto mehr Punkte
					if(turnTime <= collisionTime)
						gain += 1500000;
					else
						gain += 5000.0*exp(1.0/(double)((collisionTime-turnTime)*(collisionTime-turnTime))) - 5000;
				}
				//Rundungsfehler verkleinern
				gain *= 100;
				score = gain / cost;
				
				if(score > maxScore)
				{
					maxScore = score;
					keys = tempKeys;
				}
			}
			keys |= checkTargets(universe,universe->getShip().getAngle(),0.9);
		}
	}
	delete universe;
	return keys;
}
