#ifndef UNIVERSE_H_
#define UNIVERSE_H_

#include "Ufo.h"
#include "Shot.h"
#include "Asteroid.h"
#include "Ship.h"
#include <list>

using namespace std;

class Universe
{
private:
	list<Asteroid>* asteroids;
	list<Shot>* shots;
	Ufo ufo;
	Ship ship;
	int latency;
	int frameID;
	char receivedKeys;
	bool isHyperspaceAllowed;
	bool isShootingAllowed;
public:	
	Universe(int frameID,Ship& ship,list<Asteroid>* asteroids, list<Shot>* shots, Ufo& ufo, int latency,bool isHyperspaceAllowed, bool isShootingAllowed,char keys);
	
	~Universe()
	{
		delete asteroids;
		delete shots;
	}
	
	int getLatency() { return latency; }
	
	list<Asteroid>* getAsteroids() { return asteroids; }

	list<Shot>* getShots() { return shots; }

	Ufo& getUfo() { return ufo; }

	Ship& getShip() { return ship; }
	
	char getReceivedKeys()
	{
		return receivedKeys;
	}
	
	bool canShoot()	{ return isShootingAllowed; }
	
	bool canHyperspace() { return isHyperspaceAllowed; }
	
	int getFrameID()
	{
		return frameID;
	}
};

#endif /*UNIVERSE_H_*/
