#ifndef UFOSIZE_H_
#define UFOSIZE_H_

//kann für Snapshots und richtige Ufos verwendet werden

class UfoSize
{
private:
	unsigned int size;
	
	//verhindere die globale Erzeugung beliebiger Größen
	UfoSize(unsigned int size);
public:
	//nur Kopien der static member sind erlaubt
	UfoSize(const UfoSize& that);

	unsigned int getValue() const;
	
	bool operator==(const UfoSize& ufo) const
	{
		return size == ufo.size;
	}
	
	static const UfoSize small; 
	static const UfoSize big;
};

#endif
