#ifndef TRACKINGLAYER_H_
#define TRACKINGLAYER_H_

//#define maxAsteroidsAndExplosions 27

#include "Repository.h"
#include "SortedList.h"
#include "MovingTrackingObject.h"
#include "ShotMirage.h"

#include <vector>
#include <map>

//template class TrackingObject<AsteroidSnapshot>;
//template class TrackingObject<ShotSnapshot>;

class TrackingLayer: public wxThread
{
private:
	Repository* repository;
	
	int latency;
	int latestFrameID;
	int currentObjectID;
	Angle minAngle;
	Angle maxAngle; 
	int shoot;
	Action receivedAction;
	
	Snapshot* snapshot;
	
	unsigned char latestUdpID;
	unsigned char nextUdpID;
	
	Action lastValidAction;
	
	ShotMirage shotMirages[256];
	
	unsigned char startMirage;
	
	int numShots;
	
	struct ShotInfo
	{
		int ID;
		int frameID;
	};
		
	ShotInfo shotIDs[4];

	
	template<class T>
	class MatchingRelation
	{
	private:
		int distance;
		T matchingRelation;
	public:
		MatchingRelation(unsigned int distance,const T& matchingRelation):
						distance(distance),
						matchingRelation(matchingRelation)
						{ }
						
		MatchingRelation()
		{
			distance = -1;
		}
		
		
		int operator== (MatchingRelation& ref)
		{
			return distance == ref.distance;
		}
		
		int getDistance() const
		{
			return distance;
		}
		
		void setDistance(int distance)
		{
			this->distance = distance;
		}
		
		
		T getMatchingRelation() const
		{
			return matchingRelation;
		}
		
		void setMatchingRelation(const T& matchingRelation)
		{
			this->matchingRelation = matchingRelation;
		}
		
		bool operator>(MatchingRelation& ref)
		{
			if(distance == -1)
				return true;
			if(ref.distance == -1)
				return false;
			return distance>ref.distance;
		}
		
		bool operator<(MatchingRelation& ref)
		{
			if(distance == -1)
				return false;
			if(ref.distance == -1)
				return true;
			return distance<ref.distance;
		}
	}; 
	
	template<class T, class V>
	class SnapshotMatchingRelation:public MatchingRelation<V>
	{
	private:
		T snapshotMatching;
	public:
		SnapshotMatchingRelation(const T& snapshotMatching,unsigned int distance,const  V& matchingRelation):
									MatchingRelation<V>(distance, matchingRelation),
									snapshotMatching(snapshotMatching)
									{
									}
									
		SnapshotMatchingRelation()
		{
		}
		
		T getSnapshotMatching()
		{
			return snapshotMatching;
		}
		
		void setSnapshotMatching(const T& snapshot)
		{
			snapshotMatching = snapshot;
		}
	};
	
	list<int> currentVictims;
	
	list<TrackingObject<AsteroidSnapshot> > asteroidsTracking[12];	
	
	list<TrackingObject<ShotSnapshot> > shotsTracking;
	ShipTrackingObject<ShipSnapshot> shipTracking;
	MovingTrackingObject<UfoSnapshot> ufoTracking;
	
	//TrackingObject<FlyingObjectSnapshot> asteroidsAndExplosionsTracking[maxAsteroidsAndExplosions];
	
	template<class T>
	void matchFlyingObject(list<T>& snapshots,list< TrackingObject<T> >&tracking);
	void matchShip(ShipSnapshot& ship);
	void matchUfo(UfoSnapshot& ufo);
	
	//void matchAsteroidsAndExplosions(FlyingObjectSnapshot** objects, int numberObjects);
	
	Universe* buildUniverse();
	
	void updateShipAngles();
	void calibrateShipAngles();
	
	Angle getEstimatedAngle();
	
	void checkVictims(Universe* universe);
	
	void updateShotMirages();
	
	template<class V>
	void updateMatching(typename list<V >::iterator& snapshot,list < SortedList < MatchingRelation < int > > >::iterator& currentDistance,vector< SnapshotMatchingRelation<typename list< V >::iterator, list< SortedList< MatchingRelation< int > > >::iterator> >& matching);
	
	
	
public:
	TrackingLayer(Repository *repository):
		repository(repository),
		latency(0),
		latestFrameID(0),
		currentObjectID(0),
		minAngle(-3),
		maxAngle(3),
		shoot(0),
		snapshot(0),
		latestUdpID(0),
		nextUdpID(0),
		startMirage(0),
		shipTracking(),
		ufoTracking()
	{
		for(int i =0;i<256;i++)
		{
			shotMirages[i].setFrameID(-1);
		}
	}

	~TrackingLayer()
	{ }
	
	void trackData();
	
	void* Entry();
};


#endif /*TRACKMANAGER_H_*/
