#ifndef TOOLS_H_
#define TOOLS_H_

#include <wx/gdicmn.h>
#include "Angle.h"
#include "Matrix.h"
#include "ShotAction.h"
#include "FlyingObject.h"
#include "Ship.h"

class Tools
{
private:
	static int maxX;
	static int maxY;
	static int maxScreenX;
	static int maxScreenY;
	static int minScreenY;
	static int minScreenX;
	
	static wxPoint internToShotDirection[256];
	static Angle visibleToIntern[256];
	static wxPoint shotStartPoints[256];
	
public:
	static Angle targetAngle(const wxPoint& shipPosition,const wxPoint & shipFlightVector,Angle shipAngle, const wxPoint& objectPosition ,const wxPoint & objectFlightVector);
	
	static ShotAction calcShotAction(Ship & ship,FlyingObject & obj);
	
	static wxPoint getShotStartPoint(Angle angle);
	
	static wxPoint getTargetVector(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector);

	static wxPoint getTargetCollisionPoint(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector, wxPoint shotFlightVector);

	static int getCollisionTime(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector, wxPoint shotFlightVector);

	static double getRotationAngle(wxPoint firstVector, wxPoint secondVector);

	static Angle minInternAngle(Angle visible);

	static Angle maxInternAngle(Angle visible);

	static wxPoint internToShot(Angle angle);
	
	static wxPoint minDistance(const wxPoint& point);
	
	static wxPoint calcPosition(const wxPoint& currentPosition, const wxPoint& flightVector, int frames);
	
	static int getFrameDiff(int currentFrameID,int newFrameID);
	
	static int pythagoras(const wxPoint &point);
	
	static wxPoint transform(wxPoint transformationPoint, wxPoint base, Angle angle);
	
	static wxPoint rotate(wxPoint rotationPoint, Angle angle);
	
	static wxPoint translate(wxPoint translationPoint, wxPoint base);
	
	static Matrix* createRotationMatrix(Angle angle);
	static Matrix* createRotationMatrix(Angle angle,const Matrix& base);
	
	static Matrix* createTranslationMatrix(const wxPoint& poing);
	static Matrix* createTranslationMatrix(const wxPoint& point, const Matrix& base);
	
	static wxPoint transformByMatrix(const wxPoint& ref, const Matrix& matrix);
	
	static Angle arctan(int x, int y);
	
	static int calcCollision(const wxPoint &shipPoint, const wxPoint& shipFlightVector, int shipSize, const wxPoint& objectPoint, const wxPoint& objectFlightVector, int objectSize, int frames = 256,double precision=1);
	
	static bool nextPane(wxPoint & currentPosition,const wxPoint& flightVector, wxPoint& currentPane, const wxPoint & endPoint);
	
	static int getMinDistance(int shipSize, int objectSize);  
	
	
};

#endif /*TOOLS_H_*/
