#include "Tools.h"
#define _USE_MATH_DEFINES
#include <cmath>
#include <wx/string.h>
#include <wx/wx.h>

Angle Tools::targetAngle(const wxPoint& shipPosition,const wxPoint & shipFlightVector,Angle shipAngle, const wxPoint& objectPosition ,const wxPoint & objectFlightVector)
{
	//wxLogDebug("Ship (%d,%d) flightVector (%d,%d) Angle %d Object (%d,%d) flightVector (%d,%d)",shipPosition.x, shipPosition.y, shipFlightVector.x,shipFlightVector.y,shipAngle,objectPosition.x,objectPosition.y,objectFlightVector.x,objectFlightVector.y);
	double tX, tY, pX, pY, oX, oY; /* t = Zielvektor, p = Bewegungsvektor d. Ziels, o = Ortsvektor d. Ziels rel. zum Schiff, s = Bewegungsvektor d. Schiffs*/
	wxPoint minDist = Tools::minDistance(objectPosition-shipPosition);
	oX = minDist.x;
	oY = minDist.y;
	pX = objectFlightVector.x-shipFlightVector.x;
	pY = objectFlightVector.y-shipFlightVector.y;
	double var1, var2; // resp. p und q in der p-q-Formel
	if(oX == 0 && oY == 0)
	{
		exit(42);
	}
	var1 = 2*(-pY*oX*oX+pX*oY*oX)/(oX*oX+oY*oY);
	var2 = (oX*oX*pY*pY+pX*pX*oY*oY-64*64*oY*oY-2*pX*pY*oY*oX)/(oX*oX+oY*oY);
	
	tY = -var1/2 + sqrt((var1*var1)/4  - var2);
	
	if(oY/(tY-pY) < 0)
	{
		tY = -var1/2 - sqrt(var1*var1/4  - var2);
	}
	
	tX = sqrt(64*64 - tY*tY);
	if(oX/(tX-pX) < 0)
	{
		tX = -sqrt(64*64 - tY*tY);
	}
	
	//wxLogDebug("Estimated Vector (%lf,%lf)",tX,tY);
	
	minDist.x = (int)tX+0.5;
	minDist.y = (int)tY+0.5;
	
	Angle offset;
	wxPoint shotDirection = Tools::internToShot(shipAngle);
	
	tX = shotDirection.x*minDist.y - shotDirection.y*minDist.x;
	
	if(tX > 0)
	{
		offset = 3;
	}
	else if(tX < 0)
	{
		offset = -3;
	}
	else
		return shipAngle;
	
	Angle angle = shipAngle;
	
	int min = Tools::pythagoras(Tools::internToShot(angle)-minDist);
	
	for(int i = 1, tempAngle = angle+offset; i< 256;i++,tempAngle+=offset)
	{
		if(min > Tools::pythagoras(Tools::internToShot(tempAngle)-minDist))
		{
			min = Tools::pythagoras(Tools::internToShot(tempAngle)-minDist);
			angle = tempAngle;
		}
		else
			break;
	}
	
	//wxLogDebug("Angle %d ShotDirection (%d,%d)",angle, Tools::internToShot(angle).x,Tools::internToShot(angle).y);
	return angle;
}

ShotAction Tools::calcShotAction(Ship& ship,FlyingObject & obj)
{
	wxPoint shipPosition = ship.getAbsolutePosition();
	wxPoint shipFlightVector = ship.getFlightVector();
	Angle angle = ship.getAngle();
	Angle oldAngle = angle;
	wxPoint objectPosition = obj.getAbsolutePosition();
	wxPoint objectFlightVector = obj.getFlightVector();
	int steps;
	int turnSteps = 0;
	Angle direction =0;
	
	int wait = 0;
	Angle waitAngle;
	
	ShotAction shotAction;
	
	if(objectFlightVector.x == 0 && objectFlightVector.y == 0)
	{
		shotAction.shotFrames =-1;
		shotAction.turnSteps = 0x01ffffff;
		shotAction.waitFrames = 0x01ffffff;
		shotAction.ptr = &obj;
		return shotAction;
	}
	//wxLogDebug("shipAngle %d",ship.getAngle());
	//wxLogDebug("new Target");
	
	while(true)
	{
		if((shotAction.shotFrames =Tools::calcCollision(shipPosition+Tools::getShotStartPoint(angle),Tools::internToShot(angle),1,objectPosition,objectFlightVector,obj.getSize(),68,0.9))!=-1)
		{
			shotAction.angle = angle;
			shotAction.turnSteps = turnSteps;
			shotAction.ptr = &obj;
			shotAction.waitFrames = wait;
			return shotAction;
		}
		oldAngle = angle;
		
		angle = targetAngle(shipPosition,shipFlightVector,oldAngle,objectPosition,objectFlightVector);
		//wxLogDebug("Angle %d old Angle %d",angle,oldAngle);
		
		
		
		if(angle == oldAngle)
		{	
			waitAngle = angle;
			wait++;
			
			shipPosition = Tools::calcPosition(shipPosition,shipFlightVector,1);
			objectPosition = Tools::calcPosition(objectPosition,objectFlightVector,1);
			
			//wxLogDebug("turnSteps %d, wait %d, angle %d, oldAngle %d shot %d",turnSteps,wait,angle,angle-oldAngle,Tools::calcCollision(shipPosition+Tools::getShotStartPoint(angle),Tools::internToShot(angle),1,objectPosition,objectFlightVector,obj.getSize(),200,0.9));
			
			//wxLogDebug("wait increase %d",wait);
			/*
			shotAction.angle = angle;
			shotAction.turnSteps = turnSteps;
			shotAction.framesShot = -1;
			shotAction.ptr = &obj;
			return shotAction;
			*/
		}
		else
		{	
			oldAngle = angle - oldAngle;
			
			if(oldAngle < 0)
				direction = -3;
			else
				direction = 3;
			
			steps = oldAngle/direction;
			
			if(wait != 0)
			{
				if(wait > steps)
				{
					wait -= steps;
					steps = 0; 
				}
				else
				{
					steps -=wait;
					wait=0;
				}
				
				//wxLogDebug("wait decrease %d steps %d",wait,steps);
			}
			
			shipPosition = Tools::calcPosition(shipPosition,shipFlightVector,steps);
			objectPosition = Tools::calcPosition(objectPosition,objectFlightVector,steps);
			
			turnSteps += steps;
		}
		
		
		
	}
	
}

wxPoint Tools::getShotStartPoint(Angle angle)
{
	return shotStartPoints[(unsigned char)angle];
}


wxPoint Tools::getTargetVector(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector)
{
	double tX, tY, oX, oY, eX, eY; // t = Zielvektor, o = Ortsvektor d. Ziels rel. zum Schiff, e = Bewegungsvektor d. Ziels - Bew.-vektor d. Schiffs (vereinfach die Rechnung
	eX = objectFlightVector.x - shipFlightVector.x;
	eY = objectFlightVector.y - shipFlightVector.y;
	oX = objectVector.x;
	oY = objectVector.y;
	tX = (-oX*sqrt(oX*oX*(64*64-eY*eY)+2*oX*oY*eY*eX-oY*oY*(eX-64*64))-oY*(oX*eY-oY*eX))/(oX*oX+oY*oY);
	if((tX-oX)/objectFlightVector.x < 0)
	{
		tX = (oX*sqrt(oX*oX*(64*64-eY*eY)+2*oX*oY*eY*eX-oY*oY*(eX-64*64))-oY*(oX*eY-oY*eX))/(oX*oX+oY*oY);
	}
	tY = sqrt(64*64 - tX*tX);
	if((tY-oY)/objectFlightVector.y < 0)
	{
		tY = -tY;
	}
	wxPoint result((int)tX, (int)tY);
	return result;
}

wxPoint Tools::getTargetCollisionPoint(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector, wxPoint shotFlightVector)
{
	if((shotFlightVector.x-objectFlightVector.x+shipFlightVector.x) != 0)
	{
		int collisionTime = objectVector.x/(shotFlightVector.x-objectFlightVector.x+shipFlightVector.x);
		wxPoint result(shotFlightVector.x*collisionTime, shotFlightVector.y*collisionTime);
		return result;
	}
	else
	{
		int collisionTime = objectVector.y/(shotFlightVector.y-objectFlightVector.y+shipFlightVector.y);
		wxPoint result(shotFlightVector.x*collisionTime, shotFlightVector.y*collisionTime);
		return result;
	}
}

double Tools::getRotationAngle(wxPoint firstVector, wxPoint secondVector) //gibt den Drehwinkel zur�ck,den man zur�cklegt,wenn man Vektor1 gg. d. Uhrzeigersinn in Vektor2 �berf�hrt
{
	double tempAngle = acos((double)((firstVector.x*secondVector.x+firstVector.y*secondVector.y)/(sqrt(firstVector.x*firstVector.x+firstVector.y*firstVector.y)*sqrt(secondVector.x*secondVector.x+secondVector.y*secondVector.y))));
	if(firstVector.x*secondVector.y-firstVector.y*secondVector.x < 0)
	{
		tempAngle+=2*(M_PI-tempAngle);
	}
	return tempAngle;
}

int Tools::getCollisionTime(wxPoint objectVector, wxPoint objectFlightVector, wxPoint shipFlightVector, wxPoint shotFlightVector)
{
	if((shotFlightVector.x-objectFlightVector.x+shipFlightVector.x) != 0)
	{
		int collisionTime = objectVector.x/(shotFlightVector.x-objectFlightVector.x+shipFlightVector.x);
		return collisionTime;
	}
	else
	{
		int collisionTime = objectVector.y/(shotFlightVector.y-objectFlightVector.y+shipFlightVector.y);
		return collisionTime;
	}
}

Angle Tools::minInternAngle(Angle visible)
{
	return visibleToIntern[(unsigned char)visible];
}
	
Angle Tools::maxInternAngle(Angle visible)
{
	return visibleToIntern[(unsigned char)(visible+1)];
}

wxPoint Tools::internToShot(Angle angle)		
{
	return internToShotDirection[(unsigned char)angle];
}
		
		

wxPoint Tools::minDistance(const wxPoint& point)
{
	wxPoint result(point);
	while(result.x > maxX>>1)
		result.x -= maxX;
	
	while(result.x < -maxX>>1)
		result.x += maxX;
		
	while(result.y > maxY >> 1)
		result.y -= maxY;
	
	while(result.y < -maxY >>1)
		result.y += maxY;
		
	return result;
	
}

wxPoint Tools::calcPosition(const wxPoint& currentPosition,const wxPoint& flightVector,int frames)
{
	wxPoint result;
	
	result.x = (currentPosition.x+ flightVector.x*frames);

	while(result.x > Tools::maxScreenX)
		result.x -= Tools::maxX;
		
	while(result.x < Tools::minScreenX)
		result.x += Tools::maxX;
		
	result.y = (currentPosition.y+ flightVector.y*frames);
	
	while(result.y > Tools::maxScreenY)
		result.y -= Tools::maxY;
	
	while(result.y < Tools::minScreenY)
		result.y += Tools::maxY;
	
	return result;
}

int Tools::getFrameDiff(int currentFrameID, int newFrameID)
{
	if(newFrameID - currentFrameID >= 0)
		return newFrameID-currentFrameID;
		
	if(currentFrameID - newFrameID > 128)
		return newFrameID-(currentFrameID-256);
		
	return -1;
}

int Tools::pythagoras(const wxPoint& point)
{
	return point.x*point.x+ point.y*point.y;
}

wxPoint Tools::rotate(wxPoint rotationPoint, Angle angle)
{
	double transformedAngle = (double)angle/128*M_PI;
	wxPoint result;
	
	result.x = (int)(rotationPoint.x*cos(transformedAngle)+rotationPoint.y*sin(transformedAngle)+0.5);
	result.y = (int)(-rotationPoint.x*sin(transformedAngle)+rotationPoint.y*cos(transformedAngle)+0.5);
	
	return result;
}

wxPoint Tools::translate(wxPoint translationPoint, wxPoint base)
{
	translationPoint.x -= base.x;
	translationPoint.y -= base.y;
	
	return translationPoint;
}

wxPoint Tools::transform(wxPoint transformationPoint, wxPoint base, Angle angle)
{
	transformationPoint = translate(transformationPoint, base);
	
	return rotate(transformationPoint, angle);
}

Matrix* Tools::createRotationMatrix(Angle angle)
{
	double transformedAngle = (double)angle/128*M_PI;
	
	Matrix* newMatrix = new Matrix();
	
	newMatrix->matrix[0][0] = cos(transformedAngle);
	newMatrix->matrix[1][0] = sin(transformedAngle);
	newMatrix->matrix[0][1] = -newMatrix->matrix[1][0];
	newMatrix->matrix[1][1] = newMatrix->matrix[0][0];
	
	return newMatrix;
		
}

Matrix* Tools::createRotationMatrix(Angle angle, const Matrix& base)
{	
	Matrix *newMatrix = createRotationMatrix(angle);
	
	*newMatrix *= base;
	
	return newMatrix;
}

Matrix* Tools::createTranslationMatrix(const wxPoint& point,const Matrix & base)
{
	Matrix* newMatrix = createTranslationMatrix(point);
	
	*newMatrix *= base;
	
	return newMatrix;
	
}

Matrix* Tools::createTranslationMatrix(const wxPoint& point)
{
	Matrix* newMatrix = new Matrix();
	
	newMatrix->matrix[2][0] = point.x;
	newMatrix->matrix[2][1] = point.y;
	
	return newMatrix;
}

wxPoint Tools::transformByMatrix(const wxPoint& point, const Matrix& matrix)
{
	wxPoint result;
	
	result.x = (int)(point.x * matrix.matrix[0][0] + point.y*matrix.matrix[1][0] + matrix.matrix[2][0]+0.5);
	result.y = (int)(point.y * matrix.matrix[0][1] + point.y*matrix.matrix[1][1] + matrix.matrix[2][1]+0.5);
	
	return result;
}

Angle Tools::arctan(int y, int x)
{
	Angle angle = (Angle)(atan2(y,x)*128/M_PI+0.5);
	if(x == 0 && y > 0)
		angle = 64;
	else if(x == 0 && y < 0)
		angle = -64;
	
	return angle;
	
}

int Tools::calcCollision(const wxPoint &shipPosition, const wxPoint& shipFlightVector, int shipSize, const wxPoint& objectPosition, const wxPoint& objectFlightVector, int objectSize,int frames,double precision)
{
	wxPoint flightVector =  objectFlightVector-shipFlightVector;
	wxPoint currentPosition = objectPosition;
	wxPoint currentPane = wxPoint(0,0);
	wxPoint endPosition;
	wxPoint collisionPoint;
	
	if(objectPosition.x < Tools::minScreenX || objectPosition.x >= Tools::maxScreenX || objectPosition.y < Tools::minScreenY || objectPosition.y >= Tools::maxScreenY)
		return -1;
	
	endPosition.x = objectPosition.x + (frames * flightVector.x);
	endPosition.y = objectPosition.y + (frames* flightVector.y);
	
	int flightVectorLength = Tools::pythagoras(flightVector);
	
	if(flightVectorLength == 0)
		return -1;
	
	int minDistance = shipSize*shipSize + 2*shipSize*objectSize + objectSize*objectSize;
	minDistance = (int)(precision*minDistance);
	int tempDistance; 
	double tempFrames;
	double temp;
	
	while(true)
	{
		tempFrames = ((currentPane.x + shipPosition.x - objectPosition.x)*flightVector.x + (currentPane.y +shipPosition.y - objectPosition.y)*flightVector.y)/(double)flightVectorLength;
		
		collisionPoint.x =(int) (objectPosition.x + tempFrames*flightVector.x+0.5);
		collisionPoint.y =(int) (objectPosition.y + tempFrames*flightVector.y+0.5);
		
		tempDistance = Tools::pythagoras(shipPosition +currentPane - collisionPoint);
		
		if(tempDistance <= minDistance)
		{
			temp = tempFrames;
			tempFrames -=  sqrt((minDistance - tempDistance)/(double)flightVectorLength);

			if(tempFrames <= frames && tempFrames >= 0)
			{
				//if(shipSize == 1)
					//wxLogDebug(_("Ship (%d,%d) FlightVector (%d,%d) Object (%d,%d) FlightVector (%d,%d) dist %d minDist %d frames %lf temp %lf col(%d,%d)"),shipPosition.x,shipPosition.y,shipFlightVector.x,shipFlightVector.y,objectPosition.x,objectPosition.y,objectFlightVector.x,objectFlightVector.y,tempDistance,minDistance,tempFrames,temp,(int)(objectPosition.x+(int)(tempFrames*objectFlightVector.x)),(int)(objectPosition.y+(int)(tempFrames*objectFlightVector.y)));
				return (int)(tempFrames);
			}
		}
		
		if(!Tools::nextPane(currentPosition,flightVector,currentPane,endPosition))
			break;
	}
		
	return -1;
	
}

bool Tools::nextPane(wxPoint & currentPosition, const wxPoint& flightVector, wxPoint& currentPane, const wxPoint& endPoint)
{
	int factorX,factorY;
	
	if(endPoint.x >= currentPane.x && endPoint.x <= (currentPane.x+Tools::maxScreenX) && endPoint.y >= (currentPane.y) && endPoint.y <= (currentPane.y+Tools::maxScreenY))
		return false;
		
	if(flightVector.y == 0)
	{
		if(flightVector.x > 0)
		{
			factorX = (int)((Tools::maxScreenX - currentPosition.x)/(double)flightVector.x+1);
			currentPosition.x += factorX*flightVector.x;
			
			while(currentPosition.x > Tools::maxScreenX)
			{
				currentPane.x += Tools::maxX;
				currentPosition.x -= Tools::maxX;
			}
			
			return true;
		}
		else
		{
			factorX = (int)((Tools::minScreenX - currentPosition.x)/(double)flightVector.x+1);
			currentPosition.x += factorX*flightVector.x;
			
			while(currentPosition.x < Tools::minScreenX)
			{
				currentPane.x -= Tools::maxX;
				currentPosition.x += Tools::maxX;
			}
			
			return true;
		}
	}
	else if(flightVector.x == 0)
	{
		if(flightVector.y >0)
		{
			factorY = (int)((Tools::maxScreenY - currentPosition.y)/(double)flightVector.y+1);
			
			currentPosition.y += factorY* flightVector.y;
			
			while(currentPosition.y > Tools::maxScreenY)
			{
				currentPane.y += Tools::maxY;
				currentPosition.y -= Tools::maxY;
			}
			
			return true;
		}
		else
		{
			factorY = (int)((Tools::minScreenY - currentPosition.y)/(double)flightVector.y+1);
			
			currentPosition.y += factorY* flightVector.y;
			
			while(currentPosition.y < Tools::minScreenY)
			{
				currentPane.y -= Tools::maxY;
				currentPosition.y += Tools::maxY;
			}
			
			return true;
		}
	}
	else if(flightVector.x > 0)
	{
		if(flightVector.y > 0)
		{
			factorX = (int)(((Tools::maxScreenX)-currentPosition.x)/(double)flightVector.x+1);
			factorY = (int)(((Tools::maxScreenY)-currentPosition.y)/(double)flightVector.y+1);
			
			if(factorX <= factorY)
			{
				currentPosition.x += factorX*flightVector.x;
				currentPosition.y += factorX*flightVector.y;
			}
			else
			{
				currentPosition.x += factorY*flightVector.x;
				currentPosition.y += factorY*flightVector.y;
			}
			
			while(currentPosition.x > Tools::maxScreenX)
			{
				currentPane.x += Tools::maxX;
				currentPosition.x -= Tools::maxX;
			}
			
			while(currentPosition.y > Tools::maxScreenY)
			{
				currentPane.y += Tools::maxY;
				currentPosition.y -= Tools::maxY;
			}
			
			return true;
		}
		else if(flightVector.y < 0)
		{
			factorX = (int)(((Tools::maxScreenX)-currentPosition.x)/(double)flightVector.x+1);
			factorY = (int)(((Tools::minScreenY)-currentPosition.y)/(double)flightVector.y+1);
			
			if(factorX <= factorY)
			{
				currentPosition.x += factorX*flightVector.x;
				currentPosition.y += factorX*flightVector.y;
			}
			else
			{
				currentPosition.x += factorY*flightVector.x;
				currentPosition.y += factorY*flightVector.y;
			}
			
			while(currentPosition.x > Tools::maxScreenX)
			{
				currentPane.x += Tools::maxX;
				currentPosition.x -= Tools::maxX;
			}
			
			while(currentPosition.y < Tools::minScreenY)
			{
				currentPane.y -= Tools::maxY;
				currentPosition.y += Tools::maxY;
			}
			
			return true;
		}
	}
	else if(flightVector.x < 0)
	{
		if(flightVector.y > 0)
		{
			factorX = (int)(((Tools::minScreenX)-currentPosition.x)/(double)flightVector.x+1);
			factorY = (int)(((Tools::maxScreenY)-currentPosition.y)/(double)flightVector.y+1);
			
			if(factorX <= factorY)
			{
				currentPosition.x += factorX*flightVector.x;
				currentPosition.y += factorX*flightVector.y;
			}
			else
			{
				currentPosition.x += factorY*flightVector.x;
				currentPosition.y += factorY*flightVector.y;
			}
			
			while(currentPosition.x < Tools::minScreenX)
			{
				currentPane.x -= Tools::maxX;
				currentPosition.x += Tools::maxX;
			}
			
			while(currentPosition.y > Tools::maxScreenY)
			{
				currentPane.y += Tools::maxY;
				currentPosition.y -= Tools::maxY;
			}
			
			return true;
		}
		else if(flightVector.y < 0)
		{
			factorX = (int)(((Tools::minScreenX)-currentPosition.x)/(double)flightVector.x+1);
			factorY = (int)(((Tools::minScreenY)-currentPosition.y)/(double)flightVector.y+1);
			
			if(factorX <= factorY)
			{
				currentPosition.x += factorX*flightVector.x;
				currentPosition.y += factorX*flightVector.y;
			}
			else
			{
				currentPosition.x += factorY*flightVector.x;
				currentPosition.y += factorY*flightVector.y;
			}
			
			while(currentPosition.x < Tools::minScreenX)
			{
				currentPane.x -= Tools::maxX;
				currentPosition.x += Tools::maxX;
			}
			
			while(currentPosition.y < Tools::minScreenY)
			{
				currentPane.y -= Tools::maxY;
				currentPosition.y += Tools::maxY;
			}
			
			return true;
		}
		
		
	}
	
	return true;

}

int Tools::getMinDistance(int shipSize,int objectSize)
{
	return shipSize*shipSize+2*shipSize*objectSize+objectSize*objectSize;
}

int Tools::maxX = 8192;
int Tools::maxY = 6144;
int Tools::maxScreenX = 8191;
int Tools::minScreenX = 0;
int Tools::maxScreenY = 7167;
int Tools::minScreenY = 1024;

wxPoint Tools::internToShotDirection[] = {wxPoint(63,0),
		wxPoint(63,1),
		wxPoint(63,3),
		wxPoint(63,4),
		wxPoint(63,6),
		wxPoint(63,8),
		wxPoint(63,9),
		wxPoint(62,11),
		wxPoint(62,12),
		wxPoint(62,14),
		wxPoint(61,15),
		wxPoint(61,17),
		wxPoint(61,18),
		wxPoint(60,20),
		wxPoint(60,21),
		wxPoint(59,23),
		wxPoint(58,24),
		wxPoint(58,25),
		wxPoint(57,27),
		wxPoint(56,28),
		wxPoint(56,30),
		wxPoint(55,31),
		wxPoint(54,32),
		wxPoint(53,34),
		wxPoint(53,35),
		wxPoint(52,36),
		wxPoint(51,38),
		wxPoint(50,39),
		wxPoint(49,40),
		wxPoint(48,41),
		wxPoint(47,42),
		wxPoint(46,44),
		wxPoint(45,45),
		wxPoint(44,46),
		wxPoint(42,47),
		wxPoint(41,48),
		wxPoint(40,49),
		wxPoint(39,50),
		wxPoint(38,51),
		wxPoint(36,52),
		wxPoint(35,53),
		wxPoint(34,53),
		wxPoint(32,54),
		wxPoint(31,55),
		wxPoint(30,56),
		wxPoint(28,56),
		wxPoint(27,57),
		wxPoint(25,58),
		wxPoint(24,58),
		wxPoint(23,59),
		wxPoint(21,60),
		wxPoint(20,60),
		wxPoint(18,61),
		wxPoint(17,61),
		wxPoint(15,61),
		wxPoint(14,62),
		wxPoint(12,62),
		wxPoint(11,62),
		wxPoint(9,63),
		wxPoint(8,63),
		wxPoint(6,63),
		wxPoint(4,63),
		wxPoint(3,63),
		wxPoint(1,63),
		wxPoint(0,63),
		wxPoint(-2,63),
		wxPoint(-3,63),
		wxPoint(-5,63),
		wxPoint(-6,63),
		wxPoint(-8,63),
		wxPoint(-10,63),
		wxPoint(-11,62),
		wxPoint(-13,62),
		wxPoint(-14,62),
		wxPoint(-16,61),
		wxPoint(-17,61),
		wxPoint(-19,61),
		wxPoint(-20,60),
		wxPoint(-22,60),
		wxPoint(-23,59),
		wxPoint(-25,58),
		wxPoint(-26,58),
		wxPoint(-27,57),
		wxPoint(-29,56),
		wxPoint(-30,56),
		wxPoint(-32,55),
		wxPoint(-33,54),
		wxPoint(-34,53),
		wxPoint(-36,53),
		wxPoint(-37,52),
		wxPoint(-38,51),
		wxPoint(-39,50),
		wxPoint(-41,49),
		wxPoint(-42,48),
		wxPoint(-43,47),
		wxPoint(-44,46),
		wxPoint(-45,45),
		wxPoint(-46,44),
		wxPoint(-47,42),
		wxPoint(-48,41),
		wxPoint(-49,40),
		wxPoint(-50,39),
		wxPoint(-51,38),
		wxPoint(-52,36),
		wxPoint(-53,35),
		wxPoint(-54,34),
		wxPoint(-55,32),
		wxPoint(-56,31),
		wxPoint(-56,30),
		wxPoint(-57,28),
		wxPoint(-58,27),
		wxPoint(-58,25),
		wxPoint(-59,24),
		wxPoint(-59,23),
		wxPoint(-60,21),
		wxPoint(-61,20),
		wxPoint(-61,18),
		wxPoint(-61,17),
		wxPoint(-62,15),
		wxPoint(-62,14),
		wxPoint(-63,12),
		wxPoint(-63,11),
		wxPoint(-63,9),
		wxPoint(-63,8),
		wxPoint(-63,6),
		wxPoint(-64,4),
		wxPoint(-64,3),
		wxPoint(-64,1),
		wxPoint(-64,0),
		wxPoint(-64,-2),
		wxPoint(-64,-3),
		wxPoint(-64,-5),
		wxPoint(-63,-6),
		wxPoint(-63,-8),
		wxPoint(-63,-10),
		wxPoint(-63,-11),
		wxPoint(-63,-13),
		wxPoint(-62,-14),
		wxPoint(-62,-16),
		wxPoint(-61,-17),
		wxPoint(-61,-19),
		wxPoint(-61,-20),
		wxPoint(-60,-22),
		wxPoint(-59,-23),
		wxPoint(-59,-25),
		wxPoint(-58,-26),
		wxPoint(-58,-27),
		wxPoint(-57,-29),
		wxPoint(-56,-30),
		wxPoint(-56,-32),
		wxPoint(-55,-33),
		wxPoint(-54,-34),
		wxPoint(-53,-36),
		wxPoint(-52,-37),
		wxPoint(-51,-38),
		wxPoint(-50,-39),
		wxPoint(-49,-41),
		wxPoint(-48,-42),
		wxPoint(-47,-43),
		wxPoint(-46,-44),
		wxPoint(-45,-45),
		wxPoint(-44,-46),
		wxPoint(-43,-47),
		wxPoint(-42,-48),
		wxPoint(-41,-49),
		wxPoint(-39,-50),
		wxPoint(-38,-51),
		wxPoint(-37,-52),
		wxPoint(-36,-53),
		wxPoint(-34,-54),
		wxPoint(-33,-55),
		wxPoint(-32,-56),
		wxPoint(-30,-56),
		wxPoint(-29,-57),
		wxPoint(-27,-58),
		wxPoint(-26,-58),
		wxPoint(-25,-59),
		wxPoint(-23,-59),
		wxPoint(-22,-60),
		wxPoint(-20,-61),
		wxPoint(-19,-61),
		wxPoint(-17,-61),
		wxPoint(-16,-62),
		wxPoint(-14,-62),
		wxPoint(-13,-63),
		wxPoint(-11,-63),
		wxPoint(-10,-63),
		wxPoint(-8,-63),
		wxPoint(-6,-63),
		wxPoint(-5,-64),
		wxPoint(-3,-64),
		wxPoint(-2,-64),
		wxPoint(0,-64),
		wxPoint(1,-64),
		wxPoint(3,-64),
		wxPoint(4,-64),
		wxPoint(6,-63),
		wxPoint(8,-63),
		wxPoint(9,-63),
		wxPoint(11,-63),
		wxPoint(12,-63),
		wxPoint(14,-62),
		wxPoint(15,-62),
		wxPoint(17,-61),
		wxPoint(18,-61),
		wxPoint(20,-61),
		wxPoint(21,-60),
		wxPoint(23,-59),
		wxPoint(24,-59),
		wxPoint(25,-58),
		wxPoint(27,-58),
		wxPoint(28,-57),
		wxPoint(30,-56),
		wxPoint(31,-56),
		wxPoint(32,-55),
		wxPoint(34,-54),
		wxPoint(35,-53),
		wxPoint(36,-52),
		wxPoint(38,-51),
		wxPoint(39,-50),
		wxPoint(40,-49),
		wxPoint(41,-48),
		wxPoint(42,-47),
		wxPoint(44,-46),
		wxPoint(45,-45),
		wxPoint(46,-44),
		wxPoint(47,-43),
		wxPoint(48,-42),
		wxPoint(49,-41),
		wxPoint(50,-39),
		wxPoint(51,-38),
		wxPoint(52,-37),
		wxPoint(53,-36),
		wxPoint(53,-34),
		wxPoint(54,-33),
		wxPoint(55,-32),
		wxPoint(56,-30),
		wxPoint(56,-29),
		wxPoint(57,-27),
		wxPoint(58,-26),
		wxPoint(58,-25),
		wxPoint(59,-23),
		wxPoint(60,-22),
		wxPoint(60,-20),
		wxPoint(61,-19),
		wxPoint(61,-17),
		wxPoint(61,-16),
		wxPoint(62,-14),
		wxPoint(62,-13),
		wxPoint(62,-11),
		wxPoint(63,-10),
		wxPoint(63,-8),
		wxPoint(63,-6),
		wxPoint(63,-5),
		wxPoint(63,-3),
		wxPoint(63,-2)};
		
		
		
Angle Tools::visibleToIntern[] = {-3,
3,
0,
0,
4,
7,
0,
0,
8,
11,
0,
0,
12,
15,
0,
0,
16,
19,
0,
0,
20,
23,
0,
0,
24,
27,
0,
0,
28,
31,
0,
0,
32,
35,
0,
0,
36,
39,
0,
0,
40,
43,
0,
0,
44,
47,
0,
0,
48,
51,
0,
0,
52,
55,
0,
0,
56,
59,
0,
0,
60,
63,
0,
0,
64,
64,
0,
0,
65,
68,
0,
0,
69,
72,
0,
0,
73,
76,
0,
0,
77,
80,
0,
0,
81,
84,
0,
0,
85,
88,
0,
0,
89,
92,
0,
0,
93,
96,
0,
0,
97,
100,
0,
0,
101,
104,
0,
0,
105,
108,
0,
0,
109,
112,
0,
0,
113,
116,
0,
0,
117,
120,
0,
0,
121,
124,
0,
0,
125,
-125,
0,
0,
-124,
-121,
0,
0,
-120,
-117,
0,
0,
-116,
-113,
0,
0,
-112,
-109,
0,
0,
-108,
-105,
0,
0,
-104,
-101,
0,
0,
-100,
-97,
0,
0,
-96,
-93,
0,
0,
-92,
-89,
0,
0,
-88,
-85,
0,
0,
-84,
-81,
0,
0,
-80,
-77,
0,
0,
-76,
-73,
0,
0,
-72,
-69,
0,
0,
-68,
-65,
0,
0,
-64,
-64,
0,
0,
-63,
-60,
0,
0,
-59,
-56,
0,
0,
-55,
-52,
0,
0,
-51,
-48,
0,
0,
-47,
-44,
0,
0,
-43,
-40,
0,
0,
-39,
-36,
0,
0,
-35,
-32,
0,
0,
-31,
-28,
0,
0,
-27,
-24,
0,
0,
-23,
-20,
0,
0,
-19,
-16,
0,
0,
-15,
-12,
0,
0,
-11,
-8,
0,
0,
-7,
-4};

wxPoint Tools::shotStartPoints[] = {
wxPoint(152,0),
wxPoint(152,0),
wxPoint(152,0),
wxPoint(152,8),
wxPoint(152,8),
wxPoint(152,16),
wxPoint(152,16),
wxPoint(152,24),
wxPoint(152,24),
wxPoint(152,32),
wxPoint(152,32),
wxPoint(152,40),
wxPoint(152,40),
wxPoint(144,48),
wxPoint(144,48),
wxPoint(144,56),
wxPoint(144,56),
wxPoint(144,56),
wxPoint(136,64),
wxPoint(136,64),
wxPoint(136,72),
wxPoint(136,72),
wxPoint(128,80),
wxPoint(128,80),
wxPoint(128,80),
wxPoint(128,88),
wxPoint(120,88),
wxPoint(120,96),
wxPoint(120,96),
wxPoint(120,96),
wxPoint(112,104),
wxPoint(112,104),
wxPoint(112,112),
wxPoint(104,112),
wxPoint(104,112),
wxPoint(96,120),
wxPoint(96,120),
wxPoint(96,120),
wxPoint(88,120),
wxPoint(88,128),
wxPoint(80,128),
wxPoint(80,128),
wxPoint(80,128),
wxPoint(72,136),
wxPoint(72,136),
wxPoint(64,136),
wxPoint(64,136),
wxPoint(56,144),
wxPoint(56,144),
wxPoint(56,144),
wxPoint(48,144),
wxPoint(48,144),
wxPoint(40,152),
wxPoint(40,152),
wxPoint(32,152),
wxPoint(32,152),
wxPoint(24,152),
wxPoint(24,152),
wxPoint(16,152),
wxPoint(16,152),
wxPoint(8,152),
wxPoint(8,152),
wxPoint(0,152),
wxPoint(0,152),
wxPoint(0,152),
wxPoint(-8,152),
wxPoint(-8,152),
wxPoint(-16,152),
wxPoint(-16,152),
wxPoint(-24,152),
wxPoint(-32,152),
wxPoint(-32,152),
wxPoint(-40,152),
wxPoint(-40,152),
wxPoint(-40,152),
wxPoint(-48,152),
wxPoint(-48,152),
wxPoint(-56,144),
wxPoint(-56,144),
wxPoint(-64,144),
wxPoint(-64,144),
wxPoint(-72,144),
wxPoint(-72,136),
wxPoint(-80,136),
wxPoint(-80,136),
wxPoint(-80,136),
wxPoint(-88,128),
wxPoint(-88,128),
wxPoint(-96,128),
wxPoint(-96,128),
wxPoint(-96,120),
wxPoint(-104,120),
wxPoint(-104,120),
wxPoint(-112,120),
wxPoint(-112,112),
wxPoint(-112,112),
wxPoint(-120,112),
wxPoint(-120,104),
wxPoint(-120,104),
wxPoint(-120,96),
wxPoint(-128,96),
wxPoint(-128,96),
wxPoint(-128,88),
wxPoint(-136,88),
wxPoint(-136,80),
wxPoint(-136,80),
wxPoint(-144,80),
wxPoint(-144,72),
wxPoint(-144,72),
wxPoint(-144,64),
wxPoint(-152,64),
wxPoint(-152,56),
wxPoint(-152,56),
wxPoint(-152,56),
wxPoint(-152,48),
wxPoint(-160,48),
wxPoint(-160,40),
wxPoint(-160,40),
wxPoint(-160,32),
wxPoint(-160,32),
wxPoint(-160,24),
wxPoint(-160,24),
wxPoint(-160,16),
wxPoint(-160,16),
wxPoint(-160,8),
wxPoint(-160,8),
wxPoint(-160,0),
wxPoint(-160,0),
wxPoint(-160,0),
wxPoint(-160,-8),
wxPoint(-160,-8),
wxPoint(-160,-16),
wxPoint(-160,-16),
wxPoint(-160,-24),
wxPoint(-160,-32),
wxPoint(-160,-32),
wxPoint(-160,-40),
wxPoint(-160,-40),
wxPoint(-160,-40),
wxPoint(-160,-48),
wxPoint(-160,-48),
wxPoint(-160,-56),
wxPoint(-152,-56),
wxPoint(-152,-64),
wxPoint(-152,-64),
wxPoint(-152,-72),
wxPoint(-152,-72),
wxPoint(-144,-80),
wxPoint(-144,-80),
wxPoint(-144,-80),
wxPoint(-144,-88),
wxPoint(-136,-88),
wxPoint(-136,-96),
wxPoint(-136,-96),
wxPoint(-128,-96),
wxPoint(-128,-104),
wxPoint(-128,-104),
wxPoint(-120,-112),
wxPoint(-120,-112),
wxPoint(-120,-112),
wxPoint(-120,-120),
wxPoint(-112,-120),
wxPoint(-112,-120),
wxPoint(-112,-120),
wxPoint(-104,-128),
wxPoint(-104,-128),
wxPoint(-96,-128),
wxPoint(-96,-136),
wxPoint(-96,-136),
wxPoint(-88,-136),
wxPoint(-88,-144),
wxPoint(-80,-144),
wxPoint(-80,-144),
wxPoint(-80,-144),
wxPoint(-72,-152),
wxPoint(-72,-152),
wxPoint(-64,-152),
wxPoint(-64,-152),
wxPoint(-56,-152),
wxPoint(-56,-160),
wxPoint(-48,-160),
wxPoint(-48,-160),
wxPoint(-40,-160),
wxPoint(-40,-160),
wxPoint(-40,-160),
wxPoint(-32,-160),
wxPoint(-32,-160),
wxPoint(-24,-160),
wxPoint(-16,-160),
wxPoint(-16,-160),
wxPoint(-8,-160),
wxPoint(-8,-160),
wxPoint(0,-160),
wxPoint(0,-160),
wxPoint(0,-160),
wxPoint(8,-160),
wxPoint(8,-160),
wxPoint(16,-160),
wxPoint(16,-160),
wxPoint(24,-160),
wxPoint(24,-160),
wxPoint(32,-160),
wxPoint(32,-160),
wxPoint(40,-160),
wxPoint(40,-160),
wxPoint(48,-160),
wxPoint(48,-152),
wxPoint(56,-152),
wxPoint(56,-152),
wxPoint(56,-152),
wxPoint(64,-152),
wxPoint(64,-144),
wxPoint(72,-144),
wxPoint(72,-144),
wxPoint(80,-144),
wxPoint(80,-136),
wxPoint(80,-136),
wxPoint(88,-136),
wxPoint(88,-128),
wxPoint(96,-128),
wxPoint(96,-128),
wxPoint(96,-120),
wxPoint(104,-120),
wxPoint(104,-120),
wxPoint(112,-120),
wxPoint(112,-112),
wxPoint(112,-112),
wxPoint(120,-112),
wxPoint(120,-104),
wxPoint(120,-104),
wxPoint(120,-96),
wxPoint(128,-96),
wxPoint(128,-96),
wxPoint(128,-88),
wxPoint(128,-88),
wxPoint(136,-80),
wxPoint(136,-80),
wxPoint(136,-80),
wxPoint(136,-72),
wxPoint(144,-72),
wxPoint(144,-64),
wxPoint(144,-64),
wxPoint(144,-56),
wxPoint(144,-56),
wxPoint(152,-48),
wxPoint(152,-48),
wxPoint(152,-40),
wxPoint(152,-40),
wxPoint(152,-40),
wxPoint(152,-32),
wxPoint(152,-32),
wxPoint(152,-24),
wxPoint(152,-16),
wxPoint(152,-16),
wxPoint(152,-8),
wxPoint(152,-8)};

