#ifndef SHIP_H_
#define SHIP_H_

#include "Const.h"
#include "FlyingObject.h"

class Ship:public FlyingObject
{
private:
	 ShipState state;
	 Angle minAngle;
	 Angle maxAngle;
	 Angle estimatedAngle;
	 int numShots;
	 int nextShot;

public:
	Ship(int objectID,
		ShipState state,
		wxPoint absolutePosition,
	     Angle   absoluteAngle,
	     wxPoint relativePosition,
	     Angle   relativeAngle,
	     int velocity,
	     wxPoint flightVector,
	     wxPoint RelativeFlightVector,
	     Angle minAngle,
	     Angle maxAngle,
	     Angle estimatedAngle,
	     int distance = 0,
	     int framesToCollision = -1,
	     int lifeTime = 1
	     );
	     
	Ship():state(noShip)
	{
	}
	unsigned int getSize() const;
	
	ShipState getShipState()
	{
		return state;
	}
	
	Angle getAngle()
	{
		return estimatedAngle;
	}
	
	void setAngle(Angle angle)
	{
		estimatedAngle = angle;
	}
	
	bool isExactAngle()
	{
		return minAngle == maxAngle;
	}
	
	Angle getMinAngle()
	{
		return minAngle;
	}
	
	Angle getMaxAngle()
	{
		return maxAngle;
	}
	
	int getNumShots()
	{
		return numShots;
	}
	
	void setNumShots(int numShots)
	{
		this->numShots = numShots;
	}
	
	void setNextShot(int nextShot)
	{
		this->nextShot = nextShot;
	}
	
	int getNextShot()
	{
		return nextShot;
	}
};		


#endif /*SHIP_H_*/
