#ifndef PLAYER_H_
#define PLAYER_H_

#include "Repository.h"
#include "defines.h"

class Player
{
protected:
	char checkCollisions(Universe* universe);
	char checkTargets(Universe* universe, Angle angle,double precision);
	char turnTo(Universe* universe, Angle angle, bool exact);
public:
	virtual ~Player() { }
	#ifdef _BOT_SINGLETHREADED_
	virtual char decideMove(Universe* universe) = 0;
	#else
	virtual void playGame(Repository* repo) = 0;
	#endif
};

#endif /*PLAYER_H_*/
