#include "Player.h"
#include "Tools.h"

#include <iostream>

char Player::checkCollisions(Universe* universe)
{
	list<Asteroid>* asteroids = universe->getAsteroids();
	Ufo ufo = universe->getUfo();
	list<Shot>* shots = universe->getShots();
	
	for(list<Asteroid>::iterator iteratorAsteroids = asteroids->begin(); iteratorAsteroids != asteroids->end();iteratorAsteroids++)
	{
		if(iteratorAsteroids->getFramesToCollision() > 0 && iteratorAsteroids->getFramesToCollision() <= 2 && universe->canHyperspace())
		{
			return Key::HYPERSPACE;
		}
	}
	
	for(list<Shot>::iterator iteratorShots = shots->begin(); iteratorShots != shots->end();iteratorShots++)
	{
		if(iteratorShots->getFramesToCollision() > 0 && iteratorShots->getFramesToCollision() <= 2 && universe->canHyperspace())
		{
			return Key::HYPERSPACE;
		}
	}
	
	if(ufo.getFramesToCollision() > 0 && ufo.getFramesToCollision() <= 2 && universe->canHyperspace())
		return Key::HYPERSPACE;
	return Key::NONE;
}

char Player::turnTo(Universe* universe, Angle angle, bool exact)
{
	int phase = ((unsigned char)universe->getShip().getAngle()) %3;
	int phaseTo = ((unsigned char)angle) %3;
	
	if((exact && universe->getShip().getAngle() == angle) || (!exact && abs(angle-universe->getShip().getAngle()) < 2))
		return Key::NONE;
		
	if(exact && phase != phaseTo)
	{
		if(phase == 0)
		{
			if(phaseTo == 2)
				return Key::LEFT;
			else if(phaseTo == 1)
				return Key::RIGHT;
		}
		else if(phase == 2)
		{
			if(phaseTo ==1)
				return Key::LEFT;
			else if(phaseTo == 0)
				return Key::RIGHT;
		}
		else if( phase == 1)
		{
			if(phaseTo ==0)
				return Key::LEFT;
			else if(phaseTo == 2)
				return Key::RIGHT;
		}
	}
	else
	{
		if((char)(angle - universe->getShip().getAngle()) >= 0)
			return Key::LEFT;
		else
			return Key::RIGHT;
	}
	return Key::NONE;
}

char Player::checkTargets(Universe* universe, Angle angle,double precision)
{
	
	if(!universe->canShoot())
		return Key::NONE;
	
	for(list<Asteroid>::iterator iteratorAsteroids = universe->getAsteroids()->begin(); iteratorAsteroids != universe->getAsteroids()->end();iteratorAsteroids++)
	{
		if((iteratorAsteroids->getAsteroidSize() == AsteroidSize::small && iteratorAsteroids->getHits() == 0) || (iteratorAsteroids->getAsteroidSize() == AsteroidSize::medium && iteratorAsteroids->getHits() < 3) || (iteratorAsteroids->getAsteroidSize() == AsteroidSize::big && iteratorAsteroids->getHits() < 7))
		{
			if(Tools::calcCollision(universe->getShip().getAbsolutePosition()+Tools::getShotStartPoint(angle),Tools::internToShot(angle),1,iteratorAsteroids->getAbsolutePosition(),iteratorAsteroids->getFlightVector(),iteratorAsteroids->getAsteroidSize().getValue(),68,precision) != -1)
			{
			//wxLogDebug(_("FrameID: %d angle: %d min: %d max: %d"),universe->getFrameID(),angle,universe->getShip().getMinAngle(),universe->getShip().getMinAngle());
				return Key::SHOOT;	
			}
		}
	}
	
	if(universe->getUfo().isUsed())
	{
		//if(universe->getUfo().getHits())
		//	wxLogDebug("Ufo Hits %d",universe->getUfo().getHits());
		if(Tools::calcCollision(universe->getShip().getAbsolutePosition()+Tools::getShotStartPoint(angle),Tools::internToShot(angle),1,universe->getUfo().getAbsolutePosition(),universe->getUfo().getFlightVector(),universe->getUfo().getUfoSize().getValue(),68,precision) != -1)
		{
			//wxLogDebug(_("FrameID: %d angle: %d"),universe->getFrameID(),angle);
			return Key::SHOOT;
		}
	}
	return Key::NONE;
}

