#ifndef MOVINGTRACKINGOBJECT_H_
#define MOVINGTRACKINGOBJECT_H_

#include "TrackingObject.h"
#include <wx/log.h>

template<class T>
class MovingTrackingObject: public TrackingObject<T>
{
public:
	MovingTrackingObject(T snapshot,int objectID):TrackingObject<T>(snapshot,objectID)
	{
	}
	
	MovingTrackingObject(const MovingTrackingObject& ref): TrackingObject<T>(ref)
	{
	}
	
	MovingTrackingObject()
	{
	}
	
	void updateFlightVector();
};


template<class T>
void MovingTrackingObject<T>::updateFlightVector()
{
	typename list<T>::iterator iteratorHistory = this->history.begin();
	iteratorHistory++;
	
	if(this->history.size() > 1)
	{
		wxPoint diff = this->history.begin()->getPos() - iteratorHistory->getPos();
		
		//wxLogDebug("start (%d,%d) end (%d,%d) DIFF (%d,%d)",iteratorHistory->getPos().x,iteratorHistory->getPos().y,this->history.begin()->getPos().x,this->history.begin()->getPos().y,diff.x,diff.y);
		
		if(diff.x > 0)
			this->flightVector.x = 16;
		else if(diff.x < 0)
			this->flightVector.x = -16;
		else
			this->flightVector.x = 0;
		
		if(diff.y > 0)
			this->flightVector.y = 16;
		else if(diff.y < 0)
			this->flightVector.y = -16;
		else
			this->flightVector.y = 0;
	}
	/*
	
	for(int i = 0; i < 8 && iteratorHistory != this->history.end();i++)
	{
		iteratorHistory++;
	}
	
	if(iteratorHistory == this->history.end())
		iteratorHistory--;
	
	if(iteratorHistory == this->history.begin())
		return;
	
	this->flightVector = this->history.begin()->getPos() - iteratorHistory->getPos();
	
	this->flightVector.x /= Tools::getFrameDiff(iteratorHistory->getFrameID(),this->history.begin()->getFrameID());
	this->flightVector.y /= Tools::getFrameDiff(iteratorHistory->getFrameID(), this->history.begin()->getFrameID());
	*/
}


template<class T>
class ShipTrackingObject: public TrackingObject<T>
{
public:
	ShipTrackingObject(T snapshot,int objectID):TrackingObject<T>(snapshot,objectID)
	{
	}
	
	ShipTrackingObject(const ShipTrackingObject& ref): TrackingObject<T>(ref)
	{
	}
	
	ShipTrackingObject()
	{
	}
	
	void updateFlightVector();
};


template<class T>
void ShipTrackingObject<T>::updateFlightVector()
{
	typename list<T>::iterator iteratorHistory = this->history.begin();
	
	
	for(int i = 0; i < 8 && iteratorHistory != this->history.end();i++)
	{
		iteratorHistory++;
	}
	
	if(iteratorHistory == this->history.end())
		iteratorHistory--;
	
	if(iteratorHistory == this->history.begin())
		return;
	
	this->flightVector = this->history.begin()->getPos() - iteratorHistory->getPos();
	
	//wxLogDebug("start (%d,%d) end (%d,%d) DIFF (%d,%d)",iteratorHistory->getPos().x,iteratorHistory->getPos().y,this->history.begin()->getPos().x,this->history.begin()->getPos().y,this->flightVector.x,this->flightVector.y);
	
	this->flightVector.x /= Tools::getFrameDiff(iteratorHistory->getFrameID(),this->history.begin()->getFrameID());
	this->flightVector.y /= Tools::getFrameDiff(iteratorHistory->getFrameID(), this->history.begin()->getFrameID());
}

#endif /*MOVINGTRACKINGOBJECT_H_*/
