#include "IOLayer.h"
#include "Snapshot.h"
#include "Frame.h"
#include "Tools.h"
#include "rdtsc.h"
#include "defines.h"
#include <iostream>
using namespace std;

const char* SocketException::what() const throw()
{
	return this->message.c_str();
};

void IOLayer::initializeIO(const char* server)
{
	if(!server)
	{
		throw SocketException("No IP specified");
	}
	ip = inet_addr(server);
	if(ip == INADDR_NONE)
	{
		throw SocketException("No valid IP-String");
	}
	#ifdef WINDOWS
	
	WSADATA data;
	
	if(WSAStartup(MAKEWORD(2,2),&data))
	{		
		throw SocketException("Could not initialize WINSOCK");
	}
	#endif
	recSocket = socket(AF_INET,SOCK_DGRAM,0);
	
	if(recSocket == INVALID_SOCKET)
	{
		
	#ifdef WINDOWS
		WSACleanup();
	#endif
		throw SocketException("Could not get a socket descriptor");
	}
	
	#ifdef WINDOWS
	unsigned long nonBlocking = 1;
	
	if(ioctlsocket(recSocket,FIONBIO,&nonBlocking))
	{		
		throw SocketException("Could not make socket non-blocking");
	}
	#else
	
	if(fcntl(recSocket, F_SETFL, O_NONBLOCK) ==-1)
	{		
		throw SocketException("Could not make socket non-blocking");
	}
	#endif

	sockaddr_in saddr;
	memset(&saddr,0,sizeof(sockaddr_in));
	saddr.sin_family = AF_INET;		// IPv4
	saddr.sin_addr.s_addr = 0;		// INADDR_ANY
	saddr.sin_port = 0;
	
	if(bind(recSocket,(sockaddr*)&saddr,sizeof(sockaddr_in)))
	{
		throw SocketException("Could not bind socket");
	}
	FD_ZERO(&exceptfds);
	FD_ZERO(&readfds);
	FD_SET(recSocket,&exceptfds);
	FD_SET(recSocket,&readfds);
	
	sendAddr.sin_family = AF_INET;
	sendAddr.sin_port = htons(1979);
	sendAddr.sin_addr.s_addr = ip;
	
	buffer[0] = 'c';
	buffer[1] = 't';
	buffer[2] = 'm';
	buffer[3] = 'a';
	buffer[4] = 'm';
	buffer[5] = 'e';
}

void IOLayer::sendData()
{
	buffer[6] = repository->popKeys();
	
	Action action = {currentFrameID,buffer[6]};
	
	buffer[7] = repository->setAction(action);
	
	if(sendto(recSocket,buffer,sizeof(buffer),0,(sockaddr*)&sendAddr,sizeof(sendAddr)) != sizeof(buffer))
		IOLog("sendto failed");
	
	#ifdef _MEASURE_TIME_
	endFrame = getMicroSeconds();
	wxLogDebug("EndFrame %lld ==> time %lld",endFrame,endFrame-startFrame);
	#endif
}

#ifdef _BOT_SINGLETHREADED_
bool IOLayer::receiveData()
#else
void IOLayer::receiveData()
#endif
{ 
	#ifdef _MEASURE_TIME_
	time_tsc start, end;
	#endif
	//select(recSocket+1,&readfds,NULL,&exceptfds,NULL);
	#ifdef _MEASURE_TIME_	
	startFrame = start = getMicroSeconds();
	//wxLogDebug("IOLayer::receiveData start %lld",start);
	wxLogDebug("Startframe %lld",startFrame);
	#endif
	FD_ZERO(&readfds);
	FD_SET(recSocket,&readfds);
	
	timeval test;
	test.tv_sec = 0;
	test.tv_usec = 50000;
	if(select(recSocket+1,&readfds,NULL,&exceptfds,&test) <= 0)
	{
		sleep(8);
		buffer[6] = 1;
		buffer[7] = 0;
		sendto(recSocket,buffer,sizeof(buffer),0,(sockaddr*)&sendAddr,sizeof(sendAddr));
		sleep(0.05);
		buffer[6] = 0;
		buffer[7] = 0;
		sendto(recSocket,buffer,sizeof(buffer),0,(sockaddr*)&sendAddr,sizeof(sendAddr));
	}
	if(sizeof(Frame::frameBuffer) == recv(recSocket,Frame::frameBuffer,sizeof(Frame::frameBuffer),0))
	{
		analyzeFrame(Frame::frameBuffer);
		#ifdef _BOT_SINGLETHREADED_
		return true;
		#endif
	}
	#ifdef _BOT_SINGLETHREADED_
	else
		return false;
	#endif
	
	#ifdef _MEASURE_TIME_
	end = getMicroSeconds();
	wxLogDebug("IOLayer::receiveData end %lld ==> time %lld",end,end-start);
	#endif
}

IOLayer::~IOLayer()
{
	#ifdef WINDOWS
	closesocket(recSocket);
	WSACleanup();
	#endif
}

void IOLayer::analyzeFrame(char* buf)
{
	currentFrameID = buf[1024]&0xff;
	Frame frame(buf);
	Snapshot* snapshot = new Snapshot(frame.getFrameID());
	frame >> *snapshot;
	repository->setSnapshot(snapshot);
}

IOLayer::IOLayer(const char* server, Repository* repository):
	repository(repository),
	recSocket(0)
{
	initializeIO(server);
}

