#ifndef FLYINGOBJECTTYPE_H_
#define FLYINGOBJECTTYPE_H_

class FlyingObjectType
{
private:
	unsigned int type;
	const char* name;
	
	FlyingObjectType(unsigned int type, const char * name):
		type(type),
		name(name)
	{ }
public:
	
	bool operator==(const FlyingObjectType& ref) const
	{
		return ref.type == type;
	}
	
	bool operator!=(const FlyingObjectType & ref) const
	{
		return ref.type != type;
	}
	
	const char* toString() const
	{
		return name;
	}
	
	static const FlyingObjectType explosion;
	static const FlyingObjectType ship;
	static const FlyingObjectType ufo;
	static const FlyingObjectType shot;
	static const FlyingObjectType asteroid; 
	static const FlyingObjectType flyingObject;
};

#endif /*FLYINGOBJECTTYPE_H_*/
