#ifndef ASTEROID_H_
#define ASTEROID_H_

#include "FlyingObject.h"
#include "AsteroidSize.h"

class Asteroid: public FlyingObject
{
private:
	AsteroidSize size;
	int hits;
public:
	Asteroid(int objectID,
			wxPoint absolutePosition,
	         Angle   absoluteAngle,
	         wxPoint relativePosition,
	         Angle   relativeAngle,
	         int velocity,
	         wxPoint flightVector,
	         wxPoint relativeFlightVector,
	         int distance,
	         int framesToCollision,
	         int lifeTime,
	         AsteroidSize size);
	         
	Asteroid():FlyingObject(),size(AsteroidSize::small)
	{
	}
	unsigned int getSize() const;
	
	AsteroidSize getAsteroidSize() const
	{
		return size;
	}
	
	AsteroidSize setAsteroidSize(AsteroidSize size)
	{
		return this->size = size;
	}
	
	void addHit()
	{
		hits++;
	}
	
	int getHits()
	{
		return hits;
	}
};

#endif /*ASTEROID_H_*/
