#ifndef ARRAYLIST_H_
#define ARRAYLIST_H_

template<class T>
class ArrayList
{
private:
	T* array;
	unsigned int length;
	unsigned int capacity;
	float resizeFactor;

public:
	ArrayList(unsigned int capacity=10, float resizeFactor=1.6):capacity(capacity),resizeFactor(resizeFactor)
	{
		array = new T[capacity];
		length = 0;
	}
	
	~ArrayList()
	{
		if(array)
		{
			delete [] array;
		}
	}
	
	T& addElement(T& element);
	T& addElement(T* element);
	void addRange(T* elements, int length);
	bool removeElement(T& element);
	bool removeElementAt(int index);
	
	T& operator[](int i);
		
};

template<class T>
T& ArrayList<T>::addElement(T& element)
{
	if(!(length < capacity))
	{
		capacity = (unsigned int) capacity*resizeFactor;
		T* newArray = new T[capacity];
	
		for(unsigned int i = 0; i< length;i++)
			newArray[i] = array[i];
		
		delete [] array;
	
		array = newArray;
		
	}
		
	array[length++] = element;
	return array[length-1];
}

template<class T>
T& ArrayList<T>::addElement(T* element)
{
	if(!(length < capacity))
	{
		capacity = (unsigned int) capacity*resizeFactor;
		T* newArray = new T[capacity];
	
		for(unsigned int i = 0; i< length;i++)
			newArray[i] = array[i];
		
		delete [] array;
	
		array = newArray;
		
	}
		
	array[length++] = *element;
	return array[length-1];
}

template<class T>
void ArrayList<T>::addRange(T* elements,int length)
{
	while(length >= capacity)
	{
		capacity = (unsigned int) capacity*resizeFactor;
		T* newArray = new T[capacity];
	
		for(unsigned int i = 0; i< length;i++)
			newArray[i] = array[i];
		
		delete [] array;
	
		array = newArray;
	}
	
	memcpy((char*)(array+length),(char*)elements,sizeof(T)*length);
}

template<class T>
bool ArrayList<T>::removeElement(T& element)
{
	for(int i = 0; i<length;i++)
	{
		if(element == array[i])
		{
			for(int j = i;j<length-1;j++)
			{
				array[j] = array[j+1];
			}
			return true;
			length--;
		}
	}
	return false;
}

template<class T>
bool ArrayList<T>::removeElementAt(int index)
{
	if(index >= 0 && index < length)
	{
		for(int i = index; i< length-1;i++)
			array[i] = array[i+1];
		length--;
		return true;
	}
	return false;
}

template<class T>
T& ArrayList<T>::operator[](int i)
{
	if(i<0 || i>= length)
		return 0;
		
	return array[i];
}


#endif /*ARRAYLIST_H_*/
