#ifndef ACTIONSNAPSHOT_H_
#define ACTIONSNAPSHOT_H_

#include "Asteroid.h"
#include "Ship.h"
#include "ShotAction.h"
#include <wx/log.h>

class ActionSnapshot
{
private:
	Ship ship;
	
	Asteroid asteroids[27];
	ShotAction shotActions[27];
	int numAsteroids;
	
	int frames;
	int gain;
	
	int leftBestTarget;
	int rightBestTarget;
	
	ActionSnapshot*left;
	ActionSnapshot*right;
	
	ActionSnapshot *prev;
	
	int getCosts(int index)
	{
		return shotActions[index].turnSteps + frames + shotActions[index].waitFrames+shotActions[index].shotFrames;
	}

public:
	ActionSnapshot(Ship& ship);
	
	ActionSnapshot(ActionSnapshot& snapshot);
	
	void addAsteroid(const Asteroid& asteroid)
	{
		asteroids[numAsteroids++] = asteroid;
	}
	
	void calcShotActions();
	
	
	
	ActionSnapshot* getLeft()
	{
		return left;
	}
	
	ActionSnapshot* getRight()
	{
		return right;
	}
	
	ActionSnapshot* getPrev()
	{
		return prev;
	}
	
	void setLeft(ActionSnapshot* left)
	{
		this->left = left;
	}
	
	void setRight(ActionSnapshot* right)
	{
		this->right = right;
	}
	
	int getRightFrames()
	{
		if(rightBestTarget == -1 || right != 0)
			return 0x0fffffff;
		return getCosts(rightBestTarget);
	}
	
	int getLeftFrames()
	{
		if(leftBestTarget == -1 || left != 0)
			return 0x0fffffff;
		return getCosts(leftBestTarget);
	}
	
	int getMinFrames()
	{
		if((rightBestTarget == -1 || right != 0) && (leftBestTarget == -1 || left != 0))
			return 0x0fffffff;
		else if(leftBestTarget==-1)
			return getCosts(rightBestTarget);
		else if(rightBestTarget == -1)
			return getCosts(leftBestTarget);
		else
		{
			if(getCosts(leftBestTarget) < getCosts(rightBestTarget))
				return getCosts(leftBestTarget);
			else
				return getCosts(rightBestTarget);
		}	
	}
	
	void setMin(ActionSnapshot *snapshot)
	{
		if(rightBestTarget == -1 || right != 0)
		{
			//wxLogDebug("setLeft %x left %x node %x",this,left,snapshot);
			left = snapshot;
		}
		else if(leftBestTarget == -1 || left != 0)
		{
			//wxLogDebug("setRight %x right %x node %x",this,right,snapshot);
			right = snapshot;
		}
		else
		{
			if(getCosts(leftBestTarget)< getCosts(rightBestTarget))
			{
				//wxLogDebug("setLeft %x left %x node %x",this,left,snapshot);
				left = snapshot;
			}
			else
			{
				//wxLogDebug("setRight %x right %x node %x",this,right,snapshot);
				right = snapshot;
			}
		}
	}
	
	int getGain()
	{
		return gain;
	}
	
	ShotAction getBestAction(ActionSnapshot* snapshot)
	{
		if(snapshot == right)
			return shotActions[rightBestTarget];
		else
			return shotActions[leftBestTarget];
	}
};

#endif /*ACTIONSNAPSHOT_H_*/
