#ifndef AICORE_H
#define AICORE_H

#include "aitest.h"



class FrameData;
class MainWindow;
class MameScene;
class Job;

class AICore:public QApplication
{
	Q_OBJECT

	public:
		AICore(int &argc, char **argv );
		~AICore();

		QString getAddress();

		void clearActions();
		void actionHyperspace(bool b);
		void actionFire(bool b);
		void actionThrust(bool b);
		void actionRight(bool b);
		void actionLeft(bool b);
		
		QByteArray& getActionPacket();

		QPair<int, double> getShootAngle(int step);
		QList<unsigned char> getIndizes(int angle);
		

		void swapFrames();		
		FrameData* getCurrent();
		FrameData* getLast();
		
		void setJob(Job *j);
		Job* getJob();

		void setMainWindow(MainWindow *mW);
		MainWindow* getMainWindow();
		
		void setMameScene(MameScene *mS);
		MameScene* getMameScene();

		static const char ACTION_HYPERSPACE = 1;
		static const char ACTION_FIRE = 2;
		static const char ACTION_THRUST = 4;
		static const char ACTION_RIGHT = 8;
		static const char ACTION_LEFT = 0x10;
	private:
		FrameData *currentFrame;
		FrameData *lastFrame;
		MainWindow *mainWindow;
		MameScene *mameScene;

		QMap<unsigned char, QPair<int, double> > indexLookup;
		QMap<int, unsigned char> angleLookup;

		QByteArray actionPacket;

		QString address;

		Job *job;

		

};

class Radius
{
	public:
		Radius();
		~Radius();
		double SmallMin;
		double SmallMax;
		double MediumMin;
		double MediumMax;
		double BigMin;
		double BigMax;
};

class SpeedDef
{
	public:
		SpeedDef();
		~SpeedDef();
		double anVspeed;
		double enVspeed;
		double anRadSpeed;
		double enRadSpeed;
		double offsetAn;
		double offsetEn;
};

class Options
{
	public:
		static int SpeedSamples;
		static int Angle;
		static Radius R;
		static bool ShowCross;
		static SpeedDef Def;
		static bool PrintInfo;

};



















#endif

