/////////////////////////////////////////////////////////////////////
// Code fuer den Kreativ-Wettbewerb zum 25. c't-Geburtstag von     //
// Josef Schtzenberger, basierend auf den Delphi Code von         //
// Joe Merten, ajm@jme.de, 29.06.2008                              //
// Getestet mit Delphi 7 unter Windows XP                          //
/////////////////////////////////////////////////////////////////////
{$Define noDebug}
unit AstStat;
                          
interface
uses AstGame,Windows,Types;
type TStat = record
               StartFrame,EndFrame:integer;
               StartFrame1,EndFrame1:integer;
               Score,SoucerFrame,SoucerDirChange:integer;
             end;
TLevelStat=array[0..40] of TStat;

Procedure DoStat(aGame:TAstGame);
Procedure StatNewLevel(aGame:TAstGame);
Procedure StatNewGame(aGame:TAstGame);
Procedure StatGameOver(aGame:TAstGame);
Procedure StatEndLevel(aGame:TAstGame);
 function myOutputDebug(const Args: array of const): string;
 function myOutputDebug1(const Args: array of const): string;
 function myOutputStat(const Args: array of const): string;

var LevelStat:TLevelStat;
    LevelCount:integer=0;
    var LogFile: TextFile;
    LevelEnded:boolean;
    LevelStarted:boolean;
    GameStarted:boolean;
    Start1:boolean;
    SoucerDirChange:boolean;
    Soucer:boolean;
implementation
uses math,SysUtils;
procedure Start(aGame:TAstGame);
var i,StoneCount:integer; pObj:TAstObject;
begin
  StoneCount:=0;
  for i:=0 to aGame.Objects.Stones.Count-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
    if pObj.nScale<>14 then exit;
    inc(StoneCount);
  end;
  if StoneCount=2 then
  begin
    Start1:=true;
    LevelStat[LevelCount].StartFrame1:=agame.RxFrameCount-285;
  end;
end;
procedure Stop(aGame:TAstGame);
begin
    if Start1=false then exit;
    Start1:=false;
    LevelStat[LevelCount].EndFrame1:=agame.RxFrameCount-285;
end;
Procedure DoStat(aGame:TAstGame);
begin
  if not GameStarted and (aGame.Objects.BigStones=4) and (aGame.Objects.Stones.Count=4) and (aGame.Objects.pShip<>nil) then
  begin
    StatNewGame(aGame);
  end;
//  if not LevelStarted and GameStarted and (aGame.Objects.BigStones=aGame.Objects.Stones.Count) and (aGame.Objects.Stones.Count>0)
//  and (aGame.Objects.pShip<>nil) then
  if not LevelStarted and GameStarted and (aGame.Objects.Stones.Count>0)
  then
  begin
    StatNewLevel(aGame);
  end;
//  if not LevelEnded and (aGame.Objects.Stones.Count=0) and (aGame.Objects.pSaucer=nil)
//  and (((aGame.Objects.pShip =nil) and (aGame.Objects.apExplos.Count=1))
//    or ((aGame.Objects.pShip<>nil) and (aGame.Objects.apExplos.Count=0)))
  if not LevelEnded and LevelStarted and GameStarted and (aGame.Objects.Stones.Count=0)
  then
  begin
    StatEndLevel(aGame);
  end;
  if not Start1 and LevelStarted and GameStarted and (aGame.Objects.Stones.Count>1)and (aGame.Objects.Stones.Count<5)
     and (aGame.Objects.pShip<>nil)
     then
  begin
    Start(aGame);
  end;
  if not Soucer and GameStarted and (aGame.Objects.pSaucer<>nil)
     and (aGame.Objects.pShip<>nil) then
  begin
    Soucer:=true;
    LevelStat[LevelCount].SoucerFrame:=agame.RxFrameCount-285;
  end;
  if not SoucerDirChange and Soucer and GameStarted
  and (aGame.Objects0.pSaucer<>nil) and (aGame.Objects0.pSaucer.dy<>0)
  then
  begin
    SoucerDirChange:=true;
    LevelStat[LevelCount].SoucerDirChange:=agame.RxFrameCount-285;
  end;
end;

Procedure StatNewLevel(aGame:TAstGame);
begin
  SoucerDirChange:=false;
  Soucer:=false;
  Start1:=false;
  LevelEnded:=false;
  LevelStarted:=true;
  inc(LevelCount);
  LevelStat[LevelCount].StartFrame:=agame.RxFrameCount-285;
end;
Procedure StatEndLevel(aGame:TAstGame);
begin
  LevelEnded:=true;
  LevelStarted:=false;
  LevelStat[LevelCount].EndFrame:=agame.RxFrameCount-285;
  LevelStat[LevelCount+1].Score:=aGame.Objects.nScore;
  Stop(aGame);
end;
Procedure StatNewGame(aGame:TAstGame);
begin
  LevelCount:=-1;
  LevelEnded:=true;
  GameStarted:=true;
end;
Procedure StatGameOver(aGame:TAstGame);
var i:integer;
begin
  if not GameStarted then exit;
  StatEndLevel(aGame);
  GameStarted:=false;
  for i:=0 to LevelCount do
  begin
    myOutputStat(['Level=',i,' StartFrame=',LevelStat[i].StartFrame,' EndFrame=',LevelStat[i].EndFrame
    ,' Frames=',LevelStat[i].EndFrame-LevelStat[i].StartFrame
    ,' L2Frames=',LevelStat[i].EndFrame1-LevelStat[i].StartFrame1,' Pause=',LevelStat[i].EndFrame-LevelStat[i+1].StartFrame
    ,' Score=',LevelStat[i].Score-LevelStat[i+1].Score
    ,' Soucer=',LevelStat[i].SoucerFrame
    ,' SoucerD=',LevelStat[i].SoucerFrame-LevelStat[i].StartFrame
    ,' SoucerDC=',LevelStat[i].SoucerDirChange-LevelStat[i].StartFrame
    ,' Scorekum=',LevelStat[i].Score
    ]);
  end;
{  for i:=0 to LevelCount do
  begin
     myOutputStat(['Level=',i,' StartFrame1=',LevelStat[i].StartFrame1,' EndFrame1=',LevelStat[i].EndFrame1
    ,' Frames1=',LevelStat[i].EndFrame1-LevelStat[i].StartFrame1]);
  end; }
end;
function Pad(s:String;len:integer):String;
begin
  result:=s;
  while Length(result)<len do result:=result+' ';
end;
function myOutputStat(const Args: array of const): string;
var I,k: Integer;
begin
{$ifndef Debug}
  exit;
{$endif}
  Result := '';k:=0;
  for I := k to High(Args) do
    with Args[I] do
      case VType of
        vtInteger:    Result := Result + Pad(IntToStr(VInteger),6);
        vtBoolean:    Result := Result + BoolToStr(VBoolean);
        vtChar:       Result := Result + VChar;
        vtExtended:   Result := Result + FloatToStr(VExtended^);
        vtString:     Result := Result + VString^;
        vtPChar:      Result := Result + VPChar;
        vtObject:     Result := Result + VObject.ClassName;
        vtClass:      Result := Result + VClass.ClassName;
        vtAnsiString: Result := Result + string(VAnsiString);
        vtCurrency:   Result := Result + CurrToStr(VCurrency^);
        vtVariant:    Result := Result + string(VVariant^);
        vtInt64:      Result := Result + IntToStr(VInt64^);
    end;
  OutputDebugString(PChar(result));
 //      Writeln(LogFile, result);
end;
function myOutputDebug(const Args: array of const): string;
var I,k: Integer;
begin
{$ifndef Debug}
  exit;
{$endif}
  Result := '';k:=0;
//  with Args[0] do if string(VAnsiString)='CheckSoucerShotCollision' then k:=1;
 // with Args[0] do if string(VAnsiString)='OptimLast4' then k:=1;
  with Args[0] do if string(VAnsiString)='INOUT' then k:=1;
  for I := k to High(Args) do
    with Args[I] do
      case VType of
        vtInteger:    Result := Result + IntToStr(VInteger);
        vtBoolean:    Result := Result + BoolToStr(VBoolean);
        vtChar:       Result := Result + VChar;
        vtExtended:   Result := Result + FloatToStr(VExtended^);
        vtString:     Result := Result + VString^;
        vtPChar:      Result := Result + VPChar;
        vtObject:     Result := Result + VObject.ClassName;
        vtClass:      Result := Result + VClass.ClassName;
        vtAnsiString: Result := Result + string(VAnsiString);
        vtCurrency:   Result := Result + CurrToStr(VCurrency^);
        vtVariant:    Result := Result + string(VVariant^);
        vtInt64:      Result := Result + IntToStr(VInt64^);
    end;
 if k=1 then
//  OutputDebugString(PChar(result));
       Writeln(LogFile, result);
end;
function myOutputDebug1(const Args: array of const): string;
var I,k: Integer;
begin
{$ifndef Debug}
  exit;
{$endif}
  Result := '';k:=0;
//  with Args[0] do if string(VAnsiString)='CheckSoucerShotCollision' then k:=1;
  for I := k to High(Args) do
  begin
    with Args[I] do
      case VType of
        vtInteger:    Result := Result + IntToStr(VInteger);
        vtBoolean:    Result := Result + BoolToStr(VBoolean);
        vtChar:       Result := Result + VChar;
        vtExtended:   Result := Result + FloatToStr(VExtended^);
        vtString:     Result := Result + VString^;
        vtPChar:      Result := Result + VPChar;
        vtObject:     Result := Result + VObject.ClassName;
        vtClass:      Result := Result + VClass.ClassName;
        vtAnsiString: Result := Result + string(VAnsiString);
        vtCurrency:   Result := Result + CurrToStr(VCurrency^);
        vtVariant:    Result := Result + string(VVariant^);
        vtInt64:      Result := Result + IntToStr(VInt64^);
    end;
    result:=result+chr(9);
   end;
 //  OutputDebugString(PChar(result));
 // if k=1 then OutputDebugString(PChar(result);
//       Writeln(LogFile, result);
end;

initialization
begin
  LevelCount:=-1;
  LevelEnded:=true;
  GameStarted:=false;
{$ifdef Debug}
  AssignFile(LogFile, 'c:\atari\log.txt');
  Rewrite(LogFile);
{$endif}
end;
finalization
begin
{$ifdef Debug}
  CloseFile(LogFile);
{$endif}
end;
end.
