/////////////////////////////////////////////////////////////////////
// Code fuer den Kreativ-Wettbewerb zum 25. c't-Geburtstag von     //
// Josef Schtzenberger, basierend auf den Delphi Code von         //
// Joe Merten, ajm@jme.de, 29.06.2008                              //
// Getestet mit Delphi 7 unter Windows XP                          //
/////////////////////////////////////////////////////////////////////
unit AstMath;
interface
uses AstGame,Windows,Types;
 type TTriangle = record
                 a,b,c,wa,wb,wc,w,wrz:integer;
                 end;                                    
     TTriangleArray=array[0..1] of TTriangle;
     TFireZone=record
                EnterFireZone:integer; //Frames bis zu zum ehestmglichen Schuss
                ShotDistEnter:integer; //Laufzeit des ehestmglichen Schusses in Frames
                LeaveFireZone:integer; //Frames bis zu zum letztmglichen Schuss
                ShotDistLeave:integer; //Laufzeit des letztmglichen Schusses in Frames
                ast,sho,a1,b1,r:integer;
               end;

function CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer):TTriangle;
function CalcLeadAngle(ps,pz: TAstObject;ShipAngle:integer): TTriangle;
function CalcLeadAngles(const ps,pz: TAstObject;ShipAngle:integer): TTriangleArray;
function CalcLeadAnglesDelay(ps,pz: TAstObject;ShipAngle,Delay:integer): TTriangleArray;
 function CalcDistXY(p,p0: TAstObject): TPoint;
 function CalcDist(p,p0: TAstObject): integer;
 function CalcPreDistKart(p,p0: TAstObject): TPoint;
 function CalcDistKart(p,p0: TAstObject): TPoint;
 function CalcVorhalteWinkel(ps,pz: TAstObject): TTriangle;
 function CalcVorhalteWinkel2(ps,pz: TAstObject;ShipAngle:integer): TTriangle;
 function CalcViewAngle(pShip,p0: TAstObject): integer;
 function CalcAngle(pShip,p0: TAstObject): integer;
 function SameValue(const A, B: Integer; Epsilon: Integer = 0): Boolean;overload;
 function DiffAngle(const A, B: Integer): Integer;
 function CompareAngleValue(const A, B: Extended; Epsilon: Extended): TValueRelationship;
 function FramesTillCollision(ps,pz: TAstObject): integer;
 function Rad2Degr(a:integer):integer;
 function FireZone(ps,pz: TAstObject;ShotAngle:integer): TFireZone;
 function FireZone1(pz:TAstObject;ShotAngle,AbstandzuZiel,RichtungzuZiel:integer): TFireZone;
 function AnglePerFrame(ps,pz: TAstObject): integer;
 function Round2(x:extended):integer;
type
 TStoneInfo=record
                 rotFrames :integer;
                 shotFrames :integer;
                 w :integer;
                 rotAngle :integer;
                 pObj:TAstObject;
                 Triangle:TTriangle;
                end;

TAstCompare=class
private
  aGame:TAstGame;
public
  FMinFrames:integer;
  FStone1:TStoneInfo;
  constructor Create(astGame:TAstGame);
  procedure Reset;
  procedure MinFrame(Stone1:TStoneInfo;pObj:TAstObject;Delay:integer);
end;
TAstCompare2=class
private
  aGame:TAstGame;
public
  FMinFrames:integer;
  FStone1:TStoneInfo;
  constructor Create(astGame:TAstGame);
  procedure Reset;
  procedure MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj:TAstObject;Delay:integer);
end;
TAstCompare3=class
private
  aGame:TAstGame;
public
  FMinFrames:integer;
  FStone1:TStoneInfo;
  constructor Create(astGame:TAstGame);
  procedure Reset;
  procedure MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj,Stone4Obj:TAstObject;Delay:integer);
end;
TAstCompare4=class
private
  aGame:TAstGame;
public
  FMinFrames:integer;
  FStone1:TStoneInfo;
  constructor Create(astGame:TAstGame);
  procedure Reset;
  procedure MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj,Stone4Obj,Stone5Obj:TAstObject);
end;
TShotLengthFinder=class
private
  aGame:TAstGame;
public
  TestShotFired:boolean;
  startframe,TestShotbits:integer;
  Shotcount:integer;
  constructor Create(astGame:TAstGame);
  procedure Reset;
  function  GetActHitDistFrames(RxFrameCount:integer):integer;
  procedure FireTestShot;
end;

var AstCompare:TAstCompare;
    AstCompare2:TAstCompare2;
    AstCompare3:TAstCompare3;
    AstCompare4:TAstCompare4;
    ShotLengthFinder:TShotLengthFinder;
 startsyncwbyte:boolean=true;
 syncwbytendx:integer=0;
 wba:array[0..50,0..1] of integer;

 const WinkelByte: array[0..255] of Integer = //(0, 1, 2, 3);
(0,
4504,
9025,
12724,
17277,
21277,
25329,
30210,
34206,
37926,
42453,
46273,
50751,
55305,
59790,
63823,
67851,
71836,
76434,
80125,
84556,
89141,
92648,
97241,
101632,
105547,
110136,
114146,
118179,
122196,
126711,
131186,
135000,
138814,
143289,
147804,
151821,
155854,
159864,
164453,
168368,
172759,
177352,
-179141,
-174556,
-170125,
-166434,
-161836,
-157851,
-153823,
-149790,
-145305,
-140751,
-136273,
-132453,
-127926,
-124206,
-120210,
-115329,
-111277,
-107277,
-102724,
-99025,
-94504,
-90000,
-86365,
-81900,
-77276,
-73549,
-68723,
-64671,
-60607,
-56570,
-52074,
-48191,
-43727,
-39249,
-34695,
-30651,
-26565,
-22479,
-18435,
-13788,
-10025,
-5444,
-874,
2692,
7241,
11807,
15547,
20136,
24146,
28179,
32700,
36711,
41186,
45000,
49525,
53289,
57804,
61821,
66716,
70744,
74453,
79209,
82759,
87352,
91790,
95444,
99875,
104470,
108164,
112945,
116950,
120951,
125404,
129916,
133727,
137547,
142074,
145794,
150255,
155070,
158723,
162723,
167276,
170975,
175568,
180000,
-176424,
-171900,
-167276,
-163549,
-158723,
-155070,
-151064,
-146570,
-142074,
-138191,
-133727,
-129916,
-125404,
-121399,
-117345,
-113284,
-108435,
-104707,
-100025,
-95444,
-91819,
-87308,
-82759,
-79046,
-74453,
-70744,
-66716,
-61821,
-57300,
-53289,
-49525,
-45000,
-40475,
-36711,
-32700,
-28179,
-23284,
-19256,
-15547,
-10954,
-7241,
-2692,
1819,
5444,
10025,
14707,
18435,
23284,
27345,
31399,
35404,
39916,
43727,
48191,
52074,
56570,
61064,
65070,
68723,
73549,
77276,
81900,
86424,
90000,
94432,
99025,
102724,
107277,
111277,
114930,
119745,
124206,
127926,
132453,
136273,
140084,
144596,
149049,
153050,
157055,
161836,
165530,
170125,
174556,
178210,
-177352,
-172759,
-169209,
-164453,
-160744,
-156716,
-151821,
-147804,
-143289,
-139525,
-135000,
-131186,
-126711,
-122700,
-118179,
-114146,
-110136,
-105547,
-101807,
-97241,
-92692,
-89126,
-84556,
-79975,
-76212,
-71565,
-67521,
-63435,
-59349,
-55305,
-50751,
-46273,
-41809,
-37926,
-33430,
-29393,
-25329,
-21277,
-16451,
-12724,
-8100,
-3635);

implementation
uses math,SysUtils,AstStat;
constructor TShotLengthFinder.Create(astGame:TAstGame);
begin
  aGame:=astGame;
  Reset;
end;
procedure TShotLengthFinder.Reset;
begin
  TestShotFired:=false;
  startframe:=0;
  Shotcount:=0;
end;
Function TShotLengthFinder.GetActHitDistFrames(RxFrameCount:integer):integer;
var x,k:integer;
begin
   k:=3-(((Shotcount-71)+TestShotbits) and 3);
   if Shotcount=0 then x:=3 else x:=(RxFrameCount and 3 + k) and 3;
   result:=72-x;
end;

procedure TShotLengthFinder.FireTestShot;
begin
  if (aGame.Objects.Stones.Count>0) then
  begin
    TestShotFired:=false;
  end;
  if (aGame.Objects.apShots.Count=0) and  TestShotFired and (agame.RxFrameCount-startframe>=2) then
  begin
    Shotcount:=agame.RxFrameCount-startframe;
    TestShotFired:=false;
  end;
  if TestShotFired  and (aGame.Objects.apShots.Count>1) then  reset;
  if (aGame.Objects.Stones.Count=0) and (aGame.Objects.pSaucer=nil)and (aGame.Objects.apExplos.Count>0)
  and (aGame.Objects.apShots.Count=0) and not TestShotFired then
  begin
    aGame.Fire;
    TestShotFired:=true;
    startframe:=agame.RxFrameCount;
    TestShotbits:=agame.RxFrameCount and 3;
  end;
end;
constructor TAstCompare.Create(astGame:TAstGame);
begin
  aGame:=astGame;
end;
procedure TAstCompare.Reset;
begin
  FMinFrames:=high(integer);
end;
procedure TAstCompare.MinFrame(Stone1:TStoneInfo;pObj:TAstObject;Delay:integer);
var rotFrames,shotFrames,f:integer;tra:TTriangleArray;
begin
  if Stone1.w=high(integer) then exit;
  if Stone1.shotFrames>69 then exit;
  Delay:=Abs(Round(Stone1.rotAngle/(4218/180*PI)*8))+Delay;
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,pObj,Stone1.w,Delay);
  if tra[0].a<650000 then
  begin
    rotFrames:=abs(round(DiffAngle(tra[0].w,Stone1.w)/(3000*2*PI/256)));
    shotFrames:=tra[0].a div 8000;
    f:=Max(Stone1.shotFrames,rotFrames+shotFrames)+Stone1.rotFrames;
    if f<FMinFrames then
    begin
      FMinFrames:=f;
      FStone1:=Stone1;
    end;
  end;
  if tra[1].w<>high(integer) then
  begin
    rotFrames:=abs(round(DiffAngle(tra[0].w,Stone1.w)/(3000*2*PI/256)));
    shotFrames:=tra[0].a div 8000;
    f:=Max(Stone1.shotFrames,rotFrames+shotFrames)+Stone1.rotFrames;
    if f<FMinFrames then
    begin
      FMinFrames:=f;
      FStone1:=Stone1;
    end;
  end;
end;
constructor TAstCompare2.Create(astGame:TAstGame);
begin
  aGame:=astGame;
end;
procedure TAstCompare2.Reset;
begin
  FMinFrames:=high(integer);
end;
procedure TAstCompare2.MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj:TAstObject;Delay:integer);
var f:integer;tra:TTriangleArray;
    StoneInfo1: TStoneInfo;
    StoneInfo1a: TStoneInfo;
begin
  if Stone1.w=high(integer) then exit;
  if Stone1.shotFrames>69 then exit;
  Delay:=Abs(Round(Stone1.rotAngle/(4218/180*PI)*8))+Delay;
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone2Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone2Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone2Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare.Reset;
  AstCompare.MinFrame(StoneInfo1,Stone3Obj,Delay);
  AstCompare.MinFrame(StoneInfo1a,Stone3Obj,Delay);

  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone3Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone3Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone3Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare.MinFrame(StoneInfo1,Stone2Obj,Delay);
  AstCompare.MinFrame(StoneInfo1a,Stone2Obj,Delay);
  if AstCompare.FMinFrames=High(integer) then exit;
  f:=Max(AstCompare.FStone1.shotFrames,AstCompare.FMinFrames)+Stone1.rotFrames;
  if f<FMinFrames then
  begin
    FMinFrames:=f;
    FStone1:=Stone1;
  end;
end;
constructor TAstCompare3.Create(astGame:TAstGame);
begin
  aGame:=astGame;
end;
procedure TAstCompare3.Reset;
begin
  FMinFrames:=high(integer);
end;
procedure TAstCompare3.MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj,Stone4Obj:TAstObject;Delay:integer);
var f:integer;tra:TTriangleArray;
    StoneInfo1: TStoneInfo;
    StoneInfo1a: TStoneInfo;
begin
  if Stone1.w=high(integer) then exit;
  if Stone1.shotFrames>69 then exit;
  Delay:=Abs(Round(Stone1.rotAngle/(4218/180*PI)*8));
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone2Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone2Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone2Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare2.Reset;
  AstCompare2.MinFrame(StoneInfo1,Stone3Obj,Stone4Obj,Delay);
  AstCompare2.MinFrame(StoneInfo1a,Stone3Obj,Stone4Obj,Delay);
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone3Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone3Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone3Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare2.MinFrame(StoneInfo1,Stone2Obj,Stone4Obj,Delay);
  AstCompare2.MinFrame(StoneInfo1a,Stone2Obj,Stone4Obj,Delay);
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone4Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone4Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone4Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare2.MinFrame(StoneInfo1,Stone2Obj,Stone3Obj,Delay);
  AstCompare2.MinFrame(StoneInfo1a,Stone2Obj,Stone3Obj,Delay);
  if AstCompare2.FMinFrames=High(integer) then exit;
  f:=Max(AstCompare2.FStone1.shotFrames,AstCompare2.FMinFrames)+Stone1.rotFrames;
  if f<FMinFrames then
  begin
    FMinFrames:=f;
    FStone1:=Stone1;
  end;
end;
constructor TAstCompare4.Create(astGame:TAstGame);
begin
  aGame:=astGame;
end;
procedure TAstCompare4.Reset;
begin
  FMinFrames:=high(integer);
end;
procedure TAstCompare4.MinFrame(Stone1:TStoneInfo;Stone2Obj,Stone3Obj,Stone4Obj,Stone5Obj:TAstObject);
var Delay,f:integer;tra:TTriangleArray;
    StoneInfo1: TStoneInfo;
    StoneInfo1a: TStoneInfo;
begin
  if Stone1.w=high(integer) then exit;
  if Stone1.shotFrames>69 then exit;
  Delay:=Abs(Round(Stone1.rotAngle/(4218/180*PI)*8));
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone2Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone2Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone2Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare3.Reset;
  AstCompare3.MinFrame(StoneInfo1,Stone3Obj,Stone4Obj,Stone5Obj,Delay);
  AstCompare3.MinFrame(StoneInfo1a,Stone3Obj,Stone4Obj,Stone5Obj,Delay);
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone3Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone3Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone3Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare3.MinFrame(StoneInfo1,Stone2Obj,Stone4Obj,Stone5Obj,Delay);
  AstCompare3.MinFrame(StoneInfo1a,Stone2Obj,Stone4Obj,Stone5Obj,Delay);
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone4Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone4Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone4Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare3.MinFrame(StoneInfo1,Stone2Obj,Stone3Obj,Stone5Obj,Delay);
  AstCompare3.MinFrame(StoneInfo1a,Stone2Obj,Stone3Obj,Stone5Obj,Delay);
  if AstCompare3.FMinFrames=High(integer) then exit;
  f:=Max(AstCompare3.FStone1.shotFrames,AstCompare3.FMinFrames)+Stone1.rotFrames;
  if f<FMinFrames then
  begin
    FMinFrames:=f;
    FStone1:=Stone1;
  end;
  tra:=CalcLeadAnglesDelay(aGame.Objects.pShip,Stone5Obj,Stone1.w,Delay);
  StoneInfo1.rotAngle:=DiffAngle(tra[0].w,Stone1.w);
  StoneInfo1.rotFrames:=abs(round(StoneInfo1.rotAngle/(3000*PI/128)));
  StoneInfo1.shotFrames:=tra[0].a div 8000;
  StoneInfo1.w:=tra[0].w;
  StoneInfo1.pObj:=Stone5Obj;
  StoneInfo1.Triangle:=tra[0];
  StoneInfo1a.w:=tra[1].w;
  if tra[1].w<>high(integer) then
  begin
    StoneInfo1a.rotAngle:=DiffAngle(tra[1].w,Stone1.w);
    StoneInfo1a.rotFrames:=abs(round(StoneInfo1a.rotAngle/(3000*PI/128)));
    StoneInfo1a.shotFrames:=tra[1].a div 8000;
    StoneInfo1a.pObj:=Stone5Obj;
    StoneInfo1a.Triangle:=tra[1];
  end;
  AstCompare3.MinFrame(StoneInfo1,Stone2Obj,Stone3Obj,Stone4Obj,Delay);
  AstCompare3.MinFrame(StoneInfo1a,Stone2Obj,Stone3Obj,Stone4Obj,Delay);
  if AstCompare3.FMinFrames=High(integer) then exit;
  f:=Max(AstCompare3.FStone1.shotFrames,AstCompare3.FMinFrames)+Stone1.rotFrames;
  if f<FMinFrames then
  begin
    FMinFrames:=f;
    FStone1:=Stone1;
  end;
end;

function ArcCos2(const X: Extended): Extended;
begin
  if X > 1 then Result := 0 else
  if X < -1 then Result := PI else
  Result := ArcTan2(Sqrt(1 - X * X), X);
end;
function DiffAngle(const A, B: Integer): Integer; overload;
var D:extended;
begin
  D:=(A-B)/1000;
  if D>PI then D:=D-2*PI;
  if D<-PI then D:=D+2*PI;
  Result :=round(D*1000);
end;
function DiffAngle(const A, B: extended): extended; overload;
var D:extended;
begin
  D:=(A-B);
  if D>PI then D:=D-2*PI;
  if D<-PI then D:=D+2*PI;
  Result := D;
end;
function Rad2Degr(a:integer):integer;
begin
 result:=round(a*0.180/PI*100);
  if result>18000 then result:=result-36000;
  if result<-18000 then result:=result+36000;
end;
function Rad2Deg(a:extended):extended;
begin
 result:=a*180/PI;
end;
function Round2(x:extended):integer;
begin
  if x>high(integer) then result:=high(integer) else
  if x<low(integer) then result:=low(integer) else
  result:=round(x);
end;
function CalcFireZone(ObjRadius,RichtungSchiff,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer):TFireZone;
var
c,   //Abstand zwischen Ziel und Schiff
wa, //Winkel zwischen Laufrichtung Ziel und Richtung Ziel-Schiff
x1,a,b,wb,wc,b1,a1,sinwc,tanwc:extended;
TFrames,TFrames1:integer;
begin
 {   ObjRadius:=50;
    AbstandzuZiel:=1000;
    RichtungzuZiel:=round(-90*PI/180*1000);
    BewegungsrichtungZiel:=round(0*PI/180*1000);
    RichtungSchiff:=round(-95*PI/180*1000);  }
    result.ShotDistEnter:=99999;
    result.EnterFireZone:=99999;
    result.ShotDistLeave:=99999;
    result.LeaveFireZone:=99999;
    c:=AbstandzuZiel;
    wa:=DiffAngle(BewegungsrichtungZiel/1000,RichtungzuZiel/1000);
    wb:=DiffAngle(RichtungSchiff/1000,RichtungzuZiel/1000);
    if sign(wa)<>sign(wb) then exit;
    wa:=DiffAngle(BewegungsrichtungZiel/1000,RichtungzuZiel/1000+PI);
    wb:=DiffAngle(RichtungzuZiel/1000,RichtungSchiff/1000);
    wa:=abs(wa);wb:=abs(wb);
    if wa+wb>PI then exit;
    wc:=Abs(DiffAngle(PI,wa+wb));
    sinwc:=sin(wc);
    tanwc:=tan(wc);
    if sinwc=0 then
    begin
      sinwc:=1E-99;
      tanwc:=1E-99;
    end;
    x1:=c/sinwc;
    if abs(wa)>PI/2 then
    begin
      b:=x1*sin(wb);
      a:=Sqrt(b*b+c*c-2*b*c*cos(wa));
    end else
    begin
      a:=x1*sin(wa);
      if abs(wb)>PI/2 then b:=Sqrt(a*a+c*c-2*a*c*cos(wb))
      else b:=x1*sin(wb);
    end;
    b1:=ObjRadius/sinwc;
    a1:=ObjRadius/tanwc;
    TFrames1:=Round2((b-b1)/(GeschwindigkeitZiel/100));
    result.ShotDistEnter:=Round2((a-a1)/8);
    result.EnterFireZone:=TFrames1-result.ShotDistEnter;
    TFrames:=Round2((b+b1)/(GeschwindigkeitZiel/100));
    result.ShotDistLeave:=Round2((a+a1)/8);
    result.LeaveFireZone:=TFrames-result.ShotDistLeave;
end;
{    target /\
           /wa\
       c /     \ b
        /       \
       /wb     wc\
     /____________\
   ship    a     hit
 }
function FireZone(ps,pz: TAstObject;ShotAngle:integer): TFireZone;
var AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel,Radius:integer;
    AbstandK:TPoint;
begin
  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  Radius:=pz.nRadiusX;
  result:=CalcFireZone(Radius,ShotAngle,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function FireZone1(pz:TAstObject;ShotAngle,AbstandzuZiel,RichtungzuZiel:integer): TFireZone;
var GeschwindigkeitZiel,BewegungsrichtungZiel,Radius:integer;
begin
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  Radius:=pz.nRadiusX;
  result:=CalcFireZone(Radius,ShotAngle,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function AnglePerFrame(ps,pz: TAstObject): integer;
var RichtungzuZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx));
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x));
  result:=-Round(sign(100*Sin((RichtungzuZiel-BewegungsrichtungZiel))));
end;
function WrapKoord(tr:TTriangle;var x1,y1:integer):boolean; overload;
var x,y:extended;
begin
  result:=false;
  y:=Sin(tr.w/1000)*tr.a/1000;
  x:=Cos(tr.w/1000)*tr.a/1000;
  if (x>= 512) or (x<=-512) or (y>= 384) or (y<=-384) then result:=true;
  if x>= 512 then x1:=x1-1024;
  if x<=-512 then x1:=x1+1024;
  if y>= 384 then y1:=y1-768;
  if y<=-384 then y1:=y1+768;
end;
procedure WrapKoord(var a,w:extended); overload;
var x,y:extended;
begin
  y:=Sin(w)*a;
  x:=Cos(w)*a;
  if x>= 512 then x:=x-1024;
  if x<=-512 then x:=x+1024;
  if y>= 384 then y:=y-768;
  if y<=-384 then y:=y+768;
  a:=Sqrt(x*x+y*y);
  w:=ArcTan2(y, x);
end;
function CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer):TTriangle;
var Ax,Bx,Cx,
x,  //Geschwindigkeit Ziel=x*Shot
y,  //Schuss wird y Einheiten spter abgefeuert
c,  //Abstand zwischen Ziel und Schiff
wa, //Winkel zwischen Laufrichtung Ziel und Richtung Ziel-Schiff
x1,a,b,wb,wc,w:extended;
begin
    result.a:=0;
    result.b:=0;
    result.c:=0;
    result.wa:=0;
    result.wb:=0;
    result.wc:=0;
    result.wrz:=RichtungzuZiel;
    result.w:=-999999;
    if GeschwindigkeitZiel=0 then
    begin
      result.a:=AbstandzuZiel;    // ship-hitpoint
      result.b:=0;    // target-hitpoint
      result.c:=AbstandzuZiel;    // ship-target
      result.wa:=0;  // target move-direction/ship-direction
      result.wb:=0;  // ship to turn inorder to hit
      result.wc:=0;  // target/shot hit angel
      result.w:=RichtungzuZiel;    // abs shipangle to hit
      exit;
    end;
    wa:=RichtungzuZiel/1000+PI;
    if wa>PI then wa:=wa-2*PI;
    wa:=Abs(BewegungsrichtungZiel/1000-wa);
    if wa>PI then wa:=wa-2*PI;
    c:=AbstandzuZiel;
    x:=GeschwindigkeitZiel/800; //800 v shot
    y:=Verzoegerung*x;
    if (x>=1) and (wa>PI/2) then exit;
    if x=1 then x:=1+1E-10;
    Ax := 1 - x * x;
    Bx := x * c * Cos(wa) - y * x;
    Cx := 2 * y * c * Cos(wa) - y * y - c * c;
    x1 := Bx * Bx - Ax * Cx;
    if x1 < 0 then exit;
    a := (-Bx + Sqrt(x1)) / Ax;
    if x<>0 then
    begin
      Bx := -y / (x * x) + c * Cos(wa);
      Ax := 1 / (x * x) - 1;
      Cx := y * y / (x * x) - c * c;
      x1 := Bx * Bx - Ax * Cx;
      if x1 < 0 then exit;
      b := (-Bx + Sqrt(x1)) / Ax;
      if b < 0 then exit;
      if b<1E-12 then
      begin
       wc :=PI;
       wa :=0;
      end else
       wc := ArcCos2((b*b+a*a-c*c)/(2*a*b));
    end else
    begin
      b:=0;
      wc :=PI;
    end;
    wa := Abs(wa);
    assert(abs((c*c+a*a-b*b)/(2*a*c))<=1.1);
    wb := ArcCos2((c*c+a*a-b*b)/(2*a*c));
    w  := Sin((RichtungzuZiel-BewegungsrichtungZiel)/1000);
    w  := -sign(w)*wb+RichtungzuZiel/1000;
    result.a:=round(a*1000);    // ship-hitpoint
    result.b:=round(b*1000);    // target-hitpoint
    result.c:=round(c*1000);    // ship-target
    result.wa:=round(wa*1000);  // target move-direction/ship-direction
    result.wb:=round(wb*1000);  // ship to turn inorder to hit
    result.wc:=round(wc*1000);  // target/shot hit angel
    result.w:=round(w*1000);    // abs shipangle to hit
 end;
{    target /\
           /wa\
       c /     \ b
        /       \
       /wb     wc\
     /____________\
   ship    a     hit
 }
function CalcLeadAngle(ps,pz:TAstObject;ShipAngle:integer): TTriangle;
var Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  Verzoegerung:=Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));  //aim in front of
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function CalcLeadAngleWrap(ps,pz:TAstObject;ShipAngle:integer): TTriangle;
var x,y,Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
begin
  x:=pz.x-ps.x;
  y:=pz.y-ps.y;
  AbstandzuZiel:=Round(Sqrt(x*x+y*y));
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  RichtungzuZiel:=round(ArcTan2(y,x)*1000);
  Verzoegerung:=Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));  //aim in front of
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*8));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function CalcLeadAngles(const ps,pz: TAstObject;ShipAngle:integer): TTriangleArray;
var x,y,Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  result[1].w:=High(integer);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  x:=AbstandK.x;
  y:=AbstandK.y;
  AbstandzuZiel:=Round(Sqrt(x*x+y*y));
  RichtungzuZiel:=round(ArcTan2(y, x)*1000);
  Verzoegerung:=Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));  //aim in front of
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  if WrapKoord(result[0],x,y) then
  begin
    AbstandzuZiel:=Round(Sqrt(x*x+y*y));
    RichtungzuZiel:=round(ArcTan2(y,x)*1000);
    Verzoegerung:=Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));  //aim in front of
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  end;
end;
function CalcLeadAnglesDelay1(ps,pz: TAstObject;ShipAngle,Delay:integer): TTriangleArray;
var x,y:integer;  AbstandK:TPoint;
 Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
begin
  result[1].w:=high(integer);
  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  Verzoegerung:=Delay+Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Delay+Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Delay+Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  x:=pz.x;
  y:=pz.y;
  if WrapKoord(result[0],x,y) then
  begin
    x:=x-ps.x;
    y:=y-ps.y;
    AbstandzuZiel:=Round(Sqrt(x*x+y*y));
    GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
    BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
    RichtungzuZiel:=round(ArcTan2(y,x)*1000);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  end;
end;

function CalcLeadAnglesDelay(ps,pz: TAstObject;ShipAngle,Delay:integer): TTriangleArray;
var x,y:integer;  AbstandK:TPoint;
 Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
begin
  result[1].w:=high(integer);
//  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
 // RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  x:=AbstandK.x;
  y:=AbstandK.y;
  AbstandzuZiel:=Round(Sqrt(x*x+y*y));
  RichtungzuZiel:=round(ArcTan2(y, x)*1000);

  Verzoegerung:=Delay+Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Delay+Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Delay+Abs(Round(DiffAngle(result[0].w,ShipAngle)/(421875/18000*PI)*8));
  result[0]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  if WrapKoord(result[0],x,y) then
  begin
    AbstandzuZiel:=Round(Sqrt(x*x+y*y));
    RichtungzuZiel:=round(ArcTan2(y,x)*1000);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(RichtungzuZiel,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
    Verzoegerung:=Delay+Abs(Round(DiffAngle(result[1].w,ShipAngle)/(421875/18000*PI)*8));
    result[1]:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  end;
end;


function CalcVorhalteWinkel2(ps,pz: TAstObject;ShipAngle:integer): TTriangle;
var Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  Verzoegerung:=0;
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*2));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
  Verzoegerung:=Abs(Round(DiffAngle(result.w,ShipAngle)/(421875/18000*PI)*2));
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function CalcVorhalteWinkel(ps,pz: TAstObject): TTriangle;
var Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  AbstandzuZiel:=CalcDist(ps,pz);
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  Verzoegerung:=0;
  result:=CalcKurs(Verzoegerung,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel);
end;
function FramesTillCollision(ps,pz: TAstObject): integer;
var MinCollWinkel,CollWinkel,MinimalerAbstand,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer;
    AbstandK:TPoint;
begin
  result:=-1;
  GeschwindigkeitZiel:=Round(Sqrt(pz.dx*pz.dx+pz.dy*pz.dy));
  BewegungsrichtungZiel:=round(ArcTan2(pz.dy, pz.dx)*1000)+round(PI*1000);
  AbstandK:=pz.GetDist(ps);
  RichtungzuZiel:=round(ArcTan2(Abstandk.y, Abstandk.x)*1000);
  MinimalerAbstand:=ps.nRadiusX+pz.nRadiusX+1;
  AbstandzuZiel:=CalcDist(ps,pz);
  MinCollWinkel:=Round((PI/2-ArcCos2(MinimalerAbstand/AbstandzuZiel))*1000);
  CollWinkel:=DiffAngle(BewegungsrichtungZiel,RichtungzuZiel);
  if Abs(MinCollWinkel)>=Abs(CollWinkel) then
  begin
    if GeschwindigkeitZiel=0 then exit;
    result:=(AbstandzuZiel-MinimalerAbstand)*100 div GeschwindigkeitZiel;
  end;
end;
function CompareAngleValue(const A, B: Extended; Epsilon: Extended): TValueRelationship;
var D:extended;
begin
  D:=A-B;
  if D>180 then D:=D-360;
  if D<-180 then D:=D+360;
  if Abs(D)<Epsilon then
    Result := EqualsValue
  else
    if D < 0 then
      Result := LessThanValue
    else
      Result := GreaterThanValue;
end;
function SameValue(const A, B: Integer; Epsilon: Integer = 0): Boolean;overload;
begin
  if A > B then
    Result := (A - B) <= Epsilon
  else
    Result := (B - A) <= Epsilon;
end;
function CalcDist(p,p0: TAstObject): integer;
  var x1,y1: Integer;
begin
  x1:=p0.x-p.x;
  y1:=p0.y-p.y;
  if x1>= 512 then Dec(x1,1024);
  if x1<=-512 then Inc(x1,1024);
  if y1>= 384 then Dec(y1,768);
  if y1<=-384 then Inc(y1,768);
  Result:=Round(Sqrt(x1*x1+y1*y1));
end;
function CalcDistXY(p,p0: TAstObject): TPoint;
  var x1,y1: Integer;
begin
  x1:=p0.x-p.x;
  y1:=p0.y-p.y;
  if x1>= 512 then Dec(x1,1024);
  if x1<=-512 then Inc(x1,1024);
  if y1>= 384 then Dec(y1,768);
  if y1<=-384 then Inc(y1,768);
  Result.X:=x1;
  Result.y:=y1;
end;
function CalcDistKart(p,p0: TAstObject): TPoint;
  var x1,y1,i: Integer;
begin
  x1:=p.x-p0.x;
  y1:=p.y-p0.y;
  if x1>= 512 then Dec(x1,1024);
  if x1<=-512 then Inc(x1,1024);
  if y1>= 384 then Dec(y1,768);
  if y1<=-384 then Inc(y1,768);
  p.xa[0]:=x1;
  for i:=0 to 6 do p.ya[i+1]:=p0.ya[i];
  p.ya[0]:=y1;
  for i:=0 to 6 do p.xa[i+1]:=p0.xa[i];
  Result.X:=0; Result.Y:=0;
  for i:=0 to 7 do
  begin
   Result.X:=Result.X+p.xa[i];
   Result.Y:=Result.Y+p.ya[i];
  end;
  p.frames:=p0.frames+1;
  if p.frames<8 then i:=p.frames else i:=8;
  Result.X:=Result.X*100 div i;
  Result.Y:=Result.Y*100 div i;
  p.shot:= Max(p0.shot-1,0);
  p.ownshot:=p0.ownshot;
  p.FireFrame:=p0.FireFrame;
  p.AimFrame:=p0.AimFrame;
  p.StartByte:=p0.StartByte;
  p.Collision:=p0.Collision;
  if p.shot<=0 then p.nshots:=0 else
    p.nshots:=p0.nshots;
end;
function CalcPreDistKart(p,p0: TAstObject): TPoint;
  var x1,y1,i: Integer;ya,xa:array[0..7] of integer;
begin
  x1:=p.x-p0.x;
  y1:=p.y-p0.y;
  if x1>= 512 then Dec(x1,1024);
  if x1<=-512 then Inc(x1,1024);
  if y1>= 384 then Dec(y1,768);
  if y1<=-384 then Inc(y1,768);
  xa[0]:=x1;
  for i:=0 to 6 do ya[i+1]:=p0.ya[i];
  ya[0]:=y1;
  for i:=0 to 6 do xa[i+1]:=p0.xa[i];
  Result.X:=0; Result.Y:=0;
  for i:=0 to 7 do
  begin
   Result.X:=Result.X+xa[i];
   Result.Y:=Result.Y+ya[i];
  end;
  if p0.frames+1<8 then i:=p0.frames+1 else i:=8;
  Result.X:=Result.X*100 div i;
  Result.Y:=Result.Y*100 div i;
end;
function CalcViewAngle(pShip,p0: TAstObject): integer;
var x,dist:extended;
begin
  dist:=CalcDist(pShip,p0);
  x:=(p0.nRadiusX)/dist;
  result:=round(arctan(x)*1000);
end;
function CalcAngle(pShip,p0: TAstObject): integer;
var dxy:TPoint;
begin
  dxy:=CalcDistXY(pShip,p0);
  result:=round(arctan2(dxy.y,dxy.x)*1000);
end;

end.
