/////////////////////////////////////////////////////////////////////
// Code fuer den Kreativ-Wettbewerb zum 25. c't-Geburtstag von     //
// Josef Schtzenberger, basierend auf den Delphi Code von         //
// Joe Merten, ajm@jme.de, 29.06.2008                              //
// Getestet mit Delphi 7 unter Windows XP                          //
/////////////////////////////////////////////////////////////////////
unit AstJobs;

interface
uses AstGame;
type
  TAstJob=class
  private
    frame   : integer;
    AimFrame:integer;
    shots   : integer;
    roFrames: integer;
    game    : TAstGame;
    function TargetExists:boolean;
  public
    activ: boolean;
    constructor Create(aGame:TAstGame);
    destructor Destroy; override;
    procedure Run;
    procedure Reset;
    function RotateFrames(aFrames: integer):Boolean;
    function RotateFramesObj(aFrames,aAimFrame: integer):Boolean;
    function StartNShots(aShots: integer):integer;
    function CountOwnShots:integer;
  end;
implementation
uses aststat;
constructor TAstJob.Create(aGame:TAstGame);
begin
  game:=aGame;
  Reset;
end;
procedure TAstJob.Reset;
begin
  activ:=false;
  shots:=0;
  frame:=0;
  roFrames:=0;
  AimFrame:=0;
end;
function TAstJob.RotateFramesObj(aFrames,aAimFrame: integer):Boolean;
begin
  result:=false;
  if shots>1 then exit;
  roFrames:=aFrames;
  if aFrames<>0 then activ:=true;
  if activ then AimFrame:=aAimFrame;
  result:=true;
end;
function TAstJob.RotateFrames(aFrames: integer):Boolean;
begin
  roFrames:=aFrames;
  if aFrames<>0 then activ:=true;
  AimFrame:=0;
  result:=true;
end;
function TAstJob.CountOwnShots:integer;
var i:integer;
begin
 result:=0;
 for i:=0 to Game.Objects.apShots.Count-1 do
  begin
  if Game.Objects.apShots[i].ownshot then inc(result);
  end;
end;
function TAstJob.StartNShots(aShots: integer):integer;
var k:integer;
begin
            myOutputDebug(['OptimLast4','fire startshots=',game.RxFrameCount-285,' shots=',ashots]);
  if (frame=game.RxFrameCount-1) then begin result:=0;exit;end; //release key after shot in last frame
  k:=4-CountOwnShots;
  if k<aShots then  result:=k else result:=aShots;
  if result>0 then
  begin
    shots:=result;
    activ:=true;
  end;
end;
function TAstJob.TargetExists:boolean;
var i:integer;
begin
  result:=false;
  for i:=0 to Game.Objects.Stones.Count-1 do
  begin
    if Game.Objects.Stones[i].AimFrame<>AimFrame then continue;
    result:=true;
    break;
  end;
end;

procedure TAstJob.Run;
begin
  if not activ then exit;
  if shots>0 then
  begin
    if not (frame=game.RxFrameCount-1) then
    begin
      frame:=game.RxFrameCount;
      dec(shots);
      game.Fire;
    end;
  end;
  if (shots<=0) and (roFrames<>0) then
  begin
    if (AimFrame<>0) and not TargetExists then
    begin
      AimFrame:=0; //target was somehow destroyed
      roFrames:=0;
    end;
    if roFrames>0 then
    begin
      dec(roFrames);
      game.RotateRight;
    end;
    if roFrames<0 then
    begin
      inc(roFrames);
      game.RotateLeft;
    end;
  end;
  if (shots<=0) and (roFrames=0)then activ:=false;
end;

destructor TAstJob.Destroy;
begin
  inherited;
end;

end.
