#!/bin/sh

# Mac4Lin Installation Script
# Author: infra_red_dude
# Send feedback to infra_red_dude@users.sourceforge.net
# Homepage: http://sourceforge.net/projects/mac4lin

echo "**************************************"
echo "     Welcome to Mac4Lin Installer     "
echo 
echo " This installer will install most of  "
echo " Mac4Lin components and enable the UI "
echo
echo "    Note: Xfce users will need to     " 
echo "      manually enable the UI          "
echo "**************************************"
echo
echo
echo "*** Run this script as a normal user (not root!) ***"
read -p "Press any key to start Installation or Ctrl+C to quit this install"
echo

echo "Installing Mac4Lin UI..."
tar -xzf GTK/Mac4Lin_GTK_Aqua_v1.0.tar.gz -C ~/.themes/
tar -xzf GTK/Mac4Lin_GTK_Graphite_v1.0.tar.gz -C ~/.themes/
tar -xzf GTK/Mac4Lin_Meta_v1.0.tar.gz -C ~/.themes/

gconftool-2 --type string --set /desktop/gnome/interface/gtk_theme "Mac4Lin_GTK_Aqua_v1.0"
gconftool-2 --type string --set /apps/metacity/general/theme "Mac4Lin_GTK_Aqua_v1.0"
gconftool-2 --set /apps/metacity/general/button_layout --type string "close,minimize,maximize:menu"
gconftool-2 --type boolean --set /desktop/gnome/interface/menus_have_icons "true"
gconftool-2 --type string --set /desktop/gnome/interface/toolbar_style "icons"

echo "Done!"
echo 

echo "Installing Mac4Lin Icons..."
tar -xzf Icons/Mac4Lin_Icons_v1.0.tar.gz -C ~/.icons/
gconftool-2 --type string --set /desktop/gnome/interface/icon_theme "Mac4Lin_Icons_v1.0"

echo "Done!"
echo 

echo "Installing Mac4Lin Cursors..."
tar -xzf Cursor/Mac4Lin_Cursors_v1.0.tar.gz -C ~/.icons/

echo "Done! Please enable the cursor theme from Appearances."
echo "Alternatively, you can select the Mac4Lin Aqua/Graphite Meta package to enable everything with one click"
echo 

#echo "Transforming Terminal..."
#gconftool-2 --load Mac4Lin_Terminal
#gconftool-2 --type string --set /apps/gnome-terminal/global/default_profile "Profile0"
#echo "Done!"
#echo

echo "Installing Mac4Lin Emerald Window Borders..."
if [ -d ~/.emerald]
then
echo
else
mkdir -p ~/.emerald/themes
mkdir -p ~/.emerald/theme
fi

tar -xzf Emerald/Mac4Lin_Emerald_Aqua_v1.0.tar.gz -C ~/.emerald/themes
tar -xzf Emerald/Mac4Lin_Emerald_Graphite_v1.0.tar.gz -C ~/.emerald/themes
tar -xzf Emerald/Mac4Lin_Emerald_Aqua_v1.0.tar.gz -C ~/.emerald/theme

echo "Done!"
echo 

echo "Do you want to enable Metacity Compositor? If you are unsure about this or use Compiz, type 'n' [y/n]? "
read ans1

if [ $ans1 = y -o $ans1 = Y ]; then
echo "Enabling Metacity compositor..."
gconftool-2 --type boolean --set /apps/metacity/general/compositing_manager TRUE
echo "Done!"
echo
else
echo
fi

echo "Installing Mac4Lin misc. componenets..."
mkdir -p ~/.purple/plugins
cp AWN/Plugins/Pidgin_AWN_32bit/pidgin_awn.so ~/.purple/plugins/
mkdir -p ~/.xmms/Skins
mkdir -p ~/.bmp/Skins
cp MP/Mac4Lin_MP_v1.0.tar.gz ~/.xmms/Skins/
cp MP/Mac4Lin_MP_v1.0.tar.gz ~/.bmp/Skins/
gconftool-2 --type boolean --set /apps/gnome-session/options/show_splash_screen FALSE
gconftool-2 --type string --set /apps/panel/toplevels/top_panel_screen0/background/image "$HOME/.themes/Mac4Lin_GTK_Aqua_v1.0/gtk-2.0/Panel/panel-bg.png"
gconftool-2 --type string --set /apps/panel/default_setup/toplevels/top_panel/background/type "image"
gconftool-2 --type string --set /apps/panel/default_setup/toplevels/bottom_panel/background/type "image"
gconftool-2 --type string --set /apps/panel/default_setup/toplevels/top_panel/background/image "$HOME/.themes/Mac4Lin_GTK_Aqua_v1.0/gtk-2.0/Panel/panel-bg.png"
gconftool-2 --type string --set /apps/panel/toplevels/top_panel_screen0/background/type "image"
gconftool-2 --type string --set /apps/panel/default_setup/toplevels/bottom_panel/background/image "$HOME/.themes/Mac4Lin_GTK_Aqua_v1.0/gtk-2.0/Panel/panel-bg.png"
gconftool-2 --type string --set /apps/panel/toplevels/top_panel_screen0/background/type "image"

gconftool-2 --type boolean --set /desktop/gnome/interface/buttons_have_icons FALSE
gconftool-2 --type boolean --set /apps/nautilus/preferences/start_with_location_bar FALSE

mkdir -p ~/.fonts
tar -xzf Fonts/fonts.tar.gz -C ~/.fonts/
mkdir -p ~/Mac4Lin_v1.0/GRUB
mkdir -p ~/Mac4Lin_v1.0/Usplash
mkdir -p ~/Mac4Lin_v1.0/AWN/Pidgin_32bit
mkdir -p ~/Mac4Lin_v1.0/AWN/Pidgin_64sbit
mkdir -p ~/Mac4Lin_v1.0/Mozilla/Firefox
mkdir -p ~/Mac4Lin_v1.0/Mozilla/Thunderbird

cp GRUB/*.* ~/Mac4Lin_v1.0/GRUB/
cp Usplash/*.* ~/Mac4Lin_v1.0/Usplash/

cp -r AWN/*.* ~/Mac4Lin_v1.0/AWN
cp -r AWN/Plugins/*.* ~/Mac4Lin_v1.0/AWN
cp AWN/Plugins/Pidgin_AWN_32bit/pidgin_awn.so ~/Mac4Lin_v1.0/AWN/Pidgin_32bit
cp AWN/Plugins/Pidgin_AWN_64bit/pidgin_awn.so ~/Mac4Lin_v1.0/AWN/Pidgin_64bit
cp -r Mozilla/Firefox/*.* ~/Mac4Lin_v1.0/Mozilla/Firefox
cp -r Mozilla/Thunderbird/*.* ~/Mac4Lin_v1.0/Mozilla/Thunderbird

echo
echo "Done! Nautilus location bar is now disabled by default"
echo "~/Mac4Lin_v1.0 directory contains the components which are to be installed manually. Please install the Mozilla UI manually"
echo "If you use a 64bit install, you will need to manually install the AWN Pidgin 64bit plugin from ~/Mac4Lin_v1.0/AWN"

echo "Installing Mac4Lin Backgrounds..."
mkdir -p ~/Mac4Lin_v1.0/Wallpapers
cp Wallpapers/*.* ~/Mac4Lin_v1.0/Wallpapers
gconftool-2 --type string --set /desktop/gnome/background/picture_filename "~/Mac4Lin_v1.0/Wallpapers/Mac4Lin_Wallpaper1.jpg"

echo "Done!"
echo

echo
echo "The following componenets require root access. You can opt out of installing them as they can be manually installed as well."
echo "Would you like to install these components. If unsure, type 'n' [y/n]? "
read ans

if [ $ans = y -o $ans = Y ]; then

echo "Installing Mac4Lin GDM Login Theme and Sounds..."
sudo tar -xzf GDM/Mac4Lin_GDM_v1.0.tar.gz -C /usr/share/gdm/themes/
sudo tar -xzf Sounds/Mac4Lin_Sounds_v1.0.tar.gz -C /usr/share/sounds/
sudo tar -xzf Sounds/Mac4Lin_Pidgin-Sounds_v1.0.tar.gz -C /usr/share/sounds/

echo "Done!"
echo
echo
echo "Please set the Mac4Lin GDM Theme manually by going to System > Admin > Login Window > Local > Theme"
echo 

sudo cp /etc/gdm/gdm.conf /etc/gdm/gdm.conf.mac4linbackup

THEME_DIR=/usr/share/gdm/themes
THEMES=Mac4Lin_GDM_v1.0
N=`echo $THEMES | wc -w`
sudo sed -i.old s/GraphicalTheme=.*/GraphicalTheme=`echo $THEMES | cut -d ' ' -f $N`/  /etc/gdm/gdm.conf

THEME_DIR=~/.themes
THEMES=Mac4Lin_GTK_Aqua_v1.0
N=`echo $THEMES | wc -w`
sudo sed -i.old s/GtkTheme=.*/GtkTheme=`echo $THEMES | cut -d ' ' -f $N`/  /etc/gdm/gdm.conf
echo
echo "Please assign the sounds to events manually (OS wide as well as Pidgin). All the audio files are in /usr/share/sounds directory"
echo 
echo

echo
echo "Installing Pidgin theme..."
mkdir -p ~/Mac4Lin_v1.0/Backup
tar -cf ~/Mac4Lin_v1.0/Backup/pidgin_backup.tar.gz /usr/share/pixmaps/pidgin/
sudo tar -xzf Pidgin/Mac4Lin_Pidgin_v1.0.tar.gz -C /usr/share/pixmaps/

echo "Done!"
echo "The current Pidgin theme has been backed up as ~/Mac4Lin_v1.0/Backup/pidgin_backup.tar.gz"
echo "Please enable the Pidgin AWN plugin from within Pidgin and place a launcher for Pidgin on AWN"
echo

else
echo "Components requiring root access not installed. Install them manually"

fi

echo "****************************************"
echo "     Mac4Lin installation complete!"
echo "  Please refer to the documentation for"
echo "   advanced installation instructions"
echo "   (for usplash, grub, tweaks etc.)"
echo " For best results, log off and log back"
echo "   in for all changes to be applied"
echo "****************************************"
echo
echo
echo "Homepage: http://sourceforge.net/projects/mac4lin"

echo
echo
key=""
echo -n "Press any key to continue..."
stty -icanon
key=`dd count=1 2>/dev/null`
stty icanon
echo
