/*
**  stdlib.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _STDLIB_H
#define _STDLIB_H

typedef struct {
    int quot;           /* quotient */
    int rem;            /* remainder */
} div_t;
typedef div_t ldiv_t;

#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short wchar_t;
#endif  /* _WCHAR_T */

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif  /* _SIZE_T */

#ifndef NULL
#if defined(__STDC__) || defined(__NDPX__)
#define NULL    ((void *)0L)
#else
#define NULL    ((char *)0L)
#endif
#endif  /* NULL */

#define EXIT_FAILURE        1
#define EXIT_SUCCESS        0
#define RAND_MAX            65536
#define MB_CUR_MAX          sizeof(wchar_t)

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

double    atof(const char *_Nptr);
int       atoi(const char *_Nptr);
long int  atol(const char *_Nptr);
double    strtod(const char *_Nptr, char **_Endptr);
long int  strtol(const char *_Nptr, char **_Endptr, int _Base);
unsigned long int strtoul(const char *_Nptr, char **_Endptr, int _Base);
int       rand(void);
void      srand(unsigned int _Seed);
void *    calloc(size_t _Nmemb, size_t _Size);
void      free(void *_Ptr);
void *    malloc(size_t _Size);
void *    realloc(void *_Ptr, size_t _Size);
void      abort(void);
int       atexit(void (*_Func)(void));
void      exit(int _Status);
char *    getenv(const char *_Name);
int       system(const char *_String);
void *    bsearch(const void *_Key, const void *_Base,
                size_t _Nmemb, size_t _Size,
                int (*_Compar)(const void *, const void *));
void      qsort(void *_Base, size_t _Nmemb, size_t _Size,
                int (*_Compar)(const void *, const void *));

int       abs(int);
div_t     div(int _Number, int _Denom);
long int  labs(long int);
ldiv_t    ldiv(long int _Number, long int _Denom);
int       mblen(const char *, size_t);
int       mbtowc(wchar_t *_Pwc, const char *_S, size_t _N);
int       wctomb(char *, wchar_t);
size_t    mbstowcs( wchar_t *_Pwcs, const char *_S, size_t _N);
size_t    wcstombs( char *_S, const wchar_t *_Pwcs, size_t _N);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

double    atof();
int       atoi();
long int  atol();
double    strtod();
long int  strtol();
unsigned long int strtoul();
int       rand();
void      srand();
char *    calloc();
void      free();
char *    malloc();
char *    realloc();
void      abort();
int       atexit();
void      exit();
char *    getenv();
int       system();
char *    bsearch();
void      qsort();

int       abs();
#define   abs(j)  ((j)<0?-(j):(j))
/* the compiler can recognize the above construct and will produce better code */
div_t     div();
long int  labs();
#define   labs(j)  ((j)<0?-(j):(j))
ldiv_t    ldiv();
int       mblen();
int       mbtowc();
int       wctomb();
size_t    mbstowcs();
size_t    wcstombs();

#endif  /* __STDC__ || __NDPX__ */
#endif    /* _STDLIB_H */

