/*
**  setjmp.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _SETJMP_H
#define _SETJMP_H

/*
   jmp_buf is used for all architectures, it is big enough to save the
   necessary registers for all architectures that have been encountered,
   and is double aligned (as some architectures require).  If this needs
   to be modified for a new architecture, then the master copy should be
   updated so that it will work for all architectures.
*/

/* typedef int jmp_buf[16];   */
/* typedef long jmp_buf[84];  */
typedef long jmp_buf[200];

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

int       setjmp(jmp_buf env);
void      longjmp(jmp_buf env, int val);

#ifdef __NDPX__                 /* C++ */
   }
#endif

#else                           /* K&R */

int       setjmp();
void      longjmp();

#endif  /* __STDC__ || __NDPX__ */

#endif  /* _SETJMP_H */

