/*
**  search.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _SEARCH_H
#define _SEARCH_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif  /* _SIZE_T */

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __NDPX__     /* C++ */
    extern "C" {
#endif

void *    bsearch(const void *_Key, const void *_Base,
                size_t _Nmemb, size_t _Size,
                int (*_Compar)(const void *, const void *));
char *    lfind(const char *_Key, const char *_Base, unsigned *_Num,
                unsigned _Width,
                int (*_Compare)(const void *_Elem1, const void *_Elem2));
char *    lsearch(const char *_Key, const char *_Base, unsigned *_Num,
                unsigned _Width,
                int (*_Compare)(const void *_Elem1, const void *_Elem2));
void      qsort(void *_Base, size_t _Nmemb, size_t _Size,
                int (*_Compar)(const void *, const void *));


#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

void *    bsearch();
char *    lfind();
char *    lsearch();
void      qsort();

#endif /* __STDC__ || __NDPX__ */

#endif /* _SEARCH_H */
