/*
**  math.h              ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _MATH_H
#define _MATH_H

#define HUGE_VAL        _HugeDVAL._U._Dval
#define _HUGE_FLT       _HugeFVAL._U._Fval

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

double    acos(double );
double    asin(double );
double    atan(double );
double    atan2(double , double );
double    cos(double );
double    sin(double );
double    tan(double );
double    cosh(double );
double    sinh(double );
double    tanh(double );
double    exp(double );
double    frexp(double , int * );
double    ldexp(double , int );
double    log(double );
double    log10(double );
double    modf(double , double * );
double    pow(double , double );
double    sqrt(double );
double    ceil(double );
double    fabs(double );
double    floor(double );
double    fmod(double , double );

float     acosf(float );
float     asinf(float );
float     atanf(float );
float     atan2f(float );
float     cosf(float );
float     sinf(float );
float     tanf(float );
float     coshf(float );
float     sinhf(float );
float     tanhf(float );
float     expf(float );
float     frexpf(float , int *);
float     ldexpf(float , int );
float     logf(float );
float     log10f(float );
float     powf(float, float );
float     sqrtf(float );

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

double    acos();
double    asin();
double    atan();
double    atan2();
double    cos();
double    sin();
double    tan();
double    cosh();
double    sinh();
double    tanh();
double    exp();
double    frexp();
double    ldexp();
double    log();
double    log10();
double    modf();
double    pow();
double    sqrt();
double    ceil();
double    fabs();
double    floor();
double    fmod();

float     acosf();
float     asinf();
float     atanf();
float     atan2f();
float     cosf();
float     sinf();
float     tanf();
float     coshf();
float     sinhf();
float     tanhf();
float     expf();
float     frexpf();
float     ldexpf();
float     logf();
float     log10f();
float     powf();
float     sqrtf();

#endif  /* __STDC__ || __NDPX__ */

/* HUGE_VAL will be represented as double for infinity */
struct _DHVAL {
    union {
        unsigned long _ULval[2];
        double _Dval;
    }_U;
};

extern struct _DHVAL _HugeDVAL;

/* _HUGE_FLT is provided as the float analog to HUGE_VAL for functions
   taking and returning float values
*/
struct _FHVAL {
    union {
        unsigned long _ULval;
        float _Fval;
    }_U;
};

extern struct _FHVAL _HugeFVAL;

#endif  /* _MATH_H */

