/*  
**  malloc.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _MALLOC_H
#define _MALLOC_H

#ifndef _OS_H

#define _HEAPEMPTY      (-1)
#define _HEAPOK         (-2)
#define _HEAPBADBEGIN   (-3)
#define _HEAPBADNODE    (-4)
#define _HEAPEND        (-5)
#define _HEAPBADPTR     (-6)

#define _FREEENTRY      0
#define _USEDENTRY      1

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif  /* _SIZE_T */

struct _heapinfo {
    int * _pentry;
    size_t _size;
    int _useflag;
};


#define _fcalloc( _A, _B ) calloc( (_A), (_B) )
#define _ncalloc( _A, _B ) calloc( (_A), (_B) )

#define _fmalloc(_A) malloc(_A)
#define _nmalloc(_A) malloc(_A)
#define   halloc(_A) malloc(_A)


#define _frealloc( _A, _B ) realloc( (_A), (_B) )
#define _nrealloc( _A, _B ) realloc( (_A), (_B) )

#define _ffree(_A) free(_A)
#define _nfree(_A) free(_A)
#define  hfree(_A) free(_A)

#define _fmsize(_A) _msize(_A)
#define _nmsize(_A) _msize(_A)

#define _fheapchk() _heapchk()
#define _nheapchk() _heapchk()

#define _fheapset() _heapset()
#define _nheapset() _heapset()

#define _fheapwalk() _heapwalk()
#define _nheapwalk() _heapwalk()

#define _fheapmin() _heapmin()
#define _nheapmin() _heapmin()

#endif /* _OS_H */


#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__     /* C++ */
    extern "C" {
#endif

void *    calloc(size_t _Nmemb, size_t _Size);
void      free(void *_Ptr);
void *    malloc(size_t _Size);
void *    realloc(void *_Ptr, size_t _Size);

int      _heapchk(void);
int      _heaprun(void);
int      _heapset(unsigned _Fill);
int      _heapwalk(struct _heapinfo *);

size_t   _memavl(void);
size_t   _memmax(void);
size_t   _msize(void *);


#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

char *    calloc();
void      free();
char *    malloc();
char *    realloc();

int      _heapchk();
int      _heaprun();
int      _heapset();
int      _heapwalk();

size_t   _memavl();
size_t   _memmax();
size_t   _msize();

#endif /* __STDC__ || __NDPX__ */
#endif /* _MALLOC_H */
