/*
**  io.h                ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _IO_H
#define _IO_H

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

int       access(const char *_Pathname, int _Mode);
int       chmod(const char *_Path, int _Pmode);
int       chsize(int _Handle, long _Size);
int       close(int _Fno);
int       creat(const char *, int);
int       dup(int _Handle);
int       dup2(int _Handle1, int _Handle2);
int       eof(int _Handle);
long      filelength(int _Handle);
int       isatty(int _Fno);
long      lseek(int _Fno, long _Offset, int End);
int       locking(int _Handle, int _Mode, long _Nbyte);
char *    mktemp(char *);
int       open(const char *, int, ...);
int       read(int _Fno, void *_Buf, unsigned _Size);
int       remove(const char *_Filename);
int       rename(const char *_Old, const char *_New);
int       setmode(int _Handle, int _Mode);
int       sopen(const char *_Path, int _Oflag, int _Shflag, ...);
long      tell(int _Handle);
int       unlink(char *_Path);
int       write(int _Fno, const void *_Buf, unsigned int _Size);


#ifdef __NDPX__         /* C++ */
   }
#endif

#else /* K&R */

int       access();
int       chmod();
int       chsize();
int       close();
int       creat();
int       dup();
int       dup2();
int       eof();
long      filelength();
int       isatty();
long      lseek();
int       locking();
char *    mktemp();
int       open();
int       read();
int       remove();
int       rename();
int       setmode();
int       sopen();
long      tell();
int       unlink();
int       write();

#endif /* __STDC__ || __NDPX__ */

#endif /* _IO_H */
