/*
**  grex.h      ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifdef __MSDOS__
#ifndef _GREX_H
#define _GREX_H

typedef struct {int x,y; } xypt;

struct bitmap_font {
    char * table;
    int width;
    int height;
    };

extern struct bitmap_font current_font;

extern int _virtual_grex;
extern int _virtual_grex_limx;
extern int _virtual_grex_limy;
extern unsigned char * _virtual_grex_buffer;

/*----------------------------------------------------------------------*\
 |                                                                      |
 |                 Return types of i860 functions                       |
 |                                                                      |
 | Because the i860 interface is buffered, a significant performance    |
 | advantage is gained by not requiring a return value in cases where   |
 | the value returned is not needed. This consideration does not apply  |
 | to host-resident programs because there is no cost associated with   |
 | ignoring an unwanted return value on the host.                       |
 |                                                                      |
 | Our solution is to specify that some functions which would otherwise |
 | return values will, on the i860, return none. The conditional        |
 | typedefs below show these changes                                    |
 |                                                                      |
\*----------------------------------------------------------------------*/

/* Typedefs for i860 dependent return values */
#ifndef __TDEFS
#define __TDEFS

#ifdef __i860

typedef void _int;
typedef void _unsigned;
typedef int  _pchar;
typedef int  _pvoid;

#else

typedef int      _int;
typedef unsigned _unsigned;
typedef char *   _pchar;
typedef void *   _pvoid;

#endif
#endif /* __TDEFS */

/*----------------------------------------------------------------------*/

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

_pvoid    address (int x, int y);
int       aspect_ratio (int mode);
int       box_text_window (short * win, int type, int attr);
_int      clear (void);
_int      clear_text (void);
int       clear_text_window (short * win, int attr);
int       copy_subwindow (char *src, int w, int h,
                int x1, int y1, int x2, int y2, char *dst);
int       copy_text_subwindow (short *src,
                int x1, int y1, int x2, int y2, short *dst);
_int      cr (void);
short *   create_text_subwindow (short * win,
                int wx1, int wy1, int wx2, int wy2);
short *   create_text_window (int w, int h, int attr);
char *    create_window (int w, int h);
_int      crlf (void);
_int      define_color (int code, int value);
_int      display_text_page (int page);
_int      dn_cursor (void);
_int      draw (int x, int y);
int       filled_ellipse (int x, int y, int height, int width);
_int      filled_rectangle (int xul, int yul, int xlr, int ylr);
_int      flood_fill (int x, int y, int fill, int border);
int       free_text_window (short *win);
int       get_active_attribute (void);
int       get_active_page (void);
int       get_active_text_page (void);
int       get_bios_mode (void);
_int      get_clip_limits (int * xmin, int * ymin,
                        int * xmax, int * ymax);
int       get_color (void);
int       get_cursor (int * x, int * y);
unsigned  get_dash (void);
int       get_device_limits (int * limx, int * limy, int * max_color);
int       get_display_page (void);
unsigned  get_fill_mask (void);
void      get_mouse (int * buttons, int * x, int * y);
int       get_pixel (int x, int y);
int       get_press (int button, int * count, int * x, int * y);
int       get_release (int button, int * count, int * x, int * y);
int       get_video_mode (int * max_row, int * max_col);
int       graphic_page_count (void);
_int      graphic_text (char * string, int x, int y, int color);
int       graphics_mode (int mode);
int       hide_cursor (void);
void      hide_mouse_cursor (void);
_int      home (void);
_int      horizontal_line (int x1, int y, int x2);
int       init_mouse (void);
int       is_a_mouse_present (void);
_int      lf (void);
_int      locate (int x, int y);
_int      lt_cursor (void);
void      magnify_text (int h, int v);
void      mouse_viewport (int xmin, int xmax, int ymin, int ymax);
_int      move (int x, int y);
_int      move_cursor (int x, int y);
int       open_ellipse (int x, int y, int height, int width);
int       pan_text_window (short * win, int count, int attr);
int       physical_screen (void);
_int      place_string_at (int x, int y, char * string);
int       polyfill (xypt *xy, int n, int inside, int border);
int       read_attr (void);
int       read_char (void);
void      read_motion (int * mx, int * my);
int       read_text_window (short * win, int x, int y, char *str, int n);
char      *read_windows_font (char *fntname);
int       reshape_text_window (short * win, int w, int h);
_int      restore_text_window (int x1, int y1, short * buffer);
_int      restore_window (int x1, int y1, int x2, int y2, char * buffer);
_int      rt_cursor (void);
_int      save_text_window (int x1, int y1, int x2, int y2,
                        short * buffer);
_int      save_window (int x1, int y1, int x2, int y2, char * buffer);
_int      scroll_active_page_down (int x1, int y1, int x2, int y2,
                        int n, int attr);
_int      scroll_active_page_up (int x1, int y1, int x2, int y2,
                        int n, int attr);
int       scroll_text_window (short * win, int count, int attr);
_int      set25line (void);
_int      set43line (void);
_int      set_active_attribute (int attr);
_int      set_active_page (int page);
_int      set_active_text_page (int page);
void      set_bios_mode (int mode);
void      set_border_color (int color);
_int      set_clip_limits (int xmin, int ymin, int xmax, int ymax);
_int      set_color (int color);
_int      set_cursor_type (int top, int bottom);
_int      set_dash (int dash);
_int      set_display_page (int page);
_unsigned set_fill_mask (int mask);
_int      set_font_8x14 (void);
_int      set_font_8x16 (void);
_int      set_font_8x8 (void);
void      set_mouse (int x, int y);
void      set_mouse_cursor (int x, int y, int rm_seg);
void      set_mp_ratio (int xr, int yr);
_int      set_palette (char * palette);
_int      set_pixel (int x, int y);
_int      set_pixel_function (int method);
void      set_subroutine (int event, int offset, int segment);
int       set_user_font (char * table, int width, int height);
_int      set_video_mode (int mode);
void      set_windows_font (char *font);
_int      set_xor (int q);
int       shift_window (char * window, int width, int height, int count);
void      show_mouse_cursor (void);
int       size_window (int x1, int y1, int x2, int y2);
int       super_vga (int code, int nx, int ny);
_int      text_mode (void);
void      turn_off_blink (void);
void      turn_on_blink (void);
_int      up_cursor (void);
void      use_grex_fonts (void);
void      use_windows_fonts (void);
_int      vertical_text (char * string, int x, int y, int color);
void      vga_palette (int reg, int red, int green, int blue);
int       video_configuration (int * device);
int       virtual_screen (char * buffer, int limx, int limy);
int       whchar (int key, int x, int y, char *font, int color);
int      _where (int * x, int * y);
_int      write_char (char c, int n);
_int      write_char_attr (char c, int n, int attr);
_int      write_one_char (char c);
int       write_string (char * string);
int       write_text_screen (char *filename);
int       write_text_window (short * win, int x, int y,
                        char *str, int attr);
int       wvchar (int key, int x, int y, char *buffer, int color);

#ifdef __NDPX__                 /* C++ */
   }
#endif
#else                           /* K&R */

_pchar    address                 ();
int       aspect_ratio            ();
int       box_text_window         ();
_int      clear                   ();
_int      clear_text              ();
int       clear_text_window       ();
int       copy_subwindow          ();
int       copy_text_subwindow     ();
_int      cr                      ();
short *   create_text_subwindow   ();
short *   create_text_window      ();
char *    create_window           ();
_int      crlf                    ();
_int      define_color            ();
_int      display_text_page       ();
_int      dn_cursor               ();
_int      draw                    ();
_int      filled_ellipse          ();
_int      filled_rectangle        ();
_int      flood_fill              ();
int       get_active_attribute    ();
int       get_active_page         ();
int       get_active_text_page    ();
_int      get_clip_limits         ();
int       get_color               ();
int       get_cursor              ();
unsigned  get_dash                ();
int       get_device_limits       ();
int       get_display_page        ();
unsigned  get_fill_mask           ();
void      get_mouse               ();
int       get_pixel               ();
int       get_press               ();
int       get_release             ();
int       get_video_mode          ();
int       graphic_page_count      ();
_int      graphic_text            ();
int       graphics_mode           ();
int       hide_cursor             ();
void      hide_mouse_cursor       ();
_int      home                    ();
_int      horizontal_line         ();
int       init_mouse              ();
int       is_a_mouse_present      ();
_int      lf                      ();
_int      locate                  ();
_int      lt_cursor               ();
void      magnify_text            ();
void      mouse_viewport          ();
_int      move                    ();
_int      move_cursor             ();
_int      open_ellipse            ();
int       pan_text_window         ();
int       physical_screen         ();
_int      place_string_at         ();
_int      polyfill                ();
int       read_attr               ();
int       read_char               ();
void      read_motion             ();
int       read_text_window        ();
char *    read_windows_font       ();
int       reshape_text_window     ();
void      restore_isr             ();
_int      restore_text_window     ();
_int      restore_window          ();
_int      rt_cursor               ();
_int      save_text_window        ();
_int      save_window             ();
_int      scroll_active_page_down ();
_int      scroll_active_page_up   ();
int       scroll_text_window      ();
_int      set25line               ();
_int      set43line               ();
_int      set_active_attribute    ();
_int      set_active_page         ();
_int      set_active_text_page    ();
void      set_bios_mode           ();
void      set_border_color        ();
_int      set_clip_limits         ();
_int      set_color               ();
_int      set_cursor_type         ();
_int      set_dash                ();
_int      set_display_page        ();
_unsigned set_fill_mask           ();
_int      set_font_8x14           ();
_int      set_font_8x16           ();
_int      set_font_8x8            ();
void      set_mouse               ();
void      set_mouse_cursor        ();
void      set_mp_ratio            ();
_int      set_palette             ();
_int      set_pixel               ();
_int      set_pixel_function      ();
void      set_subroutine          ();
int       set_user_font           ();
_int      set_video_mode          ();
void      set_windows_font        ();
_int      set_xor                 ();
int       shift_window            ();
void      show_mouse_cursor       ();
int       size_window             ();
int       super_vga               ();
_int      text_mode               ();
void      turn_off_blink          ();
void      turn_on_blink           ();
_int      up_cursor               ();
void      use_grex_fonts          ();
void      use_windows_fonts       ();
_int      vertical_text            ();
void      vga_palette             ();
int       video_configuration     ();
int       virtual_screen          ();
int       whchar                  ();
int      _where                   ();
_int      write_char              ();
_int      write_char_attr         ();
_int      write_one_char          ();
_int      write_string            ();
int       write_text_screen       ();
int       write_text_window       ();
int       wvchar                  ();

#endif  /* __STDC__ || __NDPX__ */

/* Microsoft-compatible structures */

struct videoconfig { int numxpixels; int numypixels; int numtextcols;
    int numtextrows; int numcolors; int bitsperpixel; int numvideopages;
    int mode; int adapter; int monitor; int memory;};
struct xycoord { int xcoord; int ycoord;};
struct rccoord { int row; int col;};

/* Microsoft-compatible functions */

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

int      _arc (int, int, int, int, int, int, int, int);
void     _clearscreen (int);
int      _displaycursor (int);
int      _ellipse (int, int, int, int, int);
int      _floodfill (int, int, int);
long     _getbkcolor (void);
int      _getcolor (void);
struct xycoord  _getcurrentposition (void);
unsigned char * _getfillmask (unsigned char *);
void     _getimage (int, int, int, int, char *);
unsigned _getlinestyle (void);
struct xycoord  _getlogcoord (int, int);
struct xycoord  _getphyscoord (int, int);
int      _getpixel (int, int);
int      _gettextcolor (void);
struct rccoord  _gettextposition (void);
long     _imagesize (int, int, int, int);
int      _lineto (int, int);
struct xycoord  _moveto (int, int);
void     _outtext (char *);
int      _pie (int, int, int, int, int, int, int, int, int);
void     _putimage (int, int, char *, int);
int      _rectangle (int, int, int, int, int);
int      _remapallpalette (long *);
long     _remappalette (int, long);
int      _selectpalette (int);
long     _setbkcolor (long);
void     _setcliprgn (int, int, int, int);
int      _setcolor (int);
void     _setfillmask (unsigned char *);
void     _setlinestyle (unsigned int);
struct xycoord  _setlogorg (int, int);
int      _setpixel (int, int);
int      _settextcolor (int);
struct rccoord  _settextposition (int, int);
int      _settextwindow (int, int, int, int);
void     _setviewport (int, int, int, int);
int      _wrapon (int);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

int      _arc                ();
void     _clearscreen        ();
int      _displaycursor      ();
int      _ellipse            ();
int      _floodfill          ();
int      _getbkcolor         ();
int      _getcolor           ();
struct xycoord  _getcurrentposition ();
unsigned char * _getfillmask        ();
void     _getimage           ();
unsigned int    _getlinestyle       ();
struct xycoord  _getlogcoord        ();
struct xycoord  _getphyscoord       ();
int      _getpixel           ();
int      _gettextcolor       ();
struct rccoord  _gettextposition    ();
long     _imagesize          ();
int      _lineto             ();
struct xycoord  _moveto             ();
void     _outtext            ();
int      _pie                ();
void     _putimage           ();
int      _rectangle          ();
int      _remapallpalette    ();
long     _remappalette       ();
int      _selectpalette      ();
int      _setactivepage      ();
int      _setbkcolor         ();
void     _setcliprgn         ();
int      _setcolor           ();
void     _setfillmask        ();
void     _setlinestyle       ();
struct xycoord  _setlogorg          ();
int      _setpixel           ();
int      _settextcolor       ();
struct rccoord  _settextposition    ();
int      _settextwindow      ();
int      _setvideomode       ();
void     _setviewport        ();
int      _setvisualpage      ();
int      _wrapon             ();

#endif  /* __STDC__ || __NDPX__ */

#endif  /* _GREX_H   */
#endif  /* __MSDOS__ */

