/*
**  assert.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#undef assert

#ifdef NDEBUG

#define assert(_Ignore)

#else

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

void _Assert(const char *, int, const char *);

#ifdef __NDPX__         /* C++ */
   }
#endif

#define assert(_Value)  \
        (!(_Value) ? _Assert(#_Value,__LINE__,__FILE__) : (void)0)

#else

/* K&R C doesn't allow void expressions in ?: operators */
void _Assert();
#define assert(_Value)  if (!(_Value)) _Assert(#_Value,__LINE__,__FILE__)

#endif /* __STDC__ || __NDPX__ */
#endif /* NDEBUG */
