/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.overrides;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideChecker$validateFakeOverrides$;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideChecker;", "", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "descriptorMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;", "<init>", "(Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$DescriptorMangler;)V", "checkOverriddenSymbols", "", "fake", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "validateFakeOverrides", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compatibleMode", "", "check", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideChecker.kt\norg/jetbrains/kotlin/backend/common/overrides/FakeOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1869#2,2:86\n477#3:88\n477#3:90\n1#4:89\n*S KotlinDebug\n*F\n+ 1 FakeOverrideChecker.kt\norg/jetbrains/kotlin/backend/common/overrides/FakeOverrideChecker\n*L\n27#1:86,2\n43#1:88\n53#1:90\n*E\n"})
public final class FakeOverrideChecker {
    @NotNull
    private final KotlinMangler.IrMangler irMangler;
    @NotNull
    private final KotlinMangler.DescriptorMangler descriptorMangler;

    public FakeOverrideChecker(@NotNull KotlinMangler.IrMangler irMangler, @NotNull KotlinMangler.DescriptorMangler descriptorMangler) {
        Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
        Intrinsics.checkNotNullParameter((Object)descriptorMangler, (String)"descriptorMangler");
        this.irMangler = irMangler;
        this.descriptorMangler = descriptorMangler;
    }

    private final void checkOverriddenSymbols(IrOverridableMember fake) {
        if (!(fake instanceof IrSimpleFunction)) {
            return;
        }
        Iterable $this$forEach$iv = ((IrSimpleFunction)fake).getOverriddenSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunctionSymbol symbol = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = ((IrSimpleFunction)symbol.getOwner()).getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            boolean bl2 = ((IrClass)irDeclarationParent).getDeclarations().contains(symbol.getOwner());
            if (!_Assertions.ENABLED || bl2) continue;
            boolean bl3 = false;
            String string = "CHECK overridden symbols: " + RenderIrElementKt.render$default(fake, null, 1, null) + " refers to " + RenderIrElementKt.render$default((IrElement)symbol.getOwner(), null, 1, null) + " which is not a member of " + RenderIrElementKt.render$default(((IrSimpleFunction)symbol.getOwner()).getParent(), null, 1, null);
            throw new AssertionError((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFakeOverrides(IrClass clazz, boolean compatibleMode) {
        List list;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstance$iv2;
        ClassId classId = AdditionalIrUtilsKt.getClassId(clazz);
        if (classId == null) {
            return;
        }
        ClassId classId2 = classId;
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule(AdditionalIrUtilsKt.getModule(clazz)), classId2);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() == ClassKind.ENUM_ENTRY) {
            return;
        }
        MemberScope memberScope2 = classDescriptor2.getUnsubstitutedMemberScope();
        Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"getUnsubstitutedMemberScope(...)");
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)MemberScopeKt.getDescriptorsFiltered$default(memberScope2, DescriptorKindFilter.CALLABLES, null, 2, null));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)validateFakeOverrides$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence descriptorFakeOverrides = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)sequence3, FakeOverrideChecker::validateFakeOverrides$lambda$2), FakeOverrideChecker::validateFakeOverrides$lambda$3);
        List $this$validateFakeOverrides_u24lambda_u246 = $i$f$filterIsInstance = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)descriptorFakeOverrides, arg_0 -> FakeOverrideChecker.validateFakeOverrides$lambda$5(this, compatibleMode, arg_0)));
        boolean bl = false;
        CollectionsKt.sort((List)$this$validateFakeOverrides_u24lambda_u246);
        List descriptorSignatures = $i$f$filterIsInstance;
        $this$validateFakeOverrides_u24lambda_u246 = CollectionsKt.asSequence((Iterable)clazz.getDeclarations());
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence4 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)validateFakeOverrides$$inlined$filterIsInstance$2.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence4, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence irFakeOverrides = SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)sequence4, FakeOverrideChecker::validateFakeOverrides$lambda$7), arg_0 -> FakeOverrideChecker.validateFakeOverrides$lambda$8(this, arg_0));
        List $this$validateFakeOverrides_u24lambda_u2411 = list = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)irFakeOverrides, arg_0 -> FakeOverrideChecker.validateFakeOverrides$lambda$10(this, compatibleMode, arg_0)));
        boolean bl2 = false;
        CollectionsKt.sort((List)$this$validateFakeOverrides_u24lambda_u2411);
        List irSignatures = list;
        if (!irSignatures.containsAll(descriptorSignatures)) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("[IR VALIDATION] Internal fake override mismatch for ");
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(clazz);
            Intrinsics.checkNotNull((Object)fqName);
            String string = stringBuilder.append(fqName).append("\n\tDescriptor based: ").append(descriptorSignatures).append("\n\tIR based        : ").append(irSignatures).toString();
            throw new IllegalArgumentException(string.toString());
        }
    }

    static /* synthetic */ void validateFakeOverrides$default(FakeOverrideChecker fakeOverrideChecker, IrClass irClass, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        fakeOverrideChecker.validateFakeOverrides(irClass, bl);
    }

    public final void check(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        IrVisitorsKt.acceptVoid((IrElement)module2, new IrVisitorVoid(this){
            final /* synthetic */ FakeOverrideChecker this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                FakeOverrideChecker.validateFakeOverrides$default(this.this$0, declaration, false, 2, null);
                super.visitClass(declaration);
            }
        });
    }

    private static final boolean validateFakeOverrides$lambda$2(CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
    }

    private static final boolean validateFakeOverrides$lambda$3(CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual((Object)it.getVisibility(), (Object)DescriptorVisibilities.INVISIBLE_FAKE);
    }

    private static final String validateFakeOverrides$lambda$5(FakeOverrideChecker this$0, boolean $compatibleMode, CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinMangler.DescriptorMangler $this$validateFakeOverrides_u24lambda_u245_u24lambda_u244 = this$0.descriptorMangler;
        boolean bl = false;
        return $this$validateFakeOverrides_u24lambda_u245_u24lambda_u244.signatureString(it, $compatibleMode);
    }

    private static final boolean validateFakeOverrides$lambda$7(IrOverridableMember it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IrFakeOverrideUtilsKt.isFakeOverride(it);
    }

    private static final Unit validateFakeOverrides$lambda$8(FakeOverrideChecker this$0, IrOverridableMember it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkOverriddenSymbols(it);
        return Unit.INSTANCE;
    }

    private static final String validateFakeOverrides$lambda$10(FakeOverrideChecker this$0, boolean $compatibleMode, IrOverridableMember it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KotlinMangler.IrMangler $this$validateFakeOverrides_u24lambda_u2410_u24lambda_u249 = this$0.irMangler;
        boolean bl = false;
        return $this$validateFakeOverrides_u24lambda_u2410_u24lambda_u249.signatureString(it, $compatibleMode);
    }
}

