/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.execution.BuildTaskScheduler;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.internal.RunDefaultTasksExecutionRequest;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTasksBuildTaskScheduler
implements BuildTaskScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTasksBuildTaskScheduler.class);
    private final ProjectConfigurer projectConfigurer;
    private final List<BuiltInCommand> builtInCommands;
    private final BuildTaskScheduler delegate;

    public DefaultTasksBuildTaskScheduler(ProjectConfigurer projectConfigurer, List<BuiltInCommand> builtInCommands, BuildTaskScheduler delegate) {
        this.projectConfigurer = projectConfigurer;
        this.builtInCommands = builtInCommands;
        this.delegate = delegate;
    }

    @Override
    public void scheduleRequestedTasks(GradleInternal gradle, @Nullable EntryTaskSelector selector, ExecutionPlan plan) {
        StartParameterInternal startParameter = gradle.getStartParameter();
        if (startParameter.getTaskRequests().size() == 1 && startParameter.getTaskRequests().get(0) instanceof RunDefaultTasksExecutionRequest) {
            ProjectInternal project = gradle.getDefaultProject();
            this.projectConfigurer.configure(project);
            ArrayList<String> defaultTasks = project.getDefaultTasks();
            if (defaultTasks.size() == 0) {
                defaultTasks = new ArrayList<String>();
                for (BuiltInCommand command : this.builtInCommands) {
                    defaultTasks.addAll(command.asDefaultTask());
                }
                LOGGER.info("No tasks specified. Using default task {}", (Object)GUtil.toString(defaultTasks));
            } else {
                LOGGER.info("No tasks specified. Using project default tasks {}", (Object)GUtil.toString(defaultTasks));
            }
            startParameter.setTaskNames(defaultTasks);
        }
        this.delegate.scheduleRequestedTasks(gradle, selector, plan);
    }
}

