/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.TemporaryClassLoader;

public abstract class J2DoPrivHelper {
    private static String lineSeparator = null;
    private static String pathSeparator = null;

    public static String getLineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        return lineSeparator;
    }

    public static String getPathSeparator() {
        if (pathSeparator == null) {
            pathSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("path.separator");
                }
            });
        }
        return pathSeparator;
    }

    public static PrivilegedAction<Object> setAccessibleAction(final AccessibleObject aObj, final boolean flag) {
        return new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                aObj.setAccessible(flag);
                return null;
            }
        };
    }

    public static PrivilegedExceptionAction<Class<?>> getForNameAction(final String className, final boolean initializeBoolean, final ClassLoader classLoader) {
        return new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws ClassNotFoundException {
                return Class.forName(className, initializeBoolean, classLoader);
            }
        };
    }

    public static PrivilegedAction<ClassLoader> getClassLoaderAction(final Class<?> clazz) {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        };
    }

    public static PrivilegedExceptionAction<Field> getDeclaredFieldAction(final Class<?> clazz, final String name) {
        return new PrivilegedExceptionAction<Field>(){

            @Override
            public Field run() throws NoSuchFieldException {
                return clazz.getDeclaredField(name);
            }
        };
    }

    public static PrivilegedAction<Field[]> getDeclaredFieldsAction(final Class<?> clazz) {
        return new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        };
    }

    public static PrivilegedExceptionAction<Method> getDeclaredMethodAction(final Class<?> clazz, final String name, final Class<?>[] parameterTypes) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
        };
    }

    public static PrivilegedAction<Method[]> getDeclaredMethodsAction(final Class<?> clazz) {
        return new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        };
    }

    public static PrivilegedAction<URL> getResourceAction(final Class<?> clazz, final String resource) {
        return new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return clazz.getResource(resource);
            }
        };
    }

    public static <T> PrivilegedExceptionAction<T> newInstanceAction(final Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws IllegalAccessException, InstantiationException {
                if (!Modifier.isAbstract(clazz.getModifiers())) {
                    return clazz.newInstance();
                }
                try {
                    return clazz.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable t) {
                    throw new InstantiationException(t.toString());
                }
            }
        };
    }

    public static PrivilegedAction<ProtectionDomain> getProtectionDomainAction(final Class<?> clazz) {
        return new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        };
    }

    public static PrivilegedAction<ClassLoader> getParentAction(final ClassLoader loader) {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return loader.getParent();
            }
        };
    }

    public static PrivilegedAction<URL> getResourceAction(final ClassLoader loader, final String resource) {
        return new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return loader.getResource(resource);
            }
        };
    }

    public static PrivilegedExceptionAction<Enumeration<URL>> getResourcesAction(final ClassLoader loader, final String resource) throws IOException {
        return new PrivilegedExceptionAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() throws IOException {
                return loader.getResources(resource);
            }
        };
    }

    public static PrivilegedAction<ClassLoader> getSystemClassLoaderAction() {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        };
    }

    public static PrivilegedAction<Boolean> deleteAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.delete() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static PrivilegedAction<Boolean> existsAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return f.exists() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (NullPointerException npe) {
                    return Boolean.FALSE;
                }
            }
        };
    }

    public static PrivilegedAction<Boolean> deleteOnExitAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                f.deleteOnExit();
                return Boolean.TRUE;
            }
        };
    }

    public static PrivilegedAction<File> getAbsoluteFileAction(final File f) {
        return new PrivilegedAction<File>(){

            @Override
            public File run() {
                return f.getAbsoluteFile();
            }
        };
    }

    public static PrivilegedAction<String> getAbsolutePathAction(final File f) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return f.getAbsolutePath();
            }
        };
    }

    public static PrivilegedExceptionAction<String> getCanonicalPathAction(final File f) throws IOException {
        return new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException {
                return f.getCanonicalPath();
            }
        };
    }

    public static PrivilegedAction<Boolean> isDirectoryAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static PrivilegedAction<Boolean> isFileAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.isFile() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static PrivilegedAction<Long> lengthAction(final File f) {
        return new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return f.length();
            }
        };
    }

    public static PrivilegedAction<File[]> listFilesAction(final File f) {
        return new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return f.listFiles();
            }
        };
    }

    public static PrivilegedAction<Boolean> mkdirsAction(final File f) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.mkdirs() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static PrivilegedAction<Boolean> renameToAction(final File from, final File to) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return from.renameTo(to) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static PrivilegedExceptionAction<URL> toURLAction(final File file) throws MalformedURLException {
        return new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws MalformedURLException {
                return file.toURL();
            }
        };
    }

    public static PrivilegedExceptionAction<FileInputStream> newFileInputStreamAction(final File f) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws FileNotFoundException {
                return new FileInputStream(f);
            }
        };
    }

    public static PrivilegedExceptionAction<FileOutputStream> newFileOutputStreamAction(final File f) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws FileNotFoundException {
                return new FileOutputStream(f);
            }
        };
    }

    public static PrivilegedExceptionAction<FileOutputStream> newFileOutputStreamAction(final String f, final boolean append) throws FileNotFoundException {
        return new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws FileNotFoundException {
                return new FileOutputStream(f, append);
            }
        };
    }

    public static PrivilegedExceptionAction<InetAddress> getByNameAction(final String hostname) throws UnknownHostException {
        return new PrivilegedExceptionAction<InetAddress>(){

            @Override
            public InetAddress run() throws UnknownHostException {
                return InetAddress.getByName(hostname);
            }
        };
    }

    public static PrivilegedExceptionAction<Socket> newSocketAction(final InetAddress host, final int port) throws IOException {
        return new PrivilegedExceptionAction<Socket>(){

            @Override
            public Socket run() throws IOException {
                return new Socket(host, port);
            }
        };
    }

    public static PrivilegedExceptionAction<ServerSocket> newServerSocketAction(final int port) throws IOException {
        return new PrivilegedExceptionAction<ServerSocket>(){

            @Override
            public ServerSocket run() throws IOException {
                return new ServerSocket(port);
            }
        };
    }

    public static PrivilegedExceptionAction<Socket> acceptAction(final ServerSocket ss) throws IOException {
        return new PrivilegedExceptionAction<Socket>(){

            @Override
            public Socket run() throws IOException {
                return ss.accept();
            }
        };
    }

    public static PrivilegedAction<Properties> getPropertiesAction() {
        return new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
    }

    public static PrivilegedAction<String> getPropertyAction(final String name) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
    }

    public static PrivilegedAction<String> getPropertyAction(final String name, final String def) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        };
    }

    public static PrivilegedAction<ClassLoader> getContextClassLoaderAction() {
        return new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
    }

    public static PrivilegedAction<Boolean> setContextClassLoaderAction(final ClassLoader loader) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Thread.currentThread().setContextClassLoader(loader);
                return Boolean.TRUE;
            }
        };
    }

    public static PrivilegedAction<Thread> newDaemonThreadAction(final Runnable target, final String name) {
        return new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(target, name);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static PrivilegedExceptionAction<InputStream> openStreamAction(final URL url) throws IOException {
        return new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                return url.openStream();
            }
        };
    }

    public static PrivilegedExceptionAction<Object> getContentAction(final URLConnection con) throws IOException {
        return new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                return con.getContent();
            }
        };
    }

    public static PrivilegedExceptionAction<ZipFile> newZipFileAction(final File f) throws IOException {
        return new PrivilegedExceptionAction<ZipFile>(){

            @Override
            public ZipFile run() throws IOException {
                return new ZipFile(f);
            }
        };
    }

    public static PrivilegedExceptionAction<JarFile> getJarFileAction(final JarURLConnection con) throws IOException {
        return new PrivilegedExceptionAction<JarFile>(){

            @Override
            public JarFile run() throws IOException {
                return con.getJarFile();
            }
        };
    }

    public static PrivilegedExceptionAction<JarEntry> getJarEntryAction(final JarURLConnection con) throws IOException {
        return new PrivilegedExceptionAction<JarEntry>(){

            @Override
            public JarEntry run() throws IOException {
                return con.getJarEntry();
            }
        };
    }

    public static PrivilegedAction<TemporaryClassLoader> newTemporaryClassLoaderAction(final ClassLoader parent) {
        return new PrivilegedAction<TemporaryClassLoader>(){

            @Override
            public TemporaryClassLoader run() {
                return new TemporaryClassLoader(parent);
            }
        };
    }

    public static PrivilegedAction<MultiClassLoader> newMultiClassLoaderAction() {
        return new PrivilegedAction(){

            public MultiClassLoader run() {
                return new MultiClassLoader();
            }
        };
    }

    public static PrivilegedAction<Annotation[]> getAnnotationsAction(final AnnotatedElement element) {
        return new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getAnnotations();
            }
        };
    }

    public static PrivilegedAction<Annotation[]> getDeclaredAnnotationsAction(final AnnotatedElement element) {
        return new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return element.getDeclaredAnnotations();
            }
        };
    }

    public static PrivilegedAction<Boolean> isAnnotationPresentAction(final AnnotatedElement element, final Class<? extends Annotation> annotationClazz) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return element.isAnnotationPresent(annotationClazz) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    public static <T extends Annotation> PrivilegedAction<T> getAnnotationAction(final AnnotatedElement element, final Class<T> annotationClazz) {
        return new PrivilegedAction<T>(){

            @Override
            public T run() {
                return element.getAnnotation(annotationClazz);
            }
        };
    }

    public static <T> PrivilegedAction<Set<ConstraintViolation<T>>> validateAction(final Validator validator, final T arg0, final Class<?>[] groups) {
        return new PrivilegedAction<Set<ConstraintViolation<T>>>(){

            @Override
            public Set<ConstraintViolation<T>> run() {
                return validator.validate(arg0, groups);
            }
        };
    }

    public static <T> PrivilegedAction<ValidatorFactory> buildDefaultValidatorFactoryAction() {
        return new PrivilegedAction<ValidatorFactory>(){

            @Override
            public ValidatorFactory run() {
                return Validation.buildDefaultValidatorFactory();
            }
        };
    }

    public static PrivilegedExceptionAction<URL> createURL(final String url) throws MalformedURLException {
        return new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws MalformedURLException {
                return new URL(url);
            }
        };
    }
}

