/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import com.google.common.net.MediaType;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.net.impl.StripMediaTypeParametersFunction;
import net.shibboleth.shared.primitive.StringSupport;

public final class MediaTypeSupport {
    @Nonnull
    private static final Function<MediaType, MediaType> STRIP_PARAMS = new StripMediaTypeParametersFunction();

    private MediaTypeSupport() {
    }

    public static boolean validateContentType(@Nullable String contentType, @Nonnull Set<MediaType> validTypes, boolean noContentTypeIsValid, boolean isOneOfStrategy) {
        String contentTypeValue = StringSupport.trimOrNull((String)contentType);
        if (contentTypeValue != null) {
            if (isOneOfStrategy) {
                MediaType mediaType = MediaType.parse((String)contentTypeValue);
                for (MediaType validType : validTypes) {
                    if (!mediaType.is(validType)) continue;
                    return true;
                }
                return false;
            }
            MediaType mediaType = MediaType.parse((String)contentTypeValue).withoutParameters();
            return validTypes.stream().map(STRIP_PARAMS).filter(t -> t != null).anyMatch(arg_0 -> ((MediaType)mediaType).equals(arg_0));
        }
        return noContentTypeIsValid;
    }
}

