/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.filter;

import java.util.regex.Pattern;
import org.apache.tomee.loader.filter.Filter;

public class PatternFilter
implements Filter {
    private final Pattern pattern;

    public PatternFilter(String expression) {
        this(Pattern.compile(expression));
    }

    public PatternFilter(Pattern pattern) {
        assert (pattern != null);
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean accept(String name) {
        return this.pattern.matcher(name).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternFilter that = (PatternFilter)o;
        return this.pattern.pattern().equals(that.pattern.pattern());
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "PatternFilter{pattern=" + String.valueOf(this.pattern) + "}";
    }
}

